/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collectionextract;

import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtractedCollection<E, X extends ICollectionExtractor>
implements Iterable<E>,
IObject {
    private static final long serialVersionUID = 2237977092308177450L;
    private final X extractor;
    private final IObject collection;

    public AbstractExtractedCollection(IObject collection, X extractor) {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        if (extractor == null) {
            throw new IllegalArgumentException(Messages.AbstractExtractedCollection_UnhandledCollection);
        }
        this.collection = collection;
        this.extractor = extractor;
    }

    protected X getExtractor() {
        return this.extractor;
    }

    protected IObject getCollection() {
        return this.collection;
    }

    public boolean hasSize() {
        return this.extractor.hasSize();
    }

    public boolean hasExtractableContents() {
        return this.extractor.hasExtractableContents();
    }

    public boolean hasExtractableArray() {
        return this.extractor.hasExtractableArray();
    }

    public boolean hasCapacity() {
        return this.extractor.hasCapacity();
    }

    public boolean hasFillRatio() {
        return this.extractor.hasFillRatio();
    }

    public Integer getCapacity() {
        try {
            return this.extractor.getCapacity(this.collection);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer size() {
        try {
            return this.extractor.getSize(this.collection);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    public Double getFillRatio() {
        try {
            return this.extractor.getFillRatio(this.collection);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    public Boolean isEmpty() {
        Integer size = this.size();
        return size != null ? size > 0 : this.iterator().hasNext();
    }

    public int[] extractEntryIds() {
        try {
            return this.extractor.extractEntryIds(this.collection);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    public IObjectArray extractEntries() {
        try {
            return this.extractor.extractEntries(this.collection);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getRetainedHeapSize() {
        return this.collection.getRetainedHeapSize();
    }

    @Override
    public long getUsedHeapSize() {
        return this.collection.getUsedHeapSize();
    }

    @Override
    public int getObjectId() {
        return this.collection.getObjectId();
    }

    @Override
    public long getObjectAddress() {
        return this.collection.getObjectAddress();
    }

    @Override
    public IClass getClazz() {
        return this.collection.getClazz();
    }

    @Override
    public String getTechnicalName() {
        return this.collection.getTechnicalName();
    }

    @Override
    public String getClassSpecificName() {
        return this.collection.getClassSpecificName();
    }

    @Override
    public String getDisplayName() {
        return this.collection.getDisplayName();
    }

    @Override
    public List<NamedReference> getOutboundReferences() {
        return this.collection.getOutboundReferences();
    }

    @Override
    public Object resolveValue(String field) throws SnapshotException {
        return this.collection.resolveValue(field);
    }

    @Override
    public GCRootInfo[] getGCRootInfo() throws SnapshotException {
        return this.collection.getGCRootInfo();
    }

    @Override
    public ISnapshot getSnapshot() {
        return this.collection.getSnapshot();
    }

    public String toString() {
        return MessageUtil.format((String)Messages.AbstractExtractedCollection_ToString, (Object[])new Object[]{this.getClass().getName(), this.getCollection().getDisplayName()});
    }
}

