/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapLongObject;
import org.eclipse.mat.hprof.AbstractParser;
import org.eclipse.mat.hprof.BufferingRafPositionInputStream;
import org.eclipse.mat.hprof.HprofPlugin;
import org.eclipse.mat.hprof.IHprofParserHandler;
import org.eclipse.mat.hprof.IPositionInputStream;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.hprof.ui.HprofPreferences;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.snapshot.MultipleSnapshotsException;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

public class Pass1Parser
extends AbstractParser {
    private static final Pattern PATTERN_OBJ_ARRAY = Pattern.compile("^(\\[+)L(.*);$");
    private static final Pattern PATTERN_PRIMITIVE_ARRAY = Pattern.compile("^(\\[+)(.)$");
    private final boolean NEWCLASSSIZE = HprofPreferences.useAdditionalClassReferences();
    private HashMapLongObject<String> class2name = new HashMapLongObject();
    private HashMapLongObject<Long> thread2id = new HashMapLongObject();
    private HashMapLongObject<StackFrame> id2frame = new HashMapLongObject();
    private HashMapLongObject<StackTrace> serNum2stackTrace = new HashMapLongObject();
    private HashMapLongObject<Long> classSerNum2id = new HashMapLongObject();
    private HashMapLongObject<List<JavaLocal>> thread2locals = new HashMapLongObject();
    private HashMapLongObject<String> constantPool = new HashMapLongObject();
    private IHprofParserHandler handler;
    private SimpleMonitor.Listener monitor;
    private long previousArrayStart;
    private long previousArrayUncompressedEnd;
    private boolean foundCompressed;
    private int[] biggestArrays;
    private long streamLength;
    private final boolean verbose = Platform.inDebugMode() && HprofPlugin.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mat.hprof/debug/parser"));
    private IPositionInputStream in;

    public Pass1Parser(IHprofParserHandler handler, SimpleMonitor.Listener monitor, HprofPreferences.HprofStrictness strictnessPreference) {
        super(strictnessPreference);
        this.handler = handler;
        this.monitor = monitor;
        this.biggestArrays = new int[Runtime.getRuntime().availableProcessors()];
    }

    public void read(File file, String dumpNrToRead, long estimatedLength) throws SnapshotException, IOException {
        this.in = new BufferingRafPositionInputStream(file, 0L, 8192, 0L);
        int currentDumpNr = 0;
        ArrayList<MultipleSnapshotsException.Context> ctxs = new ArrayList<MultipleSnapshotsException.Context>();
        boolean foundDump = false;
        try {
            this.version = Pass1Parser.readVersion(this.in);
            this.handler.addProperty("VERSION", this.version.toString());
            this.idSize = this.in.readInt();
            if (this.idSize != 4 && this.idSize != 8) {
                throw new SnapshotException(Messages.Pass1Parser_Error_SupportedDumps);
            }
            this.handler.addProperty("ID_SIZE", String.valueOf(this.idSize));
            long date = this.in.readLong();
            long prevTimeOffset = 0L;
            long timeWrap = 0L;
            long fileSize0 = file.length();
            long fileSize = estimatedLength;
            long curPos = this.in.position();
            block25: while (true) {
                if (this.monitor.isProbablyCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                this.monitor.totalWorkDone(curPos / 1000L);
                int r = this.in.read();
                if (r == -1) break;
                int record = r & 0xFF;
                long timeOffset = this.in.readUnsignedInt();
                if (timeOffset < prevTimeOffset) {
                    timeWrap += 0x100000000L;
                }
                prevTimeOffset = timeOffset;
                long length = this.in.readUnsignedInt();
                if (this.verbose) {
                    System.out.println("Read record type " + record + ", length " + length + " at position 0x" + Long.toHexString(curPos));
                }
                if (curPos + 9L >= fileSize && fileSize > fileSize0 && curPos + 9L + length >= 0x100000000L) {
                    while (fileSize < curPos + 9L) {
                        fileSize += 0x100000000L;
                    }
                }
                if ((length = this.updateLengthIfNecessary(fileSize, curPos, record, length, this.monitor)) < 0L) {
                    throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_IllegalRecordLength, (Object[])new Object[]{length, Long.toHexString(this.in.position() - 4L), Integer.toHexString(record), Long.toHexString(curPos)}));
                }
                if (curPos + 9L + length > fileSize) {
                    switch (this.strictnessPreference) {
                        case STRICTNESS_STOP: {
                            if (fileSize == fileSize0 || fileSize < 0x10000000L) {
                                throw new SnapshotException(Messages.HPROFStrictness_Stopped, (Throwable)new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_invalidHPROFFile, (Object[])new Object[]{length, fileSize - curPos - 9L, Integer.toHexString(record), Long.toHexString(curPos)})));
                            }
                        }
                        case STRICTNESS_WARNING: 
                        case STRICTNESS_PERMISSIVE: {
                            this.monitor.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.Pass1Parser_Error_invalidHPROFFile, (Object[])new Object[]{length, fileSize - curPos - 9L, Integer.toHexString(record), Long.toHexString(curPos)}), null);
                            break;
                        }
                        default: {
                            throw new SnapshotException(Messages.HPROFStrictness_Unhandled_Preference);
                        }
                    }
                }
                block7 : switch (record) {
                    case 1: {
                        if ((int)(length - (long)this.idSize) < 0) {
                            throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_IllegalRecordLength, (Object[])new Object[]{length, Long.toHexString(this.in.position() - 4L), Integer.toHexString(record), Long.toHexString(curPos)}));
                        }
                        this.readString(length);
                        break;
                    }
                    case 2: {
                        this.readLoadClass();
                        break;
                    }
                    case 3: {
                        this.readUnloadClass();
                        break;
                    }
                    case 4: {
                        this.readStackFrame(length);
                        break;
                    }
                    case 5: {
                        this.readStackTrace(length);
                        break;
                    }
                    case 12: 
                    case 28: {
                        long dumpTime = date + (timeWrap + timeOffset) / 1000L;
                        if (this.dumpMatches(currentDumpNr, dumpNrToRead)) {
                            long posnext;
                            if (!foundDump) {
                                this.handler.addProperty("CREATION_DATE", String.valueOf(dumpTime));
                                foundDump = true;
                            }
                            if ((posnext = this.readDumpSegments(length)) < curPos + length) {
                                curPos = posnext;
                                break block25;
                            }
                        } else {
                            this.in.skipBytes(length);
                        }
                        if (ctxs.size() < currentDumpNr + 1) {
                            MultipleSnapshotsException.Context ctx = new MultipleSnapshotsException.Context(this.dumpIdentifier(currentDumpNr));
                            ctx.setDescription(MessageUtil.format((String)Messages.Pass1Parser_HeapDumpCreated, (Object[])new Object[]{new Date(dumpTime)}));
                            ctxs.add(ctx);
                        }
                        if (record != 12) break;
                        ++currentDumpNr;
                        break;
                    }
                    case 44: {
                        ++currentDumpNr;
                        this.in.skipBytes(length);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: {
                        this.in.skipBytes(length);
                        break;
                    }
                    default: {
                        switch (this.strictnessPreference) {
                            case STRICTNESS_STOP: {
                                throw new SnapshotException(Messages.HPROFStrictness_Stopped, (Throwable)new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_UnexpectedRecord, (Object[])new Object[]{Integer.toHexString(record), length, Long.toHexString(curPos)})));
                            }
                            case STRICTNESS_WARNING: 
                            case STRICTNESS_PERMISSIVE: {
                                this.monitor.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.Pass1Parser_UnexpectedRecord, (Object[])new Object[]{Integer.toHexString(record), length, Long.toHexString(curPos)}), null);
                                this.in.skipBytes(length);
                                break block7;
                            }
                        }
                        throw new SnapshotException(Messages.HPROFStrictness_Unhandled_Preference);
                    }
                }
                curPos = this.in.position();
            }
            this.streamLength = curPos;
        }
        finally {
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
        }
        this.handler.addProperty("LENGTH", Long.toString(this.streamLength()));
        if (!foundDump) {
            throw new SnapshotException(MessageUtil.format((String)Messages.Pass1Parser_Error_NoHeapDumpIndexFound, (Object[])new Object[]{currentDumpNr, file.getName(), dumpNrToRead}));
        }
        if (currentDumpNr > 1) {
            if (dumpNrToRead == null) {
                MultipleSnapshotsException mse = new MultipleSnapshotsException(MessageUtil.format((String)Messages.Pass1Parser_HeapDumpsFound, (Object[])new Object[]{currentDumpNr}));
                for (MultipleSnapshotsException.Context runtime : ctxs) {
                    mse.addContext(runtime);
                }
                throw mse;
            }
            this.monitor.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.Pass1Parser_Info_UsingDumpIndex, (Object[])new Object[]{currentDumpNr, file.getName(), dumpNrToRead}), null);
        }
        if (this.serNum2stackTrace.size() > 0) {
            this.dumpThreads();
        }
    }

    public long biggestArrays() {
        long total = 0L;
        int[] nArray = this.biggestArrays;
        int n = this.biggestArrays.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            total += (long)s;
            ++n2;
        }
        return total;
    }

    public long streamLength() {
        return this.streamLength;
    }

    private void readString(long length) throws IOException {
        long id = this.in.readID(this.idSize);
        byte[] chars = new byte[(int)(length - (long)this.idSize)];
        this.in.readFully(chars);
        this.constantPool.put(id, (Object)new String(chars, "UTF-8"));
    }

    private void readLoadClass() throws IOException {
        long classSerNum = this.in.readUnsignedInt();
        long classID = this.in.readID(this.idSize);
        this.in.skipBytes(4);
        long nameID = this.in.readID(this.idSize);
        String className = this.getStringConstant(nameID).replace('/', '.');
        this.class2name.put(classID, (Object)className);
        this.classSerNum2id.put(classSerNum, (Object)classID);
    }

    private void readUnloadClass() throws IOException {
        long classSerNum = this.in.readUnsignedInt();
        long classID = (Long)this.classSerNum2id.get(classSerNum);
        this.class2name.remove(classID);
    }

    private void readStackFrame(long length) throws IOException {
        long frameId = this.in.readID(this.idSize);
        long methodName = this.in.readID(this.idSize);
        long methodSig = this.in.readID(this.idSize);
        long srcFile = this.in.readID(this.idSize);
        long classSerNum = this.in.readUnsignedInt();
        int lineNr = this.in.readInt();
        StackFrame frame = new StackFrame(frameId, lineNr, this.getStringConstant(methodName), this.getStringConstant(methodSig), this.getStringConstant(srcFile), classSerNum);
        this.id2frame.put(frameId, (Object)frame);
    }

    private void readStackTrace(long length) throws IOException {
        long stackTraceNr = this.in.readUnsignedInt();
        long threadNr = this.in.readUnsignedInt();
        long frameCount = this.in.readUnsignedInt();
        long[] frameIds = new long[(int)frameCount];
        int i = 0;
        while ((long)i < frameCount) {
            frameIds[i] = this.in.readID(this.idSize);
            ++i;
        }
        StackTrace stackTrace = new StackTrace(stackTraceNr, threadNr, frameIds);
        this.serNum2stackTrace.put(stackTraceNr, (Object)stackTrace);
    }

    /*
     * Exception decompiling
     */
    private long readDumpSegments(long length) throws IOException, SnapshotException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [24[CATCHBLOCK]], but top level block is 16[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long checkSkipBytes(long s) throws IOException {
        if (s > 0L) {
            long l;
            if (s > 1L && (l = (long)this.in.skipBytes(s - 1L)) < s - 1L) {
                throw new EOFException();
            }
            this.in.readByte();
        }
        return s;
    }

    private void readGCThreadObject(int gcType) throws IOException {
        long id = this.in.readID(this.idSize);
        int threadSerialNo = this.in.readInt();
        this.thread2id.put((long)threadSerialNo, (Object)id);
        this.handler.addGCRoot(id, 0L, gcType);
        this.checkSkipBytes(4L);
    }

    private void readGC(int gcType, int skip) throws IOException {
        long id = this.in.readID(this.idSize);
        this.handler.addGCRoot(id, 0L, gcType);
        if (skip > 0) {
            this.checkSkipBytes(skip);
        }
    }

    private void readGCWithThreadContext(int gcType, boolean hasLineInfo) throws IOException {
        long id = this.in.readID(this.idSize);
        int threadSerialNo = this.in.readInt();
        Long tid = (Long)this.thread2id.get((long)threadSerialNo);
        if (tid != null) {
            this.handler.addGCRoot(id, tid, gcType);
        } else {
            this.handler.addGCRoot(id, 0L, gcType);
        }
        if (hasLineInfo) {
            int lineNumber = this.in.readInt();
            ArrayList<JavaLocal> locals = (ArrayList<JavaLocal>)this.thread2locals.get((long)threadSerialNo);
            if (locals == null) {
                locals = new ArrayList<JavaLocal>();
                this.thread2locals.put((long)threadSerialNo, locals);
            }
            locals.add(new JavaLocal(id, lineNumber, gcType));
        }
    }

    private void readClassDump(long segmentStartPos) throws IOException {
        long address = this.in.readID(this.idSize);
        this.in.skipBytes(4);
        long superClassObjectId = this.in.readID(this.idSize);
        long classLoaderObjectId = this.in.readID(this.idSize);
        long signersId = this.in.readID(this.idSize);
        long protectionDomainId = this.in.readID(this.idSize);
        long reserved1Id = this.in.readID(this.idSize);
        long reserved2Id = this.in.readID(this.idSize);
        int extraDummyStatics = 0;
        if (this.NEWCLASSSIZE) {
            extraDummyStatics += 2;
            if (reserved1Id != 0L) {
                ++extraDummyStatics;
            }
            if (reserved2Id != 0L) {
                ++extraDummyStatics;
            }
        }
        int instsize = this.in.readInt();
        int constantPoolSize = this.in.readUnsignedShort();
        Field[] constantPool = new Field[constantPoolSize];
        int ii = 0;
        while (ii < constantPoolSize) {
            int index = this.in.readUnsignedShort();
            String name = "<constant pool[" + index + "]>";
            byte type = this.in.readByte();
            Object value = this.readValue(this.in, null, type);
            constantPool[ii] = new Field(name, (int)type, value);
            ++ii;
        }
        int numStaticFields = this.in.readUnsignedShort();
        Field[] statics = new Field[numStaticFields + extraDummyStatics];
        int ii2 = 0;
        while (ii2 < numStaticFields) {
            long nameId = this.in.readID(this.idSize);
            String name = this.getStringConstant(nameId);
            byte type = this.in.readByte();
            Object value = this.readValue(this.in, null, type);
            statics[ii2] = new Field(name, (int)type, value);
            ++ii2;
        }
        if (this.NEWCLASSSIZE) {
            int si = numStaticFields;
            statics[si++] = new Field("<signers>", 2, (Object)(signersId == 0L ? null : new ObjectReference(null, signersId)));
            statics[si++] = new Field("<protectionDomain>", 2, (Object)(protectionDomainId == 0L ? null : new ObjectReference(null, protectionDomainId)));
            if (reserved1Id != 0L) {
                statics[si++] = new Field("<reserved1>", 2, (Object)(reserved1Id == 0L ? null : new ObjectReference(null, reserved1Id)));
            }
            if (reserved2Id != 0L) {
                statics[si++] = new Field("<reserved2>", 2, (Object)(reserved2Id == 0L ? null : new ObjectReference(null, reserved2Id)));
            }
            Field[] all = new Field[statics.length + constantPool.length];
            System.arraycopy(statics, 0, all, 0, statics.length);
            System.arraycopy(constantPool, 0, all, statics.length, constantPool.length);
            statics = all;
        }
        int numInstanceFields = this.in.readUnsignedShort();
        FieldDescriptor[] fields = new FieldDescriptor[numInstanceFields];
        int ii3 = 0;
        while (ii3 < numInstanceFields) {
            long nameId = this.in.readID(this.idSize);
            String name = this.getStringConstant(nameId);
            byte type = this.in.readByte();
            fields[ii3] = new FieldDescriptor(name, (int)type);
            ++ii3;
        }
        String className = (String)this.class2name.get(address);
        if (className == null) {
            className = "unknown-name@0x" + Long.toHexString(address);
        }
        if (className.charAt(0) == '[') {
            Matcher matcher = PATTERN_OBJ_ARRAY.matcher(className);
            if (matcher.matches()) {
                int l = matcher.group(1).length();
                className = matcher.group(2);
                int ii4 = 0;
                while (ii4 < l) {
                    className = String.valueOf(className) + "[]";
                    ++ii4;
                }
            }
            if ((matcher = PATTERN_PRIMITIVE_ARRAY.matcher(className)).matches()) {
                int count = matcher.group(1).length() - 1;
                className = "unknown[]";
                char signature = matcher.group(2).charAt(0);
                int ii5 = 0;
                while (ii5 < IPrimitiveArray.SIGNATURES.length) {
                    if (IPrimitiveArray.SIGNATURES[ii5] == (byte)signature) {
                        className = IPrimitiveArray.TYPE[ii5];
                        break;
                    }
                    ++ii5;
                }
                ii5 = 0;
                while (ii5 < count) {
                    className = String.valueOf(className) + "[]";
                    ++ii5;
                }
            }
        }
        ClassImpl clazz = new ClassImpl(address, className, superClassObjectId, classLoaderObjectId, statics, fields);
        clazz.setHeapSizePerInstance((long)instsize);
        this.handler.addClass(clazz, segmentStartPos, this.idSize, instsize);
    }

    private void readInstanceDump(long segmentStartPos) throws IOException {
        long address = this.in.readID(this.idSize);
        this.in.skipBytes(4);
        long classID = this.in.readID(this.idSize);
        int payload = this.in.readInt();
        this.checkSkipBytes(payload);
        this.handler.reportInstanceWithClass(address, segmentStartPos, classID, payload);
    }

    private void readObjectArrayDump(long segmentStartPos) throws IOException {
        long address = this.in.readID(this.idSize);
        if (!this.foundCompressed && this.idSize == 8 && address > this.previousArrayStart && address < this.previousArrayUncompressedEnd) {
            this.monitor.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.Pass1Parser_DetectedCompressedReferences, (Object[])new Object[]{Long.toHexString(address), Long.toHexString(this.previousArrayStart)}), null);
            this.handler.addProperty("REF_SIZE", "4");
            this.foundCompressed = true;
        }
        this.in.skipBytes(4);
        int size = this.in.readInt();
        long arrayClassObjectID = this.in.readID(this.idSize);
        this.checkSkipBytes((long)size * (long)this.idSize);
        this.previousArrayStart = address;
        this.previousArrayUncompressedEnd = address + 16L + (long)size * 8L;
        if (size > this.biggestArrays[0]) {
            this.biggestArrays[0] = size;
            Arrays.sort(this.biggestArrays);
        }
        this.handler.reportInstanceOfObjectArray(address, segmentStartPos, arrayClassObjectID);
    }

    private void readPrimitiveArrayDump(long segmentStartPos) throws SnapshotException, IOException {
        long address = this.in.readID(this.idSize);
        this.in.skipBytes(4);
        int size = this.in.readInt();
        byte elementType = this.in.readByte();
        if (elementType < 4 || elementType > 11) {
            throw new SnapshotException(Messages.Pass1Parser_Error_IllegalType);
        }
        int elementSize = IPrimitiveArray.ELEMENT_SIZE[elementType];
        this.checkSkipBytes((long)elementSize * (long)size);
        this.handler.reportInstanceOfPrimitiveArray(address, segmentStartPos, elementType);
    }

    private String getStringConstant(long address) {
        if (address == 0L) {
            return "";
        }
        String result = (String)this.constantPool.get(address);
        return result == null ? MessageUtil.format((String)Messages.Pass1Parser_Error_UnresolvedName, (Object[])new Object[]{Long.toHexString(address)}) : result;
    }

    private void dumpThreads() {
        block16: {
            if (this.serNum2stackTrace == null || this.serNum2stackTrace.size() <= 1) {
                return;
            }
            PrintWriter out = null;
            String outputName = String.valueOf(this.handler.getSnapshotInfo().getPrefix()) + "threads";
            try {
                try {
                    out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputName), "UTF-8"));
                    Iterator it = this.serNum2stackTrace.values();
                    while (it.hasNext()) {
                        StackTrace stack = (StackTrace)it.next();
                        Long tid = (Long)this.thread2id.get(stack.threadSerialNr);
                        if (tid == null) continue;
                        String threadId = tid == null ? "<unknown>" : "0x" + Long.toHexString(tid);
                        out.println("Thread " + threadId);
                        out.println(stack);
                        out.println("  locals:");
                        List locals = (List)this.thread2locals.get(stack.threadSerialNr);
                        if (locals != null) {
                            for (JavaLocal javaLocal : locals) {
                                out.println("    objectId=0x" + Long.toHexString(javaLocal.objectId) + ", line=" + javaLocal.lineNumber);
                            }
                        }
                        out.println();
                    }
                    out.flush();
                    this.monitor.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.Pass1Parser_Info_WroteThreadsTo, (Object[])new Object[]{outputName}), null);
                }
                catch (IOException e) {
                    this.monitor.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.Pass1Parser_Error_WritingThreadsInformation, (Object[])new Object[0]), (Throwable)e);
                    if (out == null) break block16;
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static class JavaLocal {
        private long objectId;
        private int lineNumber;
        private int type;

        public JavaLocal(long objectId, int lineNumber, int type) {
            this.lineNumber = lineNumber;
            this.objectId = objectId;
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    private class StackFrame {
        long frameId;
        String method;
        String methodSignature;
        String sourceFile;
        long classSerNum;
        int lineNr;

        public StackFrame(long frameId, int lineNr, String method, String methodSignature, String sourceFile, long classSerNum) {
            this.frameId = frameId;
            this.lineNr = lineNr;
            this.method = method;
            this.methodSignature = methodSignature;
            this.sourceFile = sourceFile;
            this.classSerNum = classSerNum;
        }

        public String toString() {
            String className = null;
            Long classId = (Long)Pass1Parser.this.classSerNum2id.get(this.classSerNum);
            className = classId == null ? "<UNKNOWN CLASS>" : (String)Pass1Parser.this.class2name.get(classId.longValue());
            String sourceLocation = "";
            if (this.lineNr > 0) {
                sourceLocation = "(" + this.sourceFile + ":" + String.valueOf(this.lineNr) + ")";
            } else if (this.lineNr == 0 || this.lineNr == -1) {
                sourceLocation = "(Unknown Source)";
            } else if (this.lineNr == -2) {
                sourceLocation = "(Compiled method)";
            } else if (this.lineNr == -3) {
                sourceLocation = "(Native Method)";
            }
            return "  at " + className + "." + this.method + this.methodSignature + " " + sourceLocation;
        }
    }

    private class StackTrace {
        private long threadSerialNr;
        private long[] frameIds;

        public StackTrace(long serialNr, long threadSerialNr, long[] frameIds) {
            this.frameIds = frameIds;
            this.threadSerialNr = threadSerialNr;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            long[] lArray = this.frameIds;
            int n = this.frameIds.length;
            int n2 = 0;
            while (n2 < n) {
                long frameId = lArray[n2];
                StackFrame frame = (StackFrame)Pass1Parser.this.id2frame.get(frameId);
                if (frame != null) {
                    b.append(frame.toString());
                    b.append("\r\n");
                }
                ++n2;
            }
            return b.toString();
        }
    }
}

