/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.hprof.HprofPlugin;

public class HprofPreferences {
    public static final String STRICTNESS_PREF = "hprofStrictness";
    public static final HprofStrictness DEFAULT_STRICTNESS = HprofStrictness.STRICTNESS_STOP;
    public static final String ADDITIONAL_CLASS_REFERENCES = "hprofAddClassRefs";

    public static HprofStrictness getCurrentStrictness() {
        HprofStrictness strictnessPreference = HprofStrictness.parse(Platform.getPreferencesService().getString(HprofPlugin.getDefault().getBundle().getSymbolicName(), STRICTNESS_PREF, "", null));
        HprofStrictness[] hprofStrictnessArray = HprofStrictness.values();
        int n = hprofStrictnessArray.length;
        int n2 = 0;
        while (n2 < n) {
            HprofStrictness strictness = hprofStrictnessArray[n2];
            if (Boolean.getBoolean(strictness.toString())) {
                strictnessPreference = strictness;
                break;
            }
            ++n2;
        }
        return strictnessPreference;
    }

    public static boolean useAdditionalClassReferences() {
        return Platform.getPreferencesService().getBoolean(HprofPlugin.getDefault().getBundle().getSymbolicName(), ADDITIONAL_CLASS_REFERENCES, false, null);
    }

    public static enum HprofStrictness {
        STRICTNESS_STOP("hprofStrictnessStop"),
        STRICTNESS_WARNING("hprofStrictnessWarning"),
        STRICTNESS_PERMISSIVE("hprofStrictnessPermissive");

        private final String name;

        private HprofStrictness(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static HprofStrictness parse(String value) {
            if (value != null && value.length() > 0) {
                HprofStrictness[] hprofStrictnessArray = HprofStrictness.values();
                int n = hprofStrictnessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HprofStrictness strictness = hprofStrictnessArray[n2];
                    if (strictness.toString().equals(value)) {
                        return strictness;
                    }
                    ++n2;
                }
            }
            return DEFAULT_STRICTNESS;
        }
    }
}

