/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mat.query.BytesDisplay;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class UIPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private String lastBytesDisplay;

    public UIPreferencePage() {
        super(1);
        this.setPreferenceStore(MemoryAnalyserPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.UIPreferencePage_PreferencesSubtitle);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor("keep_unreachable_objects", Messages.UIPreferencePage_KeepUnreachableObjects, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("hideGettingStartedWizard", Messages.UIPreferencePage_HideGettingStartedWizard, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("pref:HideQueryHelp", Messages.UIPreferencePage_HideQueryHelp, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("hide_welcome_screen", Messages.UIPreferencePage_HideWelcomeScreen, this.getFieldEditorParent()));
        this.addField((FieldEditor)new RadioGroupFieldEditor("bytes_display", Messages.UIPreferencePage_BytesDisplay, 1, (String[][])new String[][]{{Messages.UIPreferencePage_BytesDisplay_Bytes, BytesDisplay.Bytes.toString()}, {Messages.UIPreferencePage_BytesDisplay_Kilobytes, BytesDisplay.Kilobytes.toString()}, {Messages.UIPreferencePage_BytesDisplay_Megabytes, BytesDisplay.Megabytes.toString()}, {Messages.UIPreferencePage_BytesDisplay_Gigabytes, BytesDisplay.Gigabytes.toString()}, {Messages.UIPreferencePage_BytesDisplay_Smart, BytesDisplay.Smart.toString()}}, this.getFieldEditorParent(), true));
        BooleanFieldEditor enable = new BooleanFieldEditor("discardEnable", Messages.UIPreferencePage_DiscardEnable, this.getFieldEditorParent());
        this.addField((FieldEditor)enable);
        IntegerFieldEditor discardRatio = new IntegerFieldEditor("discard_ratio_percentage", Messages.UIPreferencePage_DiscardPercentage, this.getFieldEditorParent());
        discardRatio.setValidRange(0, 100);
        this.addField((FieldEditor)discardRatio);
        PatternFieldEditor discardPattern = new PatternFieldEditor("discard_pattern", Messages.UIPreferencePage_DiscardPattern, this.getFieldEditorParent());
        this.addField((FieldEditor)discardPattern);
        IntegerFieldEditor discardOffset = new IntegerFieldEditor("discard_offset_percentage", Messages.UIPreferencePage_DiscardOffset, this.getFieldEditorParent());
        discardOffset.setValidRange(0, 99);
        this.addField((FieldEditor)discardOffset);
        IntegerFieldEditor discardSeed = new IntegerFieldEditor("discard_seed", Messages.UIPreferencePage_DiscardSeed, this.getFieldEditorParent());
        discardSeed.setValidRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.addField((FieldEditor)discardSeed);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.preferences_assist");
        return super.createContents(parent);
    }

    public boolean performOk() {
        if (this.lastBytesDisplay != null) {
            BytesDisplay.setCurrentValue((BytesDisplay)BytesDisplay.parse((String)this.lastBytesDisplay));
        }
        return super.performOk();
    }

    public void propertyChange(PropertyChangeEvent event) {
        RadioGroupFieldEditor rgfe;
        super.propertyChange(event);
        Object source = event.getSource();
        if (source instanceof RadioGroupFieldEditor && (rgfe = (RadioGroupFieldEditor)source).getPreferenceName().equals("bytes_display")) {
            this.lastBytesDisplay = event.getNewValue().toString();
        }
    }

    private static final class PatternFieldEditor
    extends StringFieldEditor {
        private PatternFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        public boolean doCheckState() {
            try {
                Pattern.compile(this.getStringValue());
            }
            catch (PatternSyntaxException e) {
                this.setErrorMessage(e.getDescription());
                return false;
            }
            return true;
        }
    }
}

