/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.facet.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.facet.Facet;
import org.eclipse.modisco.infra.facet.FacetAttribute;
import org.eclipse.modisco.infra.facet.FacetReference;
import org.eclipse.modisco.infra.facet.FacetSet;
import org.eclipse.modisco.infra.facet.FacetStructuralFeature;
import org.eclipse.modisco.infra.facet.Shortcut;
import org.eclipse.modisco.infra.facet.core.FacetContextListener;
import org.eclipse.modisco.infra.facet.core.adapters.instances.MetaclassInstancesAdapterFactoryWithFacet;
import org.eclipse.modisco.infra.facet.core.exception.ModiscoFacetException;
import org.eclipse.modisco.infra.facet.core.exception.StructuralConstraintViolationException;
import org.eclipse.modisco.infra.facet.core.internal.Activator;
import org.eclipse.modisco.infra.query.ModelQuery;
import org.eclipse.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.modisco.util.emf.core.internal.allinstances.MetaclassInstances;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class FacetContext {
    private final Set<Facet> appliedFacets = new HashSet<Facet>();
    private final List<EStructuralFeature> appliedFeatures = new ArrayList<EStructuralFeature>();
    private final Set<Resource> resources = new HashSet<Resource>();
    private final List<FacetContextListener> fListeners = new ArrayList<FacetContextListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResources(Collection<Resource> resources) {
        Set<Resource> set = this.resources;
        synchronized (set) {
            this.resources.clear();
        }
        for (Resource resource : resources) {
            this.addComposedResource(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addComposedResource(Resource resource) {
        if (resource == null) {
            return;
        }
        Resource resource2 = this.resources;
        synchronized (resource2) {
            this.resources.add(resource);
        }
        resource2 = resource;
        synchronized (resource2) {
            TreeIterator allContents = EcoreUtil.getAllContents((Resource)resource, (boolean)false);
            while (allContents.hasNext()) {
                EObject element = (EObject)allContents.next();
                if (element.eResource() == resource) continue;
                Set<Resource> set = this.resources;
                synchronized (set) {
                    this.resources.add(element.eResource());
                }
            }
        }
    }

    public void addFacetSet(FacetSet facetSet) {
        for (Facet facet : facetSet.getFacets()) {
            this.addFacet(facet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFacet(Facet facet) {
        boolean contained;
        Set<Facet> set = this.appliedFacets;
        synchronized (set) {
            contained = this.appliedFacets.contains(facet);
            if (!contained) {
                this.appliedFacets.add(facet);
            }
        }
        if (!contained) {
            this.notifyFacetAdded(facet);
            for (EStructuralFeature feature : facet.getEStructuralFeatures()) {
                if (!(feature instanceof FacetStructuralFeature) && !(feature instanceof Shortcut)) continue;
                List<EStructuralFeature> list = this.appliedFeatures;
                synchronized (list) {
                    this.appliedFeatures.add(feature);
                }
            }
        }
    }

    public boolean isInstance(EObject eObject, Facet facet) throws ModelQueryException {
        ModelQuery modelQuery = facet.getConditionQuery();
        boolean result = false;
        boolean isSuperType = false;
        for (EClass superType : facet.getESuperTypes()) {
            if (!superType.isSuperTypeOf(eObject.eClass())) continue;
            isSuperType = true;
            break;
        }
        if (isSuperType) {
            if (modelQuery == null) {
                result = true;
            } else {
                AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(modelQuery);
                try {
                    Object queryResult = abstractModelQuery.basicEvaluate(eObject);
                    if (queryResult instanceof Boolean) {
                        result = (Boolean)queryResult;
                    } else {
                        String message = "Query " + abstractModelQuery.toString() + " didn't return a boolean result as expected.";
                        MoDiscoLogger.logError((String)message, (Plugin)Activator.getDefault());
                    }
                }
                catch (ModelQueryException e) {
                    result = false;
                    throw e;
                }
                catch (Exception e) {
                    result = false;
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    throw new ModelQueryException("FacetContext failed to execute a query", (Throwable)e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(EObject eObject, EStructuralFeature structuralFeature) throws ModelQueryException, ModiscoFacetException {
        boolean contained;
        if (structuralFeature == null) {
            throw new ModiscoFacetException("The parameter named structuralFeature is null");
        }
        Object result = null;
        List<EStructuralFeature> list = this.appliedFeatures;
        synchronized (list) {
            contained = this.appliedFeatures.contains(structuralFeature);
        }
        if (!contained) throw new ModiscoFacetException("The structuralFeature must be registered into the context, please use the " + FacetContext.class.getSimpleName() + ".add(FacetSet) method.");
        Facet facet = (Facet)structuralFeature.eContainer();
        if (!this.isInstance(eObject, facet)) throw new ModiscoFacetException("The eObject parameter must be an instance of : " + facet.getName());
        if (structuralFeature instanceof FacetStructuralFeature) {
            FacetStructuralFeature facetStructuralFeature = (FacetStructuralFeature)structuralFeature;
            ModelQuery modelQuery = facetStructuralFeature.getValueQuery();
            AbstractModelQuery abstractModelQuery = ModelQuerySetCatalog.getSingleton().getModelQueryImpl(modelQuery);
            result = abstractModelQuery.basicEvaluate(eObject);
        } else {
            if (!(structuralFeature instanceof Shortcut)) throw new ModiscoFacetException("The structuralFeature parameter must be a FacetStructuralFeature: " + structuralFeature.toString());
            Shortcut shortcut = (Shortcut)structuralFeature;
            BasicEList resultList = new BasicEList();
            EReference oppositeRef = shortcut.getOppositeReference();
            EClass eClass = oppositeRef.getEContainingClass();
            List<EObject> list2 = this.allInstances(eClass);
            for (EObject modelElement : list2) {
                EObject referedByModelElement = (EObject)modelElement.eGet((EStructuralFeature)oppositeRef);
                if (referedByModelElement != eObject) continue;
                EObject element = modelElement;
                for (EReference eReference : shortcut.getPath()) {
                    element = (EObject)element.eGet((EStructuralFeature)eReference);
                }
                resultList.add(element);
            }
            if (shortcut.getUpperBound() > 1) {
                result = resultList;
            } else {
                if (resultList.size() > 1) {
                    throw new StructuralConstraintViolationException();
                }
                if (resultList.size() == 1) {
                    result = resultList.get(0);
                }
            }
        }
        if (!(result instanceof Collection)) return result;
        if (result instanceof BasicEList) return result;
        Collection list3 = (Collection)result;
        BasicEList basicEList = new BasicEList(list3);
        return basicEList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<EObject> allInstances(EClass eClass) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        MetaclassInstancesAdapterFactoryWithFacet.getInstance().setFacetContext(this);
        Set<Resource> set = this.resources;
        synchronized (set) {
            for (Resource resource : this.resources) {
                MetaclassInstances instances = (MetaclassInstances)MetaclassInstancesAdapterFactoryWithFacet.getInstance().adapt((Notifier)resource, MetaclassInstances.class);
                result.addAll(instances.getInstances(eClass, true));
            }
        }
        return result;
    }

    public List<EStructuralFeature> getFacetFeatures(EObject eObject) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        for (Facet facet : this.getAppliedFacets()) {
            try {
                if (!this.isInstance(eObject, facet)) continue;
                result.addAll((Collection<EStructuralFeature>)facet.getEStructuralFeatures());
            }
            catch (ModelQueryException e) {
                Status status = new Status(4, "org.eclipse.modisco.infra.facet.core", e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return result;
    }

    public void addAll(Collection<FacetSet> allFacetSets) {
        for (FacetSet facetSet : allFacetSets) {
            this.addFacetSet(facetSet);
        }
    }

    public EList<EAttribute> getAttributes(EObject eObject) throws ModelQueryException {
        BasicEList result = new BasicEList();
        for (Facet facet : this.getAppliedFacets()) {
            if (!this.isInstance(eObject, facet)) continue;
            for (EStructuralFeature structuralFeature : facet.getEStructuralFeatures()) {
                if (!(structuralFeature instanceof FacetAttribute)) continue;
                FacetAttribute facetAttribute = (FacetAttribute)structuralFeature;
                result.add((Object)facetAttribute);
            }
        }
        return result;
    }

    public EList<EReference> getReferences(EObject eObject) throws ModelQueryException {
        BasicEList result = new BasicEList();
        for (Facet facet : this.getAppliedFacets()) {
            if (!this.isInstance(eObject, facet)) continue;
            for (EStructuralFeature structuralFeature : facet.getEStructuralFeatures()) {
                if (!(structuralFeature instanceof FacetReference) && !(structuralFeature instanceof Shortcut)) continue;
                EReference facetAttribute = (EReference)structuralFeature;
                result.add((Object)facetAttribute);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EClass> getMetaClasses() {
        ArrayList<EClass> metaClasses = new ArrayList<EClass>();
        Set<Facet> set = this.appliedFacets;
        synchronized (set) {
            metaClasses.addAll(this.appliedFacets);
        }
        return metaClasses;
    }

    public List<Facet> getFacets(EObject eObject) {
        ArrayList<Facet> result = new ArrayList<Facet>();
        for (Facet facet : this.getAppliedFacets()) {
            try {
                if (!this.isInstance(eObject, facet)) continue;
                result.add(facet);
            }
            catch (ModelQueryException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    public Collection<Facet> getAppliedFacets() {
        return new ArrayList<Facet>(this.appliedFacets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Collection<Object> collection = this.appliedFeatures;
        synchronized (collection) {
            this.appliedFeatures.clear();
        }
        collection = this.appliedFacets;
        synchronized (collection) {
            this.appliedFacets.clear();
        }
        this.notifyFacetsCleared();
    }

    protected Collection<EStructuralFeature> getAppliedFeatures() {
        return new ArrayList<EStructuralFeature>(this.appliedFeatures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FacetContextListener listener) {
        List<FacetContextListener> list = this.fListeners;
        synchronized (list) {
            if (!this.fListeners.contains(listener)) {
                this.fListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeListener(FacetContextListener listener) {
        List<FacetContextListener> list = this.fListeners;
        synchronized (list) {
            this.fListeners.remove(listener);
        }
    }

    public void notifyFacetAdded(Facet facet) {
        ArrayList<FacetContextListener> listeners = new ArrayList<FacetContextListener>(this.fListeners);
        for (FacetContextListener listener : listeners) {
            listener.facetAdded(facet);
        }
    }

    public void notifyFacetsCleared() {
        ArrayList<FacetContextListener> listeners = new ArrayList<FacetContextListener>(this.fListeners);
        for (FacetContextListener listener : listeners) {
            listener.facetsCleared();
        }
    }
}

