/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.core.gist;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.github.core.Gist;
import org.eclipse.egit.github.core.GistFile;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.service.GistService;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.gist.GistAttribute;
import org.eclipse.mylyn.internal.github.core.gist.GistConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttachmentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;

public class GistAttachmentHandler
extends AbstractTaskAttachmentHandler {
    public boolean canGetContent(TaskRepository repository, ITask task) {
        return true;
    }

    public boolean canPostContent(TaskRepository repository, ITask task) {
        return true;
    }

    public InputStream getContent(TaskRepository repository, ITask task, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        TaskAttribute urlAttribute = attachmentAttribute.getAttribute(GistAttribute.RAW_FILE_URL.getMetadata().getId());
        try {
            if (urlAttribute == null) {
                throw new IOException("Unable to obtain raw file URL from Gist");
            }
            URL url = new URL(urlAttribute.getValue());
            GitHubClient client = new GitHubClient(url.getHost()){

                protected String configureUri(String uri) {
                    return uri;
                }
            };
            GistConnector.configureClient(client, repository);
            return client.getStream(new GitHubRequest().setUri(url.getFile()));
        }
        catch (IOException e) {
            throw new CoreException(GitHub.createWrappedStatus(e));
        }
    }

    public void postContent(TaskRepository repository, ITask task, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute, IProgressMonitor monitor) throws CoreException {
        TaskAttachmentMapper mapper = TaskAttachmentMapper.createFrom((TaskAttribute)attachmentAttribute);
        Gist gist = new Gist().setId(task.getTaskId());
        gist.setDescription(attachmentAttribute.getParentAttribute().getAttribute(GistAttribute.DESCRIPTION.getMetadata().getId()).getValue());
        GistFile file = new GistFile();
        file.setFilename(mapper.getFileName());
        gist.setFiles(Collections.singletonMap(file.getFilename(), file));
        GitHubClient client = GistConnector.createClient(repository);
        GistService service = new GistService(client);
        InputStream input = source.createInputStream(monitor);
        try {
            try {
                int read;
                byte[] buffer = new byte[8192];
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                while ((read = input.read(buffer)) != -1) {
                    output.write(buffer, 0, read);
                }
                file.setContent(output.toString());
                service.updateGist(gist);
            }
            catch (IOException e) {
                throw new CoreException(GitHub.createWrappedStatus(e));
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }
}

