/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.nattable.sorting;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.swt.widgets.Display;

public class PapyrusGlazedListEventsLayer<E>
extends AbstractLayerTransform
implements IUniqueIndexLayer,
ListEventListener<E> {
    private final IUniqueIndexLayer underlyingLayer;
    private EventList<? extends E> eventList;
    private volatile boolean active;
    private volatile Update pendingUpdate;

    public PapyrusGlazedListEventsLayer(IUniqueIndexLayer underlyingLayer, EventList<? extends E> eventList) {
        super((ILayer)underlyingLayer);
        this.underlyingLayer = underlyingLayer;
        this.eventList = eventList;
        this.eventList.addListEventListener((ListEventListener)this);
    }

    public void dispose() {
        super.dispose();
        if (this.eventList != null) {
            this.eventList.removeListEventListener((ListEventListener)this);
            this.eventList = null;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void listChanged(ListEvent<E> event) {
        if (!this.isActive()) {
            return;
        }
        boolean structure = false;
        block3: while (event.next()) {
            int eventType = event.getType();
            switch (eventType) {
                case 0: 
                case 2: {
                    structure = true;
                    Update update = this.pendingUpdate;
                    if (update == null) break block3;
                    update.structuralUpdate = structure;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (this.pendingUpdate == null) {
            this.pendingUpdate = new Update();
            this.pendingUpdate.structuralUpdate = structure;
            Display.getDefault().timerExec(100, (Runnable)this.pendingUpdate);
        }
    }

    public int getColumnPositionByIndex(int columnIndex) {
        return this.underlyingLayer.getColumnPositionByIndex(columnIndex);
    }

    public int getRowPositionByIndex(int rowIndex) {
        return this.underlyingLayer.getRowPositionByIndex(rowIndex);
    }

    private class Update
    implements Runnable {
        volatile boolean structuralUpdate;

        private Update() {
        }

        @Override
        public void run() {
            if (PapyrusGlazedListEventsLayer.this.pendingUpdate == this) {
                PapyrusGlazedListEventsLayer.this.pendingUpdate = null;
                if (PapyrusGlazedListEventsLayer.this.eventList != null) {
                    if (this.structuralUpdate) {
                        PapyrusGlazedListEventsLayer.this.fireLayerEvent((ILayerEvent)new RowStructuralRefreshEvent(PapyrusGlazedListEventsLayer.this.getUnderlyingLayer()));
                    } else {
                        PapyrusGlazedListEventsLayer.this.fireLayerEvent((ILayerEvent)new VisualRefreshEvent(PapyrusGlazedListEventsLayer.this.getUnderlyingLayer()));
                    }
                }
            }
        }
    }
}

