/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.IPHPDataType;
import org.eclipse.php.internal.debug.core.model.IVirtualPartition;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.model.VirtualPartition;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionsUtil;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;

public class PHPValue
extends PHPDebugElement
implements IValue,
IPHPDataType {
    private static final int ARRAY_PARTITION_BOUNDARY = 100;
    protected Expression fExpression;
    protected ExpressionValue fExpressionValue;
    protected VariablesContainer fVariablesContainer;

    public PHPValue(PHPDebugTarget target, Expression expression) {
        super(target);
        this.fExpressionValue = expression.getValue();
        this.fExpression = expression;
        this.fVariablesContainer = new VariablesContainer();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.getDataType().getText().toUpperCase();
    }

    public synchronized boolean hasVariables() throws DebugException {
        switch (this.fExpressionValue.getDataType()) {
            case PHP_ARRAY: 
            case PHP_OBJECT: 
            case PHP_VIRTUAL_CLASS: {
                return this.fExpressionValue.getChildrenCount() > 0;
            }
        }
        return false;
    }

    @Override
    public synchronized IPHPDataType.DataType getDataType() {
        return this.fExpressionValue.getDataType();
    }

    public synchronized String getValueString() throws DebugException {
        return this.fExpressionValue.getValueAsString();
    }

    public synchronized String getValueDetail() throws DebugException {
        return ExpressionsUtil.getInstance(((PHPDebugTarget)this.getDebugTarget()).getExpressionManager()).getValueDetail(this.fExpression);
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        return this.fVariablesContainer.getVariables();
    }

    public synchronized String getValue() throws DebugException {
        return String.valueOf(this.fExpressionValue.getValue());
    }

    protected synchronized Expression getExpression() {
        return this.fExpression;
    }

    protected synchronized void update(Expression expression) {
        this.fExpression = expression;
        this.fExpressionValue = this.fExpression.getValue();
        this.fVariablesContainer.markOutdated();
    }

    private final class VariablesContainer {
        private Map<String, IVariable> fAllCurrentVariables = null;
        private Map<String, IVariable> fAllPreviousVariables = null;
        private Map<String, IVirtualPartition> fAllCurrentPartitions = new LinkedHashMap<String, IVirtualPartition>();
        private Map<String, IVirtualPartition> fAllPreviousPartitions = new LinkedHashMap<String, IVirtualPartition>();
        private IVariable[] fVariables = null;
        private boolean fIsOutdated = true;

        private VariablesContainer() {
        }

        IVariable[] getVariables() {
            if (this.fIsOutdated) {
                this.updateVariables();
                if (PHPValue.this.fExpressionValue.getDataType() == IPHPDataType.DataType.PHP_ARRAY && this.fAllCurrentVariables.size() >= 100) {
                    this.createPartitions();
                    this.fVariables = this.fAllCurrentPartitions.values().toArray(new IVariable[this.fAllCurrentPartitions.size()]);
                } else {
                    this.fVariables = this.fAllCurrentVariables.values().toArray(new IVariable[this.fAllCurrentVariables.size()]);
                }
                this.fIsOutdated = false;
            }
            return this.fVariables;
        }

        void markOutdated() {
            this.fIsOutdated = true;
        }

        private IVariable merge(IVariable variable) {
            if (this.fAllPreviousVariables == null) {
                return variable;
            }
            if (!(variable instanceof PHPVariable)) {
                return variable;
            }
            PHPVariable incoming = (PHPVariable)variable;
            if (incoming.getFullName().isEmpty()) {
                return incoming;
            }
            IVariable stored = this.fAllPreviousVariables.get(incoming.getFullName());
            if (stored != null) {
                ((PHPVariable)stored).update(incoming.getExpression());
                return stored;
            }
            return variable;
        }

        private void updateVariables() {
            this.fAllPreviousVariables = this.fAllCurrentVariables;
            this.fAllCurrentVariables = new LinkedHashMap<String, IVariable>();
            PHPDebugTarget debugTarget = (PHPDebugTarget)PHPValue.this.getDebugTarget();
            DefaultExpressionsManager expressionManager = debugTarget.getExpressionManager();
            Expression variable = PHPValue.this.fExpression;
            expressionManager.update(variable, 1);
            PHPValue.this.fExpressionValue = variable.getValue();
            Expression[] children = PHPValue.this.fExpressionValue.getChildren();
            if (children != null) {
                this.fAllCurrentVariables = new LinkedHashMap<String, IVariable>();
                int i = 0;
                while (i < children.length) {
                    PHPVariable incoming = new PHPVariable((PHPDebugTarget)PHPValue.this.getDebugTarget(), children[i]);
                    this.fAllCurrentVariables.put(incoming.getFullName(), this.merge(incoming));
                    ++i;
                }
            }
        }

        private void createPartitions() {
            int numChild = this.fAllCurrentVariables.size();
            int partitions = (int)Math.ceil((double)numChild / 100.0);
            this.fAllPreviousPartitions = this.fAllCurrentPartitions;
            this.fAllCurrentPartitions = new LinkedHashMap<String, IVirtualPartition>();
            int i = 0;
            while (i < partitions) {
                int startIndex = i * 100;
                int endIndex = (i + 1) * 100 - 1;
                if (endIndex > numChild) {
                    endIndex = numChild - 1;
                }
                final IVariable[] vars = Arrays.copyOfRange(this.fAllCurrentVariables.values().toArray(new IVariable[this.fAllCurrentVariables.size()]), startIndex, endIndex + 1);
                IVirtualPartition.IVariableProvider variableProvider = new IVirtualPartition.IVariableProvider(){

                    @Override
                    public IVariable[] getVariables() throws DebugException {
                        return vars;
                    }
                };
                String partitionId = String.valueOf(String.valueOf(startIndex)) + '-' + String.valueOf(endIndex);
                IVirtualPartition partition = this.fAllPreviousPartitions.get(partitionId);
                if (partition != null) {
                    partition.setProvider(variableProvider);
                    this.fAllCurrentPartitions.put(partitionId, partition);
                } else {
                    this.fAllCurrentPartitions.put(partitionId, new VirtualPartition((IDebugElement)PHPValue.this, variableProvider, startIndex, endIndex));
                }
                ++i;
            }
        }
    }
}

