/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views.coverage;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.debug.core.zend.communication.IRemoteFileContentRequestor;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.editor.OpenRemoteFileContentRequestor;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageContentProvider;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageView;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageViewer;
import org.eclipse.php.internal.debug.ui.views.coverage.OpenCoverageAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;

public class CodeCoverageActionGroup
extends ActionGroup
implements IMenuListener {
    private static final String COVERAGE_VIEW_ID = "org.eclipse.php.debug.ui.CodeCoverageView";
    private OpenCoverageAction openCoverageAction;
    private CodeCoverageViewer viewer;

    public CodeCoverageActionGroup(CodeCoverageViewer viewer) {
        this.viewer = viewer;
        this.openCoverageAction = new OpenCoverageAction(this);
        this.createContextMenu();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        menuManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menuManager.createContextMenu((Control)this.viewer.getTree()));
    }

    public void dispose() {
        super.dispose();
    }

    public void doubleClickFile(Object element) {
        try {
            if (element instanceof String) {
                String remoteFile = (String)element;
                CodeCoverageData data = ((CodeCoverageContentProvider)this.viewer.getContentProvider()).getCoverageData(remoteFile);
                IEditorPart part = org.eclipse.php.internal.ui.util.EditorUtility.openLocalFile((String)remoteFile, (int)0);
                if (part == null) {
                    OpenRemoteFileContentRequestor requestor = new OpenRemoteFileContentRequestor();
                    RemoteDebugger.requestRemoteFile((IRemoteFileContentRequestor)requestor, (String)remoteFile, (int)1, (String)data.getURL());
                }
            } else if (element instanceof ISourceModule || element instanceof IFile) {
                IEditorPart part = EditorUtility.openInEditor((Object)element, (boolean)false);
                if (part != null && element instanceof IModelElement && !(element instanceof ISourceModule)) {
                    EditorUtility.revealInEditor((IEditorPart)part, (IModelElement)((IModelElement)element));
                }
            } else {
                this.viewer.setExpandedState(element, !this.viewer.getExpandedState(element));
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        Object element;
        ISelection selection = this.viewer.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && PHPToolkitUtil.getSourceModule((Object)element) != null) {
            this.openCoverageAction.updateSelection(selection);
            menu.add((IAction)this.openCoverageAction);
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.fillContextMenu(manager);
    }

    public void showCoverage(CodeCoverageData coverageData) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage page = activeWorkbenchWindow.getActivePage();
        if (page == null) {
            return;
        }
        try {
            IViewPart part = page.showView(COVERAGE_VIEW_ID, coverageData.getFileName().replace(':', '_'), 1);
            if (part != null && part instanceof CodeCoverageView) {
                CodeCoverageView view = (CodeCoverageView)part;
                view.setInput(coverageData);
            }
        }
        catch (PartInitException e) {
            Logger.logException(e);
        }
    }

    public void showCoverage(Object data) {
        if (data == null) {
            return;
        }
        CodeCoverageContentProvider provider = (CodeCoverageContentProvider)this.viewer.getContentProvider();
        CodeCoverageData coverageData = null;
        if (data instanceof ISourceModule) {
            coverageData = provider.getCoverageData((ISourceModule)data);
        } else if (data instanceof IFile) {
            coverageData = provider.getCoverageData((IFile)data);
        } else if (data instanceof String) {
            coverageData = provider.getCoverageData((String)data);
        }
        if (coverageData != null) {
            this.showCoverage(coverageData);
        }
    }
}

