/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.util;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class Key {
    private String fQualifier;
    private String fKey;

    public Key(String qualifier, String key) {
        this.fQualifier = qualifier;
        this.fKey = key;
    }

    public String getName() {
        return this.fKey;
    }

    private IEclipsePreferences getNode(IScopeContext context, IWorkingCopyManager manager) {
        IEclipsePreferences node = context.getNode(this.fQualifier);
        if (manager != null) {
            return manager.getWorkingCopy(node);
        }
        return node;
    }

    public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
        IEclipsePreferences node = this.getNode(context, manager);
        try {
            if (node.nodeExists("")) {
                return node.get(this.fKey, null);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return null;
    }

    public String getStoredValue(IScopeContext[] lookupOrder, boolean ignoreTopScope, IWorkingCopyManager manager) {
        int i = ignoreTopScope ? 1 : 0;
        while (i < lookupOrder.length) {
            String value = this.getStoredValue(lookupOrder[i], manager);
            if (value != null) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
        if (value != null) {
            this.getNode(context, manager).put(this.fKey, value);
        } else {
            this.getNode(context, manager).remove(this.fKey);
        }
    }

    public void setStoredValue(IScopeContext[] context, String value, IWorkingCopyManager manager) {
        if (value != null) {
            this.getNode(context[0], manager).put(this.fKey, value);
        } else {
            this.getNode(context[0], manager).remove(this.fKey);
        }
    }

    public String toString() {
        return String.valueOf(this.fQualifier) + '/' + this.fKey;
    }

    public String getQualifier() {
        return this.fQualifier;
    }
}

