/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.actions;

import java.util.BitSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.ui.IElementManager;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.internal.ui.UIUtils;
import org.eclipse.ptp.internal.ui.actions.ParallelAction;
import org.eclipse.ptp.internal.ui.messages.Messages;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.ptp.internal.ui.views.AbstractParallelElementView;

public class DeleteSetAction
extends ParallelAction {
    public static final String name = Messages.DeleteSetAction_0;

    public DeleteSetAction(AbstractParallelElementView view) {
        super(name, view);
        this.setImageDescriptor(ParallelImages.ID_ICON_DELETESET_NORMAL);
    }

    @Override
    public void run(BitSet elements) {
    }

    @Override
    public void run() {
        IElementSet set = this.view.getCurrentSet();
        if (set != null && set.size() > 0) {
            IElementHandler setManager = this.view.getCurrentElementHandler();
            if (setManager == null) {
                return;
            }
            if (UIUtils.showQuestionDialog(NLS.bind((String)Messages.DeleteSetAction_1, (Object)set.getID()), Messages.DeleteSetAction_2)) {
                IElementManager uiManager = this.view.getUIManager();
                uiManager.removeSet(set.getID(), setManager);
                IElementSet[] sets = setManager.getSets();
                if (sets.length > 0) {
                    IElementSet lastSet = sets[sets.length - 1];
                    this.view.selectSet(setManager.getSet(lastSet.getID()));
                    this.view.refresh(false);
                }
            }
        }
    }
}

