/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol.raw;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExecutionStatusKind implements Enumerator
{
    STARTED(0, "STARTED", "STARTED"),
    RUNNING(1, "RUNNING", "RUNNING"),
    FINISHED(2, "FINISHED", "FINISHED"),
    CANCELED(3, "CANCELED", "CANCELED"),
    PAUSED(4, "PAUSED", "PAUSED");

    public static final int STARTED_VALUE = 0;
    public static final int RUNNING_VALUE = 1;
    public static final int FINISHED_VALUE = 2;
    public static final int CANCELED_VALUE = 3;
    public static final int PAUSED_VALUE = 4;
    private static final ExecutionStatusKind[] VALUES_ARRAY;
    public static final List<ExecutionStatusKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExecutionStatusKind[]{STARTED, RUNNING, FINISHED, CANCELED, PAUSED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExecutionStatusKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecutionStatusKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecutionStatusKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExecutionStatusKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExecutionStatusKind get(int value) {
        switch (value) {
            case 0: {
                return STARTED;
            }
            case 1: {
                return RUNNING;
            }
            case 2: {
                return FINISHED;
            }
            case 3: {
                return CANCELED;
            }
            case 4: {
                return PAUSED;
            }
        }
        return null;
    }

    private ExecutionStatusKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

