/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.preference;

import org.eclipse.jface.window.Window;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.condition.WindowIsAvailable;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.jface.window.AbstractWindow;
import org.eclipse.reddeer.jface.window.Openable;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.impl.button.CancelButton;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.clabel.DefaultCLabel;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;

public class PreferenceDialog
extends AbstractWindow {
    public PreferenceDialog(String text) {
        super(text);
    }

    public PreferenceDialog(org.eclipse.reddeer.swt.api.Shell shell) {
        super(shell);
    }

    public PreferenceDialog(Matcher<?> ... matchers) {
        super(matchers);
    }

    public PreferenceDialog() {
    }

    public PreferenceDialog select(PreferencePage page) {
        if (page == null) {
            throw new IllegalArgumentException("page can't be null");
        }
        return this.select(page.getPath());
    }

    public PreferenceDialog select(String ... path) {
        if (path == null) {
            throw new IllegalArgumentException("path can't be null");
        }
        if (path.length == 0) {
            throw new IllegalArgumentException("path can't be empty");
        }
        DefaultTreeItem t = new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this), path);
        t.select();
        new WaitUntil((WaitCondition)new WidgetIsFound(CLabel.class, this.getControl(), new Matcher[]{new WithTextMatcher(path[path.length - 1])}), TimePeriod.SHORT, false);
        return this;
    }

    public String getPageName() {
        DefaultCLabel cl = new DefaultCLabel((ReferencedComposite)this);
        return cl.getText();
    }

    public void ok() {
        Shell parentShell = ShellLookup.getInstance().getParentShell((Shell)this.getShell().getSWTWidget());
        WidgetIsFound applyAndCloseButton = new WidgetIsFound(Button.class, this.getControl(), new Matcher[]{new WithMnemonicTextMatcher("Apply and Close")});
        Object button = applyAndCloseButton.test() ? new PushButton((ReferencedComposite)this, "Apply and Close") : new OkButton((ReferencedComposite)this);
        button.click();
        new WaitWhile((WaitCondition)new WindowIsAvailable(this));
        new DefaultShell(parentShell);
    }

    public boolean canFinish() {
        WidgetIsFound applyAndCloseButton = new WidgetIsFound(Button.class, this.getControl(), new Matcher[]{new WithMnemonicTextMatcher("Apply and Close")});
        Object button = applyAndCloseButton.test() ? new PushButton((ReferencedComposite)this, "Apply and Close") : new OkButton((ReferencedComposite)this);
        return button.isEnabled();
    }

    public void cancel() {
        Shell parentShell = ShellLookup.getInstance().getParentShell((Shell)this.getShell().getSWTWidget());
        CancelButton cancel = new CancelButton((ReferencedComposite)this);
        cancel.click();
        new WaitWhile((WaitCondition)new WindowIsAvailable(this));
        new DefaultShell(parentShell);
    }

    @Override
    public Class<? extends Window> getEclipseClass() {
        return org.eclipse.jface.preference.PreferenceDialog.class;
    }

    @Override
    public Openable getDefaultOpenAction() {
        return null;
    }
}

