/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.swt.tools.internal.DOMWriter;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIGeneratorApp;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MacGenerator {
    String[] xmls;
    Document[] documents;
    String outputDir;
    String outputLibDir;
    String extrasDir;
    String mainClassName;
    String selectorEnumName;
    String delimiter = System.lineSeparator();
    PrintWriter out;
    HashSet<String> knownConstTypes = new HashSet();
    public static boolean BUILD_C_SOURCE = true;
    public static boolean GENERATE_ALLOC = true;
    public static boolean GENERATE_STRUCTS = true;
    public static boolean USE_SYSTEM_BRIDGE_FILES = false;

    static void list(File path, ArrayList<String> list) {
        if (path == null) {
            return;
        }
        File[] frameworks = path.listFiles();
        if (frameworks == null) {
            return;
        }
        File[] fileArray = frameworks;
        int n = frameworks.length;
        int n2 = 0;
        while (n2 < n) {
            String xml;
            File file = fileArray[n2];
            String name = file.getName();
            int index = name.lastIndexOf(".");
            if (index != -1 && new File(xml = String.valueOf(file.getAbsolutePath()) + "/Resources/BridgeSupport/" + name.substring(0, index) + "Full.bridgesupport").exists()) {
                list.add(xml);
            }
            ++n2;
        }
    }

    void output(String fileName, char[] source) {
        try {
            if (source.length > 0) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream stream = new PrintStream(out);
                stream.print(source);
                stream.flush();
                JNIGenerator.output(out.toByteArray(), fileName);
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    int getLevel(Node node) {
        int level = 0;
        while (node != null) {
            ++level;
            node = node.getParentNode();
        }
        return level;
    }

    void merge(Document document, Document extraDocument) {
        if (extraDocument == null) {
            return;
        }
        HashMap<String, Node> extras = new HashMap<String, Node>();
        this.buildLookup(extraDocument, extras);
        HashMap<String, Node> lookup = new HashMap<String, Node>();
        this.merge(document, extras, lookup);
        ArrayList<Node> sortedNodes = Collections.list(Collections.enumeration(extras.values()));
        sortedNodes.sort((arg0, arg1) -> {
            int compare = this.getLevel((Node)arg0) - this.getLevel((Node)arg1);
            if (compare == 0) {
                return arg0.getNodeName().compareTo(arg1.getNodeName());
            }
            return compare;
        });
        String delimiter = System.lineSeparator();
        for (Node node : sortedNodes) {
            String name = node.getNodeName();
            if (("arg".equals(name) || "retval".equals(name)) && !sortedNodes.contains(node.getParentNode())) continue;
            Node parent = lookup.get(this.getKey(node.getParentNode()));
            Element element = document.createElement(node.getNodeName());
            String text = parent.getChildNodes().getLength() == 0 ? delimiter : "";
            int i = 0;
            int level = this.getLevel(parent) - 1;
            while (i < level) {
                text = String.valueOf(text) + "  ";
                ++i;
            }
            parent.appendChild(document.createTextNode(text));
            parent.appendChild(element);
            parent.appendChild(document.createTextNode(delimiter));
            NamedNodeMap attributes = node.getAttributes();
            int j = 0;
            int length = attributes.getLength();
            while (j < length) {
                Node attr = attributes.item(j);
                element.setAttribute(attr.getNodeName(), attr.getNodeValue());
                ++j;
            }
            lookup.put(this.getKey(element), element);
        }
    }

    public void generate(ProgressMonitor progress) {
        if (progress != null) {
            progress.setTotal(BUILD_C_SOURCE ? 5 : 4);
            progress.setMessage("extra attributes...");
        }
        this.generateExtraAttributes();
        if (progress != null) {
            progress.step();
            progress.setMessage(this.mainClassName);
        }
        this.generateMainClass();
        if (progress != null) {
            progress.step();
            progress.setMessage("classes...");
        }
        this.generateSelectorEnum();
        if (progress != null) {
            progress.step();
            progress.setMessage("selector enum...");
        }
        this.generateClasses();
        if (GENERATE_STRUCTS) {
            if (progress != null) {
                progress.step();
                progress.setMessage("structs...");
            }
            this.generateStructs();
        }
        if (BUILD_C_SOURCE) {
            if (progress != null) {
                progress.step();
                progress.setMessage("C source...");
            }
            this.generateCSource();
        }
        if (progress != null) {
            progress.step();
            progress.setMessage("Done.");
        }
    }

    void generateCSource() {
        JNIGeneratorApp app = new JNIGeneratorApp();
        String outputLibDir = this.outputLibDir != null ? this.outputLibDir : String.valueOf(this.outputDir) + "/library";
        app.setMainClassName(this.mainClassName, outputLibDir, this.outputDir);
        app.generate();
    }

    String fixDelimiter(String str) {
        if (this.delimiter.equals("\n")) {
            return str;
        }
        int index = 0;
        int length = str.length();
        StringBuilder buffer = new StringBuilder();
        while (index != -1) {
            int start = index;
            if ((index = str.indexOf(10, start)) == -1) {
                buffer.append(str.substring(start, length));
                continue;
            }
            buffer.append(str.substring(start, index));
            buffer.append(this.delimiter);
            ++index;
        }
        return buffer.toString();
    }

    String getParamName(Node param, int i) {
        Node node;
        NamedNodeMap paramAttributes = param.getAttributes();
        Node swtName = paramAttributes.getNamedItem("swt_param_name");
        String paramName = "";
        if (swtName != null) {
            paramName = swtName.getNodeValue();
        } else {
            node = paramAttributes.getNamedItem("name");
            if (node != null) {
                paramName = node.getNodeValue();
            }
        }
        if (paramName.length() == 0) {
            node = paramAttributes.getNamedItem("index");
            String index = "0";
            index = node != null ? node.getNodeValue() : String.valueOf(i);
            paramName = "arg" + index;
        }
        if (paramName.equals("boolean")) {
            paramName = "b";
        }
        return paramName;
    }

    void generateFields(ArrayList<Node> fields) {
        for (Node field : fields) {
            NamedNodeMap fieldAttributes = field.getAttributes();
            String fieldName = fieldAttributes.getNamedItem("name").getNodeValue();
            String fieldType = this.getJavaType(field);
            if (!this.isStruct(field)) {
                this.out("\t/** @field cast=(");
                this.out(this.getCType(field));
                this.out(") */");
                this.outln();
            }
            this.out("\tpublic ");
            this.out(fieldType);
            this.out(" ");
            this.out(fieldName);
            if (this.isStruct(field)) {
                this.out(" = new ");
                this.out(fieldType);
                this.out("()");
            }
            this.out(";");
            this.outln();
        }
    }

    void generateToString(String className, ArrayList<Node> fields) {
        this.outln();
        this.out("\t@Override");
        this.outln();
        this.out("\tpublic String toString() {");
        this.outln();
        this.out("\t\treturn \"");
        this.out(className);
        this.out("{\"");
        boolean first = true;
        for (Node field : fields) {
            if (!first) {
                this.out(" + \",\"");
            }
            NamedNodeMap fieldAttributes = field.getAttributes();
            String fieldName = fieldAttributes.getNamedItem("name").getNodeValue();
            this.out(" + ");
            this.out(fieldName);
            first = false;
        }
        this.out(" + \"}\";");
        this.outln();
        this.out("\t}");
        this.outln();
    }

    private String getDeclaredType(NamedNodeMap map, Node location) {
        Node declaredType = map.getNamedItem("declared_type64");
        if (declaredType == null) {
            declaredType = map.getNamedItem("declared_type");
        }
        if (declaredType == null) {
            System.err.printf("Unable to detect declared_type. Check bridge file! It might have been removed, inheritance changed, etc. It could also be an issue with gen_bridge_metadata. Location: %s %n", this.toDebugLocation(location));
            return "nodeclaredtype";
        }
        String value = declaredType.getNodeValue();
        value = value.replace("_Nullable", "").replace("_Nonnull", "").replace("_Null_unspecified", "");
        value = value.replace(">", "");
        value = value.replace("__kindof", "");
        value = value.replace("ObjectType", "id").replace("KeyType", "id");
        value = value.replace("struct ", "");
        value = value.replaceAll("\\s", "");
        return value;
    }

    void generateMethods(String className, ArrayList<Node> methods) {
        for (Node method : methods) {
            Node param;
            Node returnNode;
            String returnType;
            NamedNodeMap mthAttributes = method.getAttributes();
            String sel = mthAttributes.getNamedItem("selector").getNodeValue();
            if ("NSObject".equals(className) && ("alloc".equals(sel) || "dealloc".equals(sel))) continue;
            this.out("public ");
            boolean isStatic = this.isStatic(method);
            if (isStatic) {
                this.out("static ");
            }
            if ((returnType = this.getJavaType(returnNode = this.getReturnNode(method))).equals("instancetype")) {
                returnType = className;
            }
            this.out(returnType);
            this.out(" ");
            String methodName = sel;
            if (this.isUnique(method, methods)) {
                int index = methodName.indexOf(58);
                if (index != -1) {
                    methodName = methodName.substring(0, index);
                }
            } else {
                methodName = methodName.replaceAll(":", "_");
                if (isStatic) {
                    methodName = "static_" + methodName;
                }
            }
            this.out(methodName);
            this.out("(");
            NodeList params = method.getChildNodes();
            boolean first = true;
            int argIndex = 0;
            int k = 0;
            while (k < params.getLength()) {
                param = params.item(k);
                if ("arg".equals(param.getNodeName())) {
                    if (!first) {
                        this.out(", ");
                    }
                    first = false;
                    this.out(this.getJavaType(param));
                    this.out(" ");
                    this.out(this.getParamName(param, argIndex++));
                }
                ++k;
            }
            this.out(") {");
            this.outln();
            if (this.isStruct(returnNode)) {
                this.out("\t");
                this.out(returnType);
                this.out(" result = new ");
                this.out(returnType);
                this.out("();");
                this.outln();
                this.out("\tOS.objc_msgSend_stret(result, ");
            } else if (this.isObject(returnNode)) {
                this.out("\tlong result = OS.objc_msgSend(");
            } else if (returnType.equals("void")) {
                this.out("\tOS.objc_msgSend(");
            } else if (returnType.equals("boolean")) {
                this.out("\treturn OS.objc_msgSend_bool(");
            } else if (returnType.equals("float")) {
                this.out("\treturn OS.objc_msgSend_floatret(");
            } else if (returnType.equals("double")) {
                this.out("\treturn OS.objc_msgSend_fpret(");
            } else {
                this.out("\treturn ");
                if (!returnType.equals("long")) {
                    this.out("(");
                    this.out(returnType);
                    this.out(")");
                }
                this.out("OS.objc_msgSend(");
            }
            if (isStatic) {
                this.out("OS.class_");
                this.out(className);
            } else {
                this.out("this.id");
            }
            this.out(", OS.");
            this.out(this.getSelConst(sel));
            first = false;
            argIndex = 0;
            k = 0;
            while (k < params.getLength()) {
                param = params.item(k);
                if ("arg".equals(param.getNodeName())) {
                    if (!first) {
                        this.out(", ");
                    }
                    first = false;
                    String paramName = this.getParamName(param, argIndex++);
                    if (this.isObject(param)) {
                        this.out(paramName);
                        this.out(" != null ? ");
                        this.out(paramName);
                        this.out(".id : 0");
                    } else {
                        this.out(paramName);
                    }
                }
                ++k;
            }
            this.out(")");
            this.out(";");
            this.outln();
            if (this.isObject(returnNode)) {
                if (!isStatic && returnType.equals(className)) {
                    this.out("\treturn result == this.id ? this : (result != 0 ? new ");
                    this.out(returnType);
                    this.out("(result) : null);");
                } else {
                    this.out("\treturn result != 0 ? new ");
                    NamedNodeMap attributes = returnNode.getAttributes();
                    Node swt_alloc = attributes.getNamedItem("swt_alloc");
                    if (swt_alloc != null && swt_alloc.getNodeValue().equals("true")) {
                        this.out(className);
                    } else {
                        this.out(returnType);
                    }
                    this.out("(result) : null;");
                }
                this.outln();
            } else if (this.isStruct(returnNode)) {
                this.out("\treturn result;");
                this.outln();
            }
            this.out("}");
            this.outln();
            this.outln();
        }
    }

    void generateExtraFields(String className) {
        this.out("\t");
        this.out("public static final int sizeof = OS." + className + "_sizeof();");
        this.outln();
    }

    void generateExtraMethods(String className) {
        this.out("public ");
        this.out(className);
        this.out("() {");
        this.outln();
        this.out("\tsuper();");
        this.outln();
        this.out("}");
        this.outln();
        this.outln();
        this.out("public ");
        this.out(className);
        this.out("(long id) {");
        this.outln();
        this.out("\tsuper(id);");
        this.outln();
        this.out("}");
        this.outln();
        this.outln();
        this.out("public ");
        this.out(className);
        this.out("(id id) {");
        this.outln();
        this.out("\tsuper(id);");
        this.outln();
        this.out("}");
        this.outln();
        this.outln();
        if (className.equals("NSObject") && GENERATE_ALLOC) {
            this.out("public NSObject alloc() {");
            this.outln();
            this.out("\tthis.id = OS.objc_msgSend(objc_getClass(), OS.sel_alloc);");
            this.outln();
            this.out("\treturn this;");
            this.outln();
            this.out("}");
            this.outln();
            this.outln();
        }
        if (className.equals("NSString")) {
            this.out("public String getString() {");
            this.outln();
            this.out("\tchar[] buffer = new char[(int)length()];");
            this.outln();
            this.out("\tgetCharacters(buffer);");
            this.outln();
            this.out("\treturn new String(buffer);");
            this.outln();
            this.out("}");
            this.outln();
            this.outln();
            this.out("public NSString initWithString(String str) {");
            this.outln();
            this.out("\tchar[] buffer = new char[str.length()];");
            this.outln();
            this.out("\tstr.getChars(0, buffer.length, buffer, 0);");
            this.outln();
            this.out("\treturn initWithCharacters(buffer, buffer.length);");
            this.outln();
            this.out("}");
            this.outln();
            this.outln();
            this.out("public static NSString stringWith(String str) {");
            this.outln();
            this.out("\tchar[] buffer = new char[str.length()];");
            this.outln();
            this.out("\tstr.getChars(0, buffer.length, buffer, 0);");
            this.outln();
            this.out("\treturn stringWithCharacters(buffer, buffer.length);");
            this.outln();
            this.out("}");
            this.outln();
            this.outln();
        }
    }

    TreeMap<String, Object[]> getGeneratedClasses() {
        TreeMap<String, Object[]> classes = new TreeMap<String, Object[]>();
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if ("class".equals(node.getNodeName()) && this.getGen(node)) {
                        ArrayList methods;
                        String name = node.getAttributes().getNamedItem("name").getNodeValue();
                        Object[] clazz = classes.get(name);
                        if (clazz == null) {
                            methods = new ArrayList();
                            classes.put(name, new Object[]{node, methods});
                        } else {
                            methods = (ArrayList)clazz[1];
                        }
                        NodeList methodList = node.getChildNodes();
                        int j = 0;
                        while (j < methodList.getLength()) {
                            Node method = methodList.item(j);
                            if ("method".equals(method.getNodeName()) && this.getGen(method)) {
                                methods.add(method);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++x;
        }
        return classes;
    }

    TreeMap<String, Object[]> getGeneratedStructs() {
        TreeMap<String, Object[]> structs = new TreeMap<String, Object[]>();
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if ("struct".equals(node.getNodeName()) && this.getGen(node)) {
                        ArrayList fields;
                        String name = node.getAttributes().getNamedItem("name").getNodeValue();
                        Object[] clazz = structs.get(name);
                        if (clazz == null) {
                            fields = new ArrayList();
                            structs.put(name, new Object[]{node, fields});
                        } else {
                            fields = (ArrayList)clazz[1];
                        }
                        NodeList fieldList = node.getChildNodes();
                        int j = 0;
                        while (j < fieldList.getLength()) {
                            Node field = fieldList.item(j);
                            if ("field".equals(field.getNodeName()) && this.getGen(field)) {
                                fields.add(field);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++x;
        }
        return structs;
    }

    void copyClassMethodsDown(final Map<String, Object[]> classes) {
        ArrayList<Object[]> sortedClasses = Collections.list(Collections.enumeration(classes.values()));
        sortedClasses.sort(new Comparator<Object[]>(){

            private int getHierarchyLevel(Node node) {
                String superclass = MacGenerator.this.getSuperclassName(node);
                int level = 0;
                while (!superclass.equals("id") && !superclass.equals("NSObject")) {
                    ++level;
                    superclass = MacGenerator.this.getSuperclassName((Node)((Object[])classes.get(superclass))[0]);
                }
                return level;
            }

            @Override
            public int compare(Object[] arg0, Object[] arg1) {
                return this.getHierarchyLevel((Node)arg0[0]) - this.getHierarchyLevel((Node)arg1[0]);
            }
        });
        for (Object[] clazz : sortedClasses) {
            Node node = (Node)clazz[0];
            ArrayList methods = (ArrayList)clazz[1];
            Object[] superclass = classes.get(this.getSuperclassName(node));
            if (superclass == null) continue;
            for (Node method : (ArrayList)superclass[1]) {
                if (!this.isStatic(method)) continue;
                methods.add(method);
            }
        }
    }

    String getSuperclassName(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node superclass = attributes.getNamedItem("swt_superclass");
        if (superclass != null) {
            return superclass.getNodeValue();
        }
        Node name = attributes.getNamedItem("name");
        if (name.getNodeValue().equals("NSObject")) {
            return "id";
        }
        return "NSObject";
    }

    void generateClasses() {
        MetaData metaData = new MetaData(this.mainClassName);
        TreeMap<String, Object[]> classes = this.getGeneratedClasses();
        this.copyClassMethodsDown(classes);
        for (Map.Entry<String, Object[]> clazzes : classes.entrySet()) {
            CharArrayWriter out = new CharArrayWriter();
            this.out = new PrintWriter(out);
            this.out(this.fixDelimiter(metaData.getCopyright()));
            String className = clazzes.getKey();
            Object[] clazz = clazzes.getValue();
            Node node = (Node)clazz[0];
            ArrayList methods = (ArrayList)clazz[1];
            this.out("package ");
            String packageName = this.getPackageName();
            this.out(packageName);
            this.out(";");
            this.outln();
            this.outln();
            this.out("public class ");
            this.out(className);
            this.out(" extends ");
            this.out(this.getSuperclassName(node));
            this.out(" {");
            this.outln();
            this.outln();
            this.generateExtraMethods(className);
            this.generateMethods(className, methods);
            this.out("}");
            this.outln();
            String fileName = String.valueOf(this.outputDir) + packageName.replace('.', '/') + "/" + className + ".java";
            this.out.flush();
            this.output(fileName, out.toCharArray());
            this.out = null;
        }
    }

    void generateStructs() {
        MetaData metaData = new MetaData(this.mainClassName);
        TreeMap<String, Object[]> structs = this.getGeneratedStructs();
        for (Map.Entry<String, Object[]> structEntry : structs.entrySet()) {
            CharArrayWriter out = new CharArrayWriter();
            this.out = new PrintWriter(out);
            this.out(this.fixDelimiter(metaData.getCopyright()));
            String className = structEntry.getKey();
            Object[] clazz = structEntry.getValue();
            Node field = (Node)clazz[0];
            ArrayList fields = (ArrayList)clazz[1];
            this.out("package ");
            String packageName = this.getPackageName();
            this.out(packageName);
            this.out(";");
            this.outln();
            this.outln();
            this.out("public class ");
            this.out(className);
            this.out(" {");
            this.outln();
            this.generateFields(fields);
            this.generateExtraFields(className);
            if (this.getGenToString(field)) {
                this.generateToString(className, fields);
            }
            this.out("}");
            this.outln();
            String fileName = String.valueOf(this.outputDir) + packageName.replace('.', '/') + "/" + className + ".java";
            this.out.flush();
            this.output(fileName, out.toCharArray());
            this.out = null;
        }
    }

    void generateExtraAttributes() {
        Document[] documents = this.getDocuments();
        int x = 0;
        while (x < this.xmls.length) {
            Document document = documents[x];
            if (document != null && this.getGen(document.getDocumentElement())) {
                this.saveExtraAttributes(this.xmls[x], document);
            }
            ++x;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void generateMainClass() {
        String fileName;
        String footer;
        String header;
        CharArrayWriter out;
        block17: {
            out = new CharArrayWriter();
            this.out = new PrintWriter(out);
            header = "";
            footer = "";
            fileName = String.valueOf(this.outputDir) + this.mainClassName.replace('.', '/') + ".java";
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try {
                    FileInputStream is = new FileInputStream(fileName);
                    try {
                        try (InputStreamReader input = new InputStreamReader(new BufferedInputStream(is));){
                            int end;
                            StringBuilder str = new StringBuilder();
                            char[] buffer = new char[4096];
                            while (true) {
                                int read;
                                if ((read = input.read(buffer)) == -1) {
                                    String section = "/** This section is auto generated */";
                                    int start = str.indexOf(section) + section.length();
                                    end = str.indexOf(section, start);
                                    header = str.substring(0, start);
                                }
                                str.append(buffer, 0, read);
                            }
                            footer = end == -1 ? "\n}" : str.substring(end);
                            input.close();
                        }
                        if (is == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        this.out(header);
        this.outln();
        this.outln();
        this.out("/** Custom callbacks */");
        this.outln();
        this.generateCustomCallbacks();
        this.outln();
        this.out("/** Classes */");
        this.outln();
        this.generateClassesConst();
        this.outln();
        this.out("/** Protocols */");
        this.outln();
        this.generateProtocolsConst();
        this.outln();
        this.out("/** Selectors */");
        this.outln();
        this.generateSelectorsConst();
        this.outln();
        this.out("/** Constants */");
        this.outln();
        this.generateEnums();
        this.outln();
        this.out("/** Globals */");
        this.outln();
        this.generateConstants();
        this.outln();
        this.out("/** Functions */");
        this.outln();
        this.outln();
        this.generateFunctions();
        this.outln();
        this.out("/** Super Sends */");
        this.outln();
        this.generateSends(true);
        this.outln();
        this.out("/** Sends */");
        this.outln();
        this.generateSends(false);
        this.outln();
        this.generateStructNatives();
        this.outln();
        this.out(footer);
        this.out.flush();
        this.output(fileName, out.toCharArray());
        this.out = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void generateSelectorEnum() {
        String fileName;
        String footer;
        String header;
        CharArrayWriter out;
        block17: {
            out = new CharArrayWriter();
            this.out = new PrintWriter(out);
            header = "";
            footer = "";
            fileName = String.valueOf(this.outputDir) + this.selectorEnumName.replace('.', '/') + ".java";
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try {
                    FileInputStream is = new FileInputStream(fileName);
                    try {
                        try (InputStreamReader input = new InputStreamReader(new BufferedInputStream(is));){
                            int end;
                            StringBuilder str = new StringBuilder();
                            char[] buffer = new char[4096];
                            while (true) {
                                int read;
                                if ((read = input.read(buffer)) == -1) {
                                    String section = "/** This section is auto generated */";
                                    int start = str.indexOf(section) + section.length();
                                    end = str.indexOf(section, start);
                                    header = str.substring(0, start);
                                }
                                str.append(buffer, 0, read);
                            }
                            footer = end == -1 ? "\n}" : str.substring(end);
                            input.close();
                        }
                        if (is == null) break block17;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        this.out(header);
        this.outln();
        this.outln();
        this.generateSelectorsEnumLiteral();
        this.out(";");
        this.outln();
        String mainClassShortName = this.mainClassName.substring(this.mainClassName.lastIndexOf(46) + 1);
        this.out("\tfinal String name;");
        this.outln();
        this.out("\tfinal long value;");
        this.outln();
        this.outln();
        this.out("\tprivate Selector(String name) {");
        this.outln();
        this.out("\t\tthis.name= name;");
        this.outln();
        this.out("\t\tthis.value = " + mainClassShortName + ".sel_registerName(name);");
        this.outln();
        this.out("\t\t" + mainClassShortName + ".registerSelector(value,this);");
        this.outln();
        this.out("\t}");
        this.outln();
        this.outln();
        this.out("\tpublic static Selector valueOf(long value) {");
        this.outln();
        this.out("\t\treturn " + mainClassShortName + ".getSelector(value);");
        this.outln();
        this.out("\t}");
        this.outln();
        this.out(footer);
        this.out.flush();
        this.output(fileName, out.toCharArray());
        this.out = null;
    }

    public Document[] getDocuments() {
        if (this.documents == null) {
            String[] xmls = this.getXmls();
            this.documents = new Document[xmls.length];
            int i = 0;
            while (i < xmls.length) {
                String xmlPath = xmls[i];
                this.documents[i] = this.getDocument(xmlPath);
                Document document = this.documents[i];
                if (document != null && this.mainClassName != null && this.outputDir != null) {
                    String packageName = this.getPackageName();
                    String folder = this.extrasDir != null ? this.extrasDir : String.valueOf(this.outputDir) + packageName.replace('.', '/');
                    String extrasPath = String.valueOf(folder) + "/" + this.getFileName(xmlPath) + ".extras";
                    this.merge(document, this.getDocument(extrasPath));
                }
                ++i;
            }
        }
        return this.documents;
    }

    public String[] getXmls() {
        if (this.xmls == null || this.xmls.length == 0) {
            ArrayList<String> array = new ArrayList<String>();
            if (USE_SYSTEM_BRIDGE_FILES) {
                MacGenerator.list(new File("/System/Library/Frameworks"), array);
                MacGenerator.list(new File("/System/Library/Frameworks/CoreServices.framework/Frameworks"), array);
                MacGenerator.list(new File("/System/Library/Frameworks/ApplicationServices.framework/Frameworks"), array);
            } else {
                String packageName = this.getPackageName();
                File folder = new File(this.extrasDir != null ? this.extrasDir : String.valueOf(this.outputDir) + packageName.replace('.', '/'));
                File[] files = folder.listFiles((dir, name) -> name.endsWith("Full.bridgesupport"));
                if (files == null) {
                    files = new File[]{};
                }
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    array.add(file.getAbsolutePath());
                    ++n2;
                }
            }
            array.sort((o1, o2) -> new File((String)o1).getName().compareTo(new File((String)o2).getName()));
            this.xmls = array.toArray(new String[array.size()]);
        }
        return this.xmls;
    }

    void saveExtraAttributes(String xmlPath, Document document) {
        try {
            String packageName = this.getPackageName();
            String folder = this.extrasDir != null ? this.extrasDir : String.valueOf(this.outputDir) + packageName.replace('.', '/');
            String fileName = String.valueOf(folder) + "/" + this.getFileName(xmlPath) + ".extras";
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DOMWriter writer = new DOMWriter(new PrintStream(out));
            String[] names = this.getIDAttributeNames();
            String[] filter = new String[names.length + 2];
            filter[0] = "class_method";
            filter[1] = "swt_.*";
            System.arraycopy(names, 0, filter, 2, names.length);
            writer.setIDAttributes(names);
            writer.setAttributeFilter(filter);
            writer.setNodeFilter("swt_");
            writer.print(document);
            if (out.size() > 0) {
                JNIGenerator.output(out.toByteArray(), fileName);
            }
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String dir) {
        if (dir != null && !dir.endsWith("\\") && !dir.endsWith("/")) {
            dir = String.valueOf(dir) + "/";
        }
        this.outputDir = dir;
    }

    public void setOutputLibDir(String dir) {
        if (dir != null && !dir.endsWith("\\") && !dir.endsWith("/")) {
            dir = String.valueOf(dir) + "/";
        }
        this.outputLibDir = dir;
    }

    public void setExtrasDir(String dir) {
        if (dir != null && !dir.endsWith("\\") && !dir.endsWith("/")) {
            dir = String.valueOf(dir) + "/";
        }
        this.extrasDir = dir;
    }

    public void setXmls(String[] xmls) {
        this.xmls = xmls;
        this.documents = null;
    }

    public void setMainClass(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public void setSelectorEnum(String selectorEnumName) {
        this.selectorEnumName = selectorEnumName;
    }

    Document getDocument(String xmlPath) {
        try {
            InputStream is = null;
            if (xmlPath.indexOf(File.separatorChar) == -1) {
                is = this.getClass().getResourceAsStream(xmlPath);
            }
            if (is == null) {
                is = new BufferedInputStream(new FileInputStream(xmlPath));
            }
            if (is != null) {
                return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(is));
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public String[] getExtraAttributeNames(Node node) {
        String name = node.getNodeName();
        if (name.equals("method")) {
            NamedNodeMap attribs = node.getAttributes();
            if (attribs != null && attribs.getNamedItem("variadic") != null) {
                return new String[]{"swt_gen_super_msgSend", "swt_gen_custom_callback", "swt_variadic_count", "swt_variadic_java_types"};
            }
            return new String[]{"swt_gen_super_msgSend", "swt_gen_custom_callback"};
        }
        if (name.equals("function")) {
            NamedNodeMap attribs = node.getAttributes();
            if (attribs != null && attribs.getNamedItem("variadic") != null) {
                return new String[]{"swt_variadic_count", "swt_variadic_java_types"};
            }
        } else {
            if (name.equals("class")) {
                return new String[]{"swt_superclass"};
            }
            if (name.equals("struct")) {
                return new String[]{"swt_gen_memmove", "swt_gen_tostring"};
            }
            if (name.equals("retval")) {
                return new String[]{"swt_java_type", "swt_java_type64", "swt_alloc"};
            }
            if (name.equals("arg")) {
                return new String[]{"swt_java_type", "swt_java_type64", "swt_param_name", "swt_param_cast"};
            }
        }
        return new String[0];
    }

    public String getFileName(String xmlPath) {
        File file = new File(xmlPath);
        return file.getName();
    }

    int indexOfNode(Node node) {
        Node parent = node.getParentNode();
        int count = 0;
        Node temp = parent.getFirstChild();
        while (temp != node) {
            ++count;
            temp = temp.getNextSibling();
        }
        return count;
    }

    String getKey(Node node) {
        StringBuilder buffer = new StringBuilder();
        while (node != null) {
            if (buffer.length() > 0) {
                buffer.append("_");
            }
            String name = node.getNodeName();
            StringBuilder key = new StringBuilder(name);
            if ("arg".equals(name)) {
                key.append("-");
                key.append(this.indexOfNode(node));
            } else {
                Node nameAttrib = this.getIDAttribute(node);
                if (nameAttrib != null) {
                    key.append("-");
                    key.append(nameAttrib.getNodeValue());
                }
            }
            NamedNodeMap attributes = node.getAttributes();
            if (attributes != null) {
                boolean isStatic;
                boolean bl = isStatic = attributes.getNamedItem("class_method") != null;
                if (isStatic) {
                    key.append("-static");
                }
            }
            buffer.append((CharSequence)key.reverse());
            node = node.getParentNode();
        }
        buffer.reverse();
        return buffer.toString();
    }

    public Node getIDAttribute(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        String[] stringArray = this.getIDAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Node nameAttrib = attributes.getNamedItem(name);
            if (nameAttrib != null) {
                return nameAttrib;
            }
            ++n2;
        }
        return null;
    }

    public String[] getIDAttributeNames() {
        return new String[]{"name", "selector", "path"};
    }

    void merge(Node node, HashMap<String, Node> extras, HashMap<String, Node> docLookup) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() == 1) {
                Node extra;
                String key = this.getKey(childNode);
                if (docLookup != null && docLookup.get(key) == null) {
                    docLookup.put(key, childNode);
                }
                if ((extra = extras.remove(key)) != null) {
                    NamedNodeMap attributes = extra.getAttributes();
                    int j = 0;
                    int length = attributes.getLength();
                    while (j < length) {
                        Node attr = attributes.item(j);
                        String name = attr.getNodeName();
                        if (name.startsWith("swt_")) {
                            ((Element)childNode).setAttribute(name, attr.getNodeValue());
                        }
                        ++j;
                    }
                }
            }
            this.merge(childNode, extras, docLookup);
            ++i;
        }
    }

    void out(String str) {
        PrintWriter out = this.out;
        out.print(str);
    }

    void outln() {
        PrintWriter out = this.out;
        out.print(this.delimiter);
    }

    void generateConstants() {
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if ("constant".equals(node.getNodeName())) {
                        if (this.getGen(node)) {
                            NamedNodeMap attributes = node.getAttributes();
                            String constName = attributes.getNamedItem("name").getNodeValue();
                            this.out("/** @method flags=const */");
                            this.outln();
                            this.out("public static final native ");
                            this.out(this.getType(node));
                            this.out(" ");
                            this.out(constName);
                            this.out("();");
                            this.outln();
                            if (this.isObject(node)) {
                                this.out("public static final NSString ");
                                this.out(constName);
                                this.out(" = new NSString(");
                                this.out(constName);
                                this.out("());");
                                this.outln();
                            }
                        }
                        if (this.isObject(node)) {
                            this.knownConstTypes.add(this.getCType(node));
                        }
                    }
                    ++i;
                }
            }
            ++x;
        }
        this.knownConstTypes.remove("id");
    }

    void generateEnums() {
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if ("enum".equals(node.getNodeName()) && this.getGen(node)) {
                        NamedNodeMap attributes = node.getAttributes();
                        Node valueNode = attributes.getNamedItem("value64");
                        if (valueNode == null) {
                            valueNode = attributes.getNamedItem("value");
                        }
                        if (valueNode != null) {
                            String value = valueNode.getNodeValue();
                            this.out("public static final ");
                            boolean isLong = false;
                            if (value.indexOf(46) != -1) {
                                this.out("double ");
                            } else if (value.equals("4294967295")) {
                                this.out("int ");
                                value = "-1";
                            } else if (value.equals("18446744073709551615")) {
                                this.out("long ");
                                value = "-1L";
                            } else {
                                try {
                                    Integer.parseInt(value);
                                    this.out("int ");
                                }
                                catch (NumberFormatException numberFormatException) {
                                    isLong = true;
                                    this.out("long ");
                                }
                            }
                            this.out(attributes.getNamedItem("name").getNodeValue());
                            this.out(" = ");
                            this.out(value);
                            if (isLong && !value.endsWith("L")) {
                                this.out("L");
                            }
                            this.out(";");
                            this.outln();
                        } else {
                            System.err.printf("No value for enum. Check bridge file! It might have been removed, renamed, etc. Location: %s %n", this.toDebugLocation(node));
                        }
                    }
                    ++i;
                }
            }
            ++x;
        }
    }

    boolean getGen(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        Node gen = attributes.getNamedItem("swt_gen");
        return gen != null && !gen.getNodeValue().equals("false");
    }

    boolean getGenSuper(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        Node gen = attributes.getNamedItem("swt_gen_super_msgSend");
        return gen != null && !gen.getNodeValue().equals("false");
    }

    boolean getGenCallback(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        Node gen = attributes.getNamedItem("swt_gen_custom_callback");
        return gen != null && !gen.getNodeValue().equals("false");
    }

    boolean getGenMemmove(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        Node gen = attributes.getNamedItem("swt_gen_memmove");
        return gen != null && !gen.getNodeValue().equals("false");
    }

    boolean getGenToString(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return false;
        }
        Node gen = attributes.getNamedItem("swt_gen_tostring");
        return gen != null && !gen.getNodeValue().equals("false");
    }

    boolean isStatic(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node isStatic = attributes.getNamedItem("class_method");
        return isStatic != null && isStatic.getNodeValue().equals("true");
    }

    boolean isStruct(Node node) {
        return this.getTypeCode(node) == '{';
    }

    boolean isPointer(Node node) {
        return this.getTypeCode(node) == '^';
    }

    boolean isObject(Node node) {
        return this.getTypeCode(node) == '@';
    }

    void buildLookup(Node node, HashMap<String, Node> table) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeType() == 1) {
                String key = this.getKey(childNode);
                if (table.get(key) == null) {
                    table.put(key, childNode);
                }
                this.buildLookup(childNode, table);
            }
            ++i;
        }
    }

    boolean isUnique(Node method, ArrayList<Node> methods) {
        String methodName = method.getAttributes().getNamedItem("selector").getNodeValue();
        String signature = "";
        NodeList params = method.getChildNodes();
        int k = 0;
        while (k < params.getLength()) {
            Node param = params.item(k);
            if ("arg".equals(param.getNodeName())) {
                signature = String.valueOf(signature) + this.getJavaType(param);
            }
            ++k;
        }
        int index = methodName.indexOf(58);
        if (index != -1) {
            methodName = methodName.substring(0, index);
        }
        for (Node other : methods) {
            NamedNodeMap attributes = other.getAttributes();
            Node otherSel = null;
            if (attributes != null) {
                otherSel = attributes.getNamedItem("selector");
            }
            if (other == method || otherSel == null) continue;
            String otherName = otherSel.getNodeValue();
            index = otherName.indexOf(58);
            if (index != -1) {
                otherName = otherName.substring(0, index);
            }
            if (!methodName.equals(otherName)) continue;
            NodeList otherParams = other.getChildNodes();
            String otherSignature = "";
            int k2 = 0;
            while (k2 < otherParams.getLength()) {
                Node param = otherParams.item(k2);
                if ("arg".equals(param.getNodeName())) {
                    otherSignature = String.valueOf(otherSignature) + this.getJavaType(param);
                }
                ++k2;
            }
            if (!signature.equals(otherSignature)) continue;
            return false;
        }
        return true;
    }

    void generateSelectorsConst() {
        TreeSet<String> set = new TreeSet<String>();
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if (("class".equals(node.getNodeName()) || "informal_protocol".equals(node.getNodeName())) && this.getGen(node)) {
                        NodeList methods = node.getChildNodes();
                        int j = 0;
                        while (j < methods.getLength()) {
                            Node method = methods.item(j);
                            if (this.getGen(method)) {
                                NamedNodeMap mthAttributes = method.getAttributes();
                                String sel = mthAttributes.getNamedItem("selector").getNodeValue();
                                set.add(sel);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++x;
        }
        if (set.size() > 0) {
            set.add("alloc");
            set.add("dealloc");
        }
        this.out("private static java.util.Map<Long,Selector> SELECTORS;");
        this.outln();
        this.out("public static void registerSelector (Long value, Selector selector) {");
        this.outln();
        this.out("\tif (SELECTORS == null) {");
        this.outln();
        this.out("\t\tSELECTORS = new java.util.HashMap<>();");
        this.outln();
        this.out("\t}");
        this.outln();
        this.out("\tSELECTORS.put(value, selector);");
        this.outln();
        this.out("}");
        this.outln();
        this.out("public static Selector getSelector (long value) {");
        this.outln();
        this.out("\treturn SELECTORS.get(value);");
        this.outln();
        this.out("}");
        this.outln();
        for (String sel : set) {
            String selConst = this.getSelConst(sel);
            this.out("public static final long ");
            this.out(selConst);
            this.out(" = ");
            this.out("Selector." + selConst + ".value;");
            this.outln();
        }
    }

    void generateSelectorsEnumLiteral() {
        TreeSet<String> set = new TreeSet<String>();
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if (("class".equals(node.getNodeName()) || "informal_protocol".equals(node.getNodeName())) && this.getGen(node)) {
                        NodeList methods = node.getChildNodes();
                        int j = 0;
                        while (j < methods.getLength()) {
                            Node method = methods.item(j);
                            if (this.getGen(method)) {
                                NamedNodeMap mthAttributes = method.getAttributes();
                                String sel = mthAttributes.getNamedItem("selector").getNodeValue();
                                set.add(sel);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++x;
        }
        if (set.size() > 0) {
            set.add("alloc");
            set.add("dealloc");
        }
        for (String sel : set) {
            String selConst = this.getSelConst(sel);
            this.out("\t, " + selConst + "(\"" + sel + "\")");
            this.outln();
        }
    }

    void generateStructNatives() {
        TreeSet<String> set = new TreeSet<String>();
        TreeSet<String> memmoveSet = new TreeSet<String>();
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if ("struct".equals(node.getNodeName())) {
                        String className = this.getIDAttribute(node).getNodeValue();
                        if (this.getGen(node)) {
                            set.add(className);
                        }
                        if (this.getGenMemmove(node)) {
                            memmoveSet.add(className);
                        }
                    }
                    ++i;
                }
            }
            ++x;
        }
        set.addAll(memmoveSet);
        this.out("/** Sizeof natives */");
        this.outln();
        for (String struct : set) {
            this.out("public static final native int ");
            this.out(struct);
            this.out("_sizeof();");
            this.outln();
        }
        this.outln();
        this.out("/** Memmove natives */");
        this.outln();
        this.outln();
        for (String struct : memmoveSet) {
            this.out("/**");
            this.outln();
            this.out(" * @param dest cast=(void *)");
            this.outln();
            this.out(" * @param src flags=no_out");
            this.outln();
            this.out(" */");
            this.outln();
            this.out("public static final native void memmove(");
            this.out("long dest, ");
            this.out(struct);
            this.out(" src, long size);");
            this.outln();
            this.out("/**");
            this.outln();
            this.out(" * @param dest flags=no_in");
            this.outln();
            this.out(" * @param src cast=(void *)");
            this.outln();
            this.out(" */");
            this.outln();
            this.out("public static final native void memmove(");
            this.out(struct);
            this.out(" dest, long src, long size);");
            this.outln();
        }
    }

    String buildSend(Node method, boolean superCall) {
        Node returnNode = this.getReturnNode(method);
        String returnType = this.getJavaType(returnNode);
        StringBuilder buffer = new StringBuilder();
        buffer.append("public static final native ");
        if (this.isStruct(returnNode)) {
            buffer.append("void ");
            buffer.append(superCall ? "objc_msgSendSuper_stret" : "objc_msgSend_stret");
            buffer.append("(");
            buffer.append(returnType);
            buffer.append(" result, ");
        } else if (returnType.equals("float")) {
            buffer.append("float ");
            buffer.append(superCall ? "objc_msgSendSuper_floatret" : "objc_msgSend_floatret");
            buffer.append("(");
        } else if (returnType.equals("double")) {
            buffer.append("double ");
            buffer.append(superCall ? "objc_msgSendSuper_fpret" : "objc_msgSend_fpret");
            buffer.append("(");
        } else if (returnType.equals("boolean")) {
            buffer.append("boolean ");
            buffer.append(superCall ? "objc_msgSendSuper_bool" : "objc_msgSend_bool");
            buffer.append("(");
        } else {
            buffer.append("long");
            buffer.append(" ");
            buffer.append(superCall ? "objc_msgSendSuper" : "objc_msgSend");
            buffer.append("(");
        }
        if (superCall) {
            buffer.append("objc_super superId, long sel");
        } else {
            buffer.append("long id, long sel");
        }
        NodeList params = method.getChildNodes();
        boolean first = false;
        int count = 0;
        int k = 0;
        while (k < params.getLength()) {
            Node param = params.item(k);
            if ("arg".equals(param.getNodeName())) {
                if (!first) {
                    buffer.append(", ");
                }
                first = false;
                buffer.append(this.getType(param));
                buffer.append(" arg");
                buffer.append(count++);
            }
            ++k;
        }
        buffer.append(");");
        return buffer.toString();
    }

    String getCType(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        return this.getDeclaredType(attributes, node);
    }

    Node findNSObjectMethod(Node method) {
        NamedNodeMap methodAttributes = method.getAttributes();
        String selector = methodAttributes.getNamedItem("selector").getNodeValue();
        NodeList list = method.getParentNode().getParentNode().getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            NamedNodeMap classAttributes;
            Node cls = list.item(i);
            if ("class".equals(cls.getNodeName()) && "NSObject".equals((classAttributes = cls.getAttributes()).getNamedItem("name").getNodeValue())) {
                NodeList methods = cls.getChildNodes();
                int j = 0;
                while (j < methods.getLength()) {
                    NamedNodeMap mthAttributes;
                    Node mth = methods.item(j);
                    if ("method".equals(mth.getNodeName()) && selector.equals((mthAttributes = mth.getAttributes()).getNamedItem("selector").getNodeValue())) {
                        return mth;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    void generateCustomCallbacks() {
        TreeMap<String, Node> set = new TreeMap<String, Node>();
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if (("class".equals(node.getNodeName()) || "informal_protocol".equals(node.getNodeName())) && this.getGen(node)) {
                        NodeList methods = node.getChildNodes();
                        int j = 0;
                        while (j < methods.getLength()) {
                            Node method = methods.item(j);
                            if ("method".equals(method.getNodeName()) && this.getGen(method) && this.getGenCallback(method)) {
                                NamedNodeMap mthAttributes = method.getAttributes();
                                String sel = mthAttributes.getNamedItem("selector").getNodeValue();
                                set.put(sel, method);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++x;
        }
        for (Map.Entry entry : set.entrySet()) {
            Node param;
            String key = (String)entry.getKey();
            Node method = (Node)entry.getValue();
            if ("informal_protocol".equals(method.getParentNode().getNodeName()) && (method = this.findNSObjectMethod(method)) == null) continue;
            String nativeMth = key.replaceAll(":", "_");
            this.out("/** @method callback_types=");
            Node returnNode = this.getReturnNode(method);
            this.out(this.getCType(returnNode));
            this.out(";id;SEL;");
            NodeList params = method.getChildNodes();
            int k = 0;
            while (k < params.getLength()) {
                param = params.item(k);
                if ("arg".equals(param.getNodeName())) {
                    this.out(this.getCType(param));
                    this.out(";");
                }
                ++k;
            }
            this.out(",callback_flags=");
            this.out(this.isStruct(returnNode) ? "struct" : "none");
            this.out(";none;none;");
            k = 0;
            while (k < params.getLength()) {
                param = params.item(k);
                if ("arg".equals(param.getNodeName())) {
                    this.out(this.isStruct(param) ? "struct" : "none");
                    this.out(";");
                }
                ++k;
            }
            this.out(" */");
            this.outln();
            this.out("public static final native long CALLBACK_");
            this.out(nativeMth);
            this.out("(long func);");
            this.outln();
        }
    }

    void generateSends(boolean superCall) {
        TreeMap<String, Node> set = new TreeMap<String, Node>();
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if ("class".equals(node.getNodeName()) && this.getGen(node)) {
                        NodeList methods = node.getChildNodes();
                        int j = 0;
                        while (j < methods.getLength()) {
                            String code;
                            Node method = methods.item(j);
                            if ("method".equals(method.getNodeName()) && this.getGen(method) && (!superCall || this.getGenSuper(method)) && set.get(code = this.buildSend(method, superCall)) == null) {
                                set.put(code, method);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            ++x;
        }
        this.outln();
        for (String key : set.keySet()) {
            Node method = (Node)set.get(key);
            NodeList params = method.getChildNodes();
            ArrayList<String> tags = new ArrayList<String>();
            int count = 0;
            int k = 0;
            while (k < params.getLength()) {
                Node param = params.item(k);
                if ("arg".equals(param.getNodeName())) {
                    if (this.isStruct(param)) {
                        tags.add(" * @param arg" + count + " flags=struct");
                    }
                    ++count;
                }
                ++k;
            }
            this.out("/**");
            if (tags.size() > 0) {
                this.outln();
                this.out(" *");
            }
            this.out(" @method flags=cast");
            if (tags.size() > 0) {
                this.outln();
            }
            for (String tag : tags) {
                this.out(tag);
                this.outln();
            }
            this.out(" */");
            this.outln();
            this.out(key.toString());
            this.outln();
        }
    }

    String getSelConst(String sel) {
        return "sel_" + sel.replaceAll(":", "_");
    }

    void generateClassesConst() {
        TreeSet<String> set = new TreeSet<String>();
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if ("class".equals(node.getNodeName()) && this.getGen(node)) {
                        NamedNodeMap attributes = node.getAttributes();
                        String name = attributes.getNamedItem("name").getNodeValue();
                        set.add(name);
                    }
                    ++i;
                }
            }
            ++x;
        }
        for (String cls : set) {
            String clsConst = "class_" + cls;
            this.out("public static final long ");
            this.out(clsConst);
            this.out(" = ");
            this.out("objc_getClass(\"");
            this.out(cls);
            this.out("\");");
            this.outln();
        }
    }

    void generateProtocolsConst() {
        TreeSet<String> set = new TreeSet<String>();
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if ("informal_protocol".equals(node.getNodeName()) && this.getGen(node)) {
                        NamedNodeMap attributes = node.getAttributes();
                        String name = attributes.getNamedItem("name").getNodeValue();
                        set.add(name);
                    }
                    ++i;
                }
            }
            ++x;
        }
        for (String cls : set) {
            String clsConst = "protocol_" + cls;
            this.out("public static final long ");
            this.out(clsConst);
            this.out(" = ");
            this.out("objc_getProtocol(\"");
            this.out(cls);
            this.out("\");");
            this.outln();
        }
    }

    String getPackageName() {
        int dot = this.mainClassName.lastIndexOf(46);
        if (dot == -1) {
            return "";
        }
        return this.mainClassName.substring(0, dot);
    }

    String getClassName() {
        int dot = this.mainClassName.lastIndexOf(46);
        if (dot == -1) {
            return this.mainClassName;
        }
        return this.mainClassName.substring(dot + 1);
    }

    Node getReturnNode(Node method) {
        NodeList list = method.getChildNodes();
        int j = 0;
        while (j < list.getLength()) {
            Node node = list.item(j);
            if ("retval".equals(node.getNodeName())) {
                return node;
            }
            ++j;
        }
        return method;
    }

    String getType(Node node) {
        return this.getType(node, false);
    }

    String getJavaType(Node node) {
        return this.getType(node, true);
    }

    char getTypeCode(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node type = attributes.getNamedItem("type64");
        if (type == null) {
            type = attributes.getNamedItem("type");
        }
        if (type == null) {
            return '?';
        }
        String code = type.getNodeValue();
        if (code.startsWith("V")) {
            code = code.substring(1);
        }
        if (code.isEmpty()) {
            return '?';
        }
        return code.charAt(0);
    }

    private String toDebugLocation(Node location) {
        StringBuilder result = new StringBuilder();
        while (location != null) {
            if (result.length() > 0) {
                result.insert(0, " > ");
            }
            result.insert(0, this.getNodeInfo(location));
            location = location.getParentNode();
        }
        return result.toString();
    }

    private String getNodeInfo(Node location) {
        String name = location.getNodeName();
        if (name != null) {
            NamedNodeMap attributes = location.getAttributes();
            if (attributes != null) {
                StringBuilder info = new StringBuilder();
                info.append(name).append("[");
                int i = 0;
                while (i < attributes.getLength()) {
                    Node attribute = attributes.item(i);
                    if (i > 0) {
                        info.append(", ");
                    }
                    info.append(attribute.getNodeName()).append("=").append(attribute.getNodeValue());
                    ++i;
                }
                return info.append("]").toString();
            }
            return name;
        }
        return location.toString();
    }

    String getType(Node node, boolean withObjects) {
        char typeCode = this.getTypeCode(node);
        if (typeCode == '@' && !withObjects) {
            return "long";
        }
        NamedNodeMap attributes = node.getAttributes();
        Node javaType = attributes.getNamedItem("swt_java_type64");
        if (javaType == null) {
            javaType = attributes.getNamedItem("swt_java_type");
        }
        if (javaType != null) {
            return javaType.getNodeValue();
        }
        switch (typeCode) {
            case 'v': {
                return "void";
            }
            case 'B': {
                return "boolean";
            }
            case 'c': {
                return "byte";
            }
            case 'C': {
                return "byte";
            }
            case 's': {
                return "short";
            }
            case 'S': {
                return "short";
            }
            case 'i': {
                return "int";
            }
            case 'I': {
                return "int";
            }
            case 'l': {
                return "int";
            }
            case 'L': {
                return "int";
            }
            case 'q': {
                return "long";
            }
            case 'Q': {
                return "long";
            }
            case 'f': {
                return "float";
            }
            case 'd': {
                return "double";
            }
            case '*': {
                return "long";
            }
            case '#': {
                return "long";
            }
            case ':': {
                return "long";
            }
            case '^': {
                return "long";
            }
            case '{': {
                return this.getDeclaredType(attributes, node);
            }
            case '@': {
                String type = this.getDeclaredType(attributes, node);
                int index = type.indexOf(42);
                if (index != -1) {
                    type = type.substring(0, index);
                }
                if ((index = type.indexOf(60)) != -1) {
                    type = type.substring(0, index);
                }
                return this.knownConstTypes.contains(type = type.trim()) ? "NSString" : type;
            }
        }
        return "notype";
    }

    void generateFunctions() {
        int x = 0;
        while (x < this.xmls.length) {
            Document document = this.documents[x];
            if (document != null) {
                NodeList list = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node node = list.item(i);
                    if ("function".equals(node.getNodeName()) && this.getGen(node)) {
                        NamedNodeMap attributes = node.getAttributes();
                        String name = attributes.getNamedItem("name").getNodeValue();
                        NodeList params = node.getChildNodes();
                        int count = 0;
                        int j = 0;
                        while (j < params.getLength()) {
                            Node param = params.item(j);
                            if ("arg".equals(param.getNodeName())) {
                                ++count;
                            }
                            ++j;
                        }
                        if (count > 0) {
                            this.out("/**");
                            this.outln();
                        }
                        int argIndex = 0;
                        int j2 = 0;
                        while (j2 < params.getLength()) {
                            Node param = params.item(j2);
                            if ("arg".equals(param.getNodeName())) {
                                this.out(" * @param ");
                                this.out(this.getParamName(param, argIndex++));
                                if (this.isStruct(param)) {
                                    this.out(" flags=struct");
                                } else {
                                    String cast;
                                    this.out(" cast=");
                                    NamedNodeMap paramAttributes = param.getAttributes();
                                    Node swtCast = paramAttributes.getNamedItem("swt_param_cast");
                                    String string = cast = swtCast != null ? swtCast.getNodeValue() : this.getDeclaredType(paramAttributes, param);
                                    if (!cast.startsWith("(")) {
                                        this.out("(");
                                    }
                                    this.out(cast);
                                    if (!cast.endsWith(")")) {
                                        this.out(")");
                                    }
                                }
                                this.outln();
                            }
                            ++j2;
                        }
                        if (count > 0) {
                            this.out(" */");
                            this.outln();
                        }
                        this.out("public static final native ");
                        Node returnNode = this.getReturnNode(node);
                        this.out(this.getType(returnNode));
                        this.out(" ");
                        this.out(name);
                        this.out("(");
                        params = node.getChildNodes();
                        boolean first = true;
                        argIndex = 0;
                        int j3 = 0;
                        while (j3 < params.getLength()) {
                            Node param = params.item(j3);
                            if ("arg".equals(param.getNodeName())) {
                                if (!first) {
                                    this.out(", ");
                                }
                                first = false;
                                this.out(this.getType(param));
                                this.out(" ");
                                this.out(this.getParamName(param, argIndex++));
                            }
                            ++j3;
                        }
                        this.generateVariadics(node);
                        this.out(");");
                        this.outln();
                    }
                    ++i;
                }
            }
            ++x;
        }
    }

    void generateVariadics(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node variadicCount = attributes.getNamedItem("swt_variadic_count");
        if (variadicCount != null) {
            Node variadicTypes = attributes.getNamedItem("swt_variadic_java_types");
            String[] types = null;
            if (variadicTypes != null) {
                types = variadicTypes.getNodeValue().split(",");
            }
            int varCount = 0;
            try {
                varCount = Integer.parseInt(variadicCount.getNodeValue());
            }
            catch (NumberFormatException numberFormatException) {}
            int j = 0;
            while (j < varCount) {
                this.out(", ");
                if (types != null && types.length > j && !types[j].equals("*")) {
                    this.out(types[j]);
                } else if (types != null && types[types.length - 1].equals("*")) {
                    this.out(types[types.length - 2]);
                } else {
                    this.out("long");
                }
                this.out(" varArg");
                this.out("" + j);
                ++j;
            }
        }
    }

    public static void main(String[] args) {
        try {
            MacGenerator gen = new MacGenerator();
            gen.setXmls(args);
            gen.setOutputDir("../org.eclipse.swt/Eclipse SWT PI/cocoa/");
            gen.setMainClass("org.eclipse.swt.internal.cocoa.OS");
            gen.setSelectorEnum("org.eclipse.swt.internal.cocoa.Selector");
            gen.generate(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

