/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageEntryModel;
import org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.KernelCpuUsageAnalysis;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.cpuusage.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectedCpuQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CpuUsageDataProvider
extends AbstractTreeCommonXDataProvider<KernelCpuUsageAnalysis, CpuUsageEntryModel> {
    private static final Format TIME_FORMATTER = SubSecondTimeWithUnitFormat.getInstance();
    public static final String TOTAL = "total:";
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.core.cpuusage.CpuUsageDataProvider";
    public static final String REQUESTED_CPUS_KEY = "requested_cpus";
    public static final int TOTAL_SERIES_TID = -2;
    private final Map<Integer, String> fProcessNameMap = new HashMap<Integer, String>();
    private final KernelAnalysisModule fKernelAnalysisModule;

    public static @Nullable CpuUsageDataProvider create(ITmfTrace trace) {
        KernelCpuUsageAnalysis module = (KernelCpuUsageAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelCpuUsageAnalysis.class, (String)"org.eclipse.tracecompass.analysis.os.linux.cpuusage");
        KernelAnalysisModule kernelAnalysisModule = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (module != null && kernelAnalysisModule != null) {
            module.schedule();
            kernelAnalysisModule.schedule();
            return new CpuUsageDataProvider(trace, module, kernelAnalysisModule);
        }
        return null;
    }

    private CpuUsageDataProvider(ITmfTrace trace, KernelCpuUsageAnalysis module, KernelAnalysisModule kernelAnalysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)module);
        this.fKernelAnalysisModule = kernelAnalysisModule;
    }

    @Deprecated
    protected @Nullable Map<String, IYModel> getYModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        return Maps.uniqueIndex(this.getYSeriesModels(ss, fetchParameters, monitor), IYModel::getName);
    }

    protected @Nullable Collection<IYModel> getYSeriesModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Set cpus = Collections.emptySet();
        SelectedCpuQueryFilter filter = CpuUsageDataProvider.createCpuQuery(fetchParameters);
        if (filter == null && (filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters)) == null) {
            return null;
        }
        if (filter instanceof SelectedCpuQueryFilter) {
            cpus = filter.getSelectedCpus();
        }
        long[] xValues = filter.getTimesRequested();
        double[] totalValues = new double[xValues.length];
        HashMap<String, YModel> selectedThreadValues = new HashMap<String, YModel>();
        for (Map.Entry entry : this.getSelectedEntries((SelectionTimeQueryFilter)filter).entrySet()) {
            String name = Integer.toString((Integer)entry.getValue());
            selectedThreadValues.put(name, new YModel(((Long)entry.getKey()).longValue(), String.valueOf(this.getTrace().getName()) + ':' + name, new double[xValues.length]));
        }
        long prevTime = Math.max(filter.getStart(), ss.getStartTime());
        long currentEnd = ss.getCurrentEndTime();
        int i = 1;
        while (i < xValues.length) {
            long time = xValues[i];
            if (time >= ss.getStartTime() && time <= currentEnd && prevTime < time) {
                Map cpuUsageMap = Maps.filterKeys(((KernelCpuUsageAnalysis)this.getAnalysisModule()).getCpuUsageInRange(cpus, prevTime, time), key -> key.startsWith("total"));
                long totalCpu = 0L;
                for (Map.Entry entry : cpuUsageMap.entrySet()) {
                    String threadName = CpuUsageDataProvider.extractThreadName((String)entry.getKey());
                    if (threadName == null) continue;
                    long cpuTime = (Long)entry.getValue();
                    totalCpu += cpuTime;
                    IYModel values = (IYModel)selectedThreadValues.get(threadName);
                    if (values == null) continue;
                    values.getData()[i] = CpuUsageDataProvider.normalize(prevTime, time, cpuTime);
                }
                totalValues[i] = CpuUsageDataProvider.normalize(prevTime, time, totalCpu);
                prevTime = time;
            }
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            ++i;
        }
        ImmutableList.Builder ySeries = ImmutableList.builder();
        String key2 = TOTAL + this.getTrace().getName();
        ySeries.add((Object)new YModel(this.getId(-1), key2, totalValues));
        for (IYModel entry : selectedThreadValues.values()) {
            ySeries.add((Object)entry);
        }
        return ySeries.build();
    }

    private static double normalize(long prevTime, long time, long value) {
        return (double)value / (double)(time - prevTime) * 100.0;
    }

    private static @Nullable String extractThreadName(String key) {
        String[] strings = key.split("/", 2);
        if (strings.length > 1 && !strings[1].equals("0")) {
            return strings[1];
        }
        return null;
    }

    protected TmfTreeModel<CpuUsageEntryModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(parameters);
        if (filter == null) {
            return new TmfTreeModel(Collections.emptyList(), Collections.emptyList());
        }
        long end = filter.getEnd();
        ArrayList<CpuUsageEntryModel> entryList = new ArrayList<CpuUsageEntryModel>();
        Set<Integer> cpus = CpuUsageDataProvider.extractCpuSet(parameters);
        Map<String, Long> cpuUsageMap = ((KernelCpuUsageAnalysis)this.getAnalysisModule()).getCpuUsageInRange(cpus, filter.getStart(), end);
        double timeRange = end - filter.getStart();
        long totalTime = cpuUsageMap.getOrDefault("total", 0L);
        long totalId = this.getId(-1);
        entryList.add(new CpuUsageEntryModel(totalId, -1L, (List<String>)ImmutableList.of((Object)this.getTrace().getName(), (Object)String.valueOf(Messages.CpuUsageDataProvider_Total), (Object)String.format(Messages.CpuUsageDataProvider_TextPercent, timeRange > 0.0 ? (double)(100L * totalTime) / timeRange : 0.0), (Object)TIME_FORMATTER.format(totalTime)), -2, totalTime));
        for (Map.Entry<String, Long> entry : cpuUsageMap.entrySet()) {
            String[] strings;
            String key = entry.getKey();
            if (entry.getValue() == 0L || !key.startsWith("total") || (strings = key.split("/", 2)).length <= 1) continue;
            int tid = Integer.parseInt(strings[1]);
            Long time = entry.getValue();
            if (tid == 0) continue;
            entryList.add(new CpuUsageEntryModel(this.getId(tid), totalId, (List<String>)ImmutableList.of((Object)this.getProcessName(tid, strings[1], end), (Object)String.valueOf(tid), (Object)String.format(Messages.CpuUsageDataProvider_TextPercent, timeRange > 0.0 ? (double)(100L * time) / timeRange : 0.0), (Object)TIME_FORMATTER.format(time)), tid, (long)time));
        }
        return new TmfTreeModel((List)ImmutableList.of((Object)String.valueOf(Messages.CpuUsageDataProvider_ColumnProcess), (Object)OsStrings.tid(), (Object)String.valueOf(Messages.CpuUsageDataProvider_ColumnPercent), (Object)String.valueOf(Messages.CpuUsageDataProvider_ColumnTime)), entryList);
    }

    private String getProcessName(int tid, String defaultTidName, long endTime) {
        String execName = this.fProcessNameMap.get(tid);
        if (execName != null) {
            return execName;
        }
        execName = KernelThreadInformationProvider.getExecutableName(this.fKernelAnalysisModule, tid, endTime);
        ITmfStateSystem ss = this.fKernelAnalysisModule.getStateSystem();
        if (ss != null && ss.waitUntilBuilt(0L) && execName != null) {
            this.fProcessNameMap.put(tid, execName);
            return execName;
        }
        return defaultTidName;
    }

    private static @Nullable SelectedCpuQueryFilter createCpuQuery(Map<String, Object> parameters) {
        List timeRequested = DataProviderParameterUtils.extractTimeRequested(parameters);
        List selectedItems = DataProviderParameterUtils.extractSelectedItems(parameters);
        Set<Integer> cpus = CpuUsageDataProvider.extractCpuSet(parameters);
        if (timeRequested == null || selectedItems == null) {
            return null;
        }
        return new SelectedCpuQueryFilter(timeRequested, (Collection)selectedItems, cpus);
    }

    private static Set<Integer> extractCpuSet(Map<String, Object> parameters) {
        Object cpus = parameters.get(REQUESTED_CPUS_KEY);
        if (cpus instanceof Collection) {
            return ((Collection)cpus).stream().filter(cpu -> cpu instanceof Integer).map(cpu -> (Integer)cpu).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return false;
    }

    protected String getTitle() {
        return Objects.requireNonNull(Messages.CpuUsageDataProvider_title);
    }
}

