/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.nonvisual;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanInfo;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;

final class JavadocNonVisualBeanInfo
extends NonVisualBeanInfo {
    private static final String NON_VISUAL_TAG = "@wbp.nonvisual";
    private static final String LOCATION_PREFIX = "location=";
    private final BodyDeclaration m_bodyDeclaration;

    JavadocNonVisualBeanInfo(BodyDeclaration bodyDeclaration) {
        this.m_location = new Point();
        this.m_bodyDeclaration = bodyDeclaration;
    }

    private JavadocNonVisualBeanInfo(BodyDeclaration bodyDeclaration, Point location) {
        this(bodyDeclaration);
        this.m_location.setLocation(location);
    }

    static NonVisualBeanInfo getNonVisualBeanInfo(BodyDeclaration bodyDeclaration) {
        Javadoc javadoc = bodyDeclaration.getJavadoc();
        if (javadoc != null) {
            for (TagElement tagElement : DomGenerics.tags(javadoc)) {
                if (!NON_VISUAL_TAG.equals(tagElement.getTagName())) continue;
                List<ASTNode> fragments = DomGenerics.fragments(tagElement);
                Assert.isTrueException((!fragments.isEmpty() ? 1 : 0) != 0, (int)104, (Object[])new Object[]{tagElement});
                ASTNode fragment = fragments.get(0);
                Assert.isTrueException((boolean)(fragment instanceof TextElement), (int)104, (Object[])new Object[]{tagElement});
                TextElement textElement = (TextElement)fragment;
                String text = textElement.getText().trim();
                Assert.isTrueException((boolean)text.startsWith(LOCATION_PREFIX), (int)104, (Object[])new Object[]{tagElement});
                String[] locationParts = StringUtils.split((String)text.substring(LOCATION_PREFIX.length()), (char)',');
                Assert.isTrueException((locationParts.length == 2 ? 1 : 0) != 0, (int)104, (Object[])new Object[]{tagElement});
                Point location = new Point();
                try {
                    location.x = Integer.parseInt(locationParts[0].trim());
                    location.y = Integer.parseInt(locationParts[1].trim());
                }
                catch (NumberFormatException e) {
                    Assert.isTrueException((boolean)false, (int)104, (Object[])new Object[]{tagElement});
                }
                return new JavadocNonVisualBeanInfo(bodyDeclaration, location);
            }
        }
        return null;
    }

    @Override
    public void moveLocation(Point moveDelta) throws Exception {
        this.m_location.translate(moveDelta);
        this.m_javaInfo.getEditor().setJavadocTagText(this.m_bodyDeclaration, NON_VISUAL_TAG, " location=" + Integer.toString(this.m_location.x) + "," + Integer.toString(this.m_location.y));
    }

    @Override
    public void remove() throws Exception {
        this.m_javaInfo.getEditor().setJavadocTagText(this.m_bodyDeclaration, NON_VISUAL_TAG, null);
        super.remove();
    }
}

