/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.os.win32;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.os.OSSupport;

public abstract class OSSupportWin32<H extends Number>
extends OSSupport {
    protected static final OSSupport INSTANCE;

    static {
        System.loadLibrary("wbp");
        INSTANCE = EnvironmentUtils.IS_64BIT_OS ? new Impl64() : new Impl32();
    }

    public final void makeShots(Object controlObject) throws Exception {
        Control control = (Control)controlObject;
        try {
            OSSupportWin32.reverseDrawingOrder(control);
            this.makeShotsHierarchy(control);
        }
        finally {
            OSSupportWin32.reverseDrawingOrder(control);
        }
    }

    private static void reverseDrawingOrder(Control control) {
    }

    private void makeShotsHierarchy(Control control) throws Exception {
        if (control.getData("WBP_NEED_IMAGE") != null) {
            Point size = control.getSize();
            if (size.x == 0 || size.y == 0) {
                return;
            }
            control.setData("WBP_IMAGE", (Object)this.makeShot(control));
            if (control instanceof Composite) {
                Composite composite = (Composite)control;
                Control[] controlArray = composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    this.makeShotsHierarchy(child);
                    ++n2;
                }
            }
        }
    }

    public final Image makeShot(Control control) throws Exception {
        Rectangle bounds = control.getBounds();
        if (bounds.width == 0 || bounds.height == 0) {
            return null;
        }
        Image image = new Image((Device)Display.getCurrent(), bounds.width, bounds.height);
        GC gc = new GC((Drawable)image);
        try {
            this.makeShotImpl(control, gc);
        }
        finally {
            gc.dispose();
        }
        return image;
    }

    protected void makeShotImpl(Control control, GC gc) {
        OSSupportWin32._makeShot(this.getHandleField(control), this.getHandleField(gc));
    }

    public final Rectangle getTabItemBounds(Object tabItemObject) {
        TabFolder tabFolder = ((TabItem)tabItemObject).getParent();
        int index = ArrayUtils.indexOf((Object[])tabFolder.getItems(), (Object)tabItemObject);
        int[] bounds = new int[4];
        this.getTabItemBounds(tabFolder, index, bounds);
        int borderOffset = (tabFolder.getStyle() & 0x800) != 0 ? 2 : 0;
        int x = bounds[0] + borderOffset;
        int y = bounds[2] + borderOffset;
        int width = bounds[1] - bounds[0];
        int height = bounds[3] - bounds[2];
        return new Rectangle(x, y, width, height);
    }

    private void getTabItemBounds(TabFolder tabFolder, int index, int[] bounds) {
        OSSupportWin32._getTabItemBounds(this.getHandleField(tabFolder), index, bounds);
    }

    public final Rectangle getMenuBarBounds(Menu menu) {
        int[] bounds;
        Decorations shell = this.getMenuParent(menu);
        if (this.getMenuBarOrItemBounds(shell, 0, bounds = new int[4])) {
            int width = bounds[1] - bounds[0];
            int height = bounds[3] - bounds[2];
            Point shellLocation = shell.getLocation();
            return new Rectangle(bounds[0] - shellLocation.x, bounds[2] - shellLocation.y, width, height);
        }
        throw new RuntimeException("OS function call failed.");
    }

    public Image getMenuBarVisualData(Menu menu, List<Rectangle> dimensions) {
        int[] offsetBounds;
        Decorations shell = this.getMenuParent(menu);
        if (!this.getMenuBarOrItemBounds(shell, 1, offsetBounds = new int[4])) {
            throw new RuntimeException("OS function call failed.");
        }
        int index = 0;
        while (index < menu.getItemCount()) {
            int[] bounds = new int[4];
            if (!this.getMenuBarOrItemBounds(shell, index + 1, bounds)) {
                throw new IllegalStateException("OS function call failed.");
            }
            int x = bounds[0] - offsetBounds[0];
            int y = bounds[2] - offsetBounds[2];
            int width = bounds[1] - bounds[0];
            int height = bounds[3] - bounds[2];
            dimensions.add(new Rectangle(x, y, width, height));
            ++index;
        }
        return null;
    }

    private Decorations getMenuParent(Menu menu) {
        Decorations shell = menu.getParent();
        if (shell.getMenuBar() != menu) {
            throw new IllegalArgumentException("Invalid menu parent.");
        }
        return shell;
    }

    private boolean getMenuBarOrItemBounds(Decorations shell, int index, int[] bounds) {
        return OSSupportWin32._getMenuBarOrItemBounds(this.getHandleField(shell), index, bounds);
    }

    public Image getMenuPopupVisualData(Menu menu, int[] bounds) throws Exception {
        Image image = new Image((Device)Display.getCurrent(), 1, 1);
        OSSupportWin32._DeleteObject(this.getHandleField(image));
        H handle = OSSupportWin32._fetchPopupMenuVisualData(this.getHandleField(menu.getShell()), this.getHandleField(menu), bounds);
        ReflectionUtils.setField((Object)image, (String)"handle", handle);
        return image;
    }

    public int getDefaultMenuBarHeight() {
        return OSSupportWin32._getDefaultMenuBarHeight();
    }

    public void setAlpha(Shell shell, int alpha) {
        OSSupportWin32._setAlpha(this.getHandleField(shell), alpha);
    }

    public int getAlpha(Shell shell) {
        return OSSupportWin32._getAlpha(this.getHandleField(shell));
    }

    public boolean isPlusMinusTreeClick(Tree tree, int x, int y) {
        return OSSupportWin32._isPlusMinusTreeClick(this.getHandleField(tree), x, y);
    }

    public void scroll(Control cursorControl, int count) {
        OSSupportWin32._scroll(this.getHandleField(cursorControl), count);
    }

    protected abstract H getHandleField(Object var1);

    private static native <H extends Number> boolean _getMenuBarOrItemBounds(H var0, int var1, int[] var2);

    private static native <H extends Number> H _fetchPopupMenuVisualData(H var0, H var1, int[] var2);

    private static native int _getDefaultMenuBarHeight();

    private static native <H extends Number> void _scroll(H var0, int var1);

    private static native <H extends Number> void _makeShot(H var0, H var1);

    private static native <H extends Number> boolean _isPlusMinusTreeClick(H var0, int var1, int var2);

    private static native <H extends Number> void _setAlpha(H var0, int var1);

    private static native <H extends Number> int _getAlpha(H var0);

    private static native <H extends Number> void _getTabItemBounds(H var0, int var1, int[] var2);

    private static native <H extends Number> void _DeleteObject(H var0);

    private static final class Impl32
    extends OSSupportWin32<Integer> {
        private Impl32() {
        }

        @Override
        protected Integer getHandleField(Object object) {
            return ReflectionUtils.getFieldInt((Object)object, (String)"handle");
        }
    }

    private static final class Impl64
    extends OSSupportWin32<Long> {
        private Impl64() {
        }

        @Override
        protected Long getHandleField(Object object) {
            return ReflectionUtils.getFieldLong((Object)object, (String)"handle");
        }
    }
}

