/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.font;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.property.editor.font.AbstractFontPage;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontDialog;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontInfo;
import org.eclipse.wb.internal.swt.support.FontSupport;
import org.eclipse.wb.internal.swt.support.JFaceSupport;

public final class JFaceFontPage
extends AbstractFontPage {
    public static final String NAME = "JFace";
    private final Table m_fontTable;
    private final List<FontInfo> m_fonts;

    public JFaceFontPage(Composite parent, int style, FontDialog fontDialog, JavaInfo javaInfo) {
        super(parent, style, fontDialog);
        List<FontInfo> fonts;
        GridLayoutFactory.create((Composite)this);
        new Label((Composite)this, 0).setText(ModelMessages.JFaceFontPage_selectFont);
        this.m_fontTable = new Table((Composite)this, 67584);
        GridDataFactory.create((Control)this.m_fontTable).hintVC(15).grab().fill();
        this.m_fontTable.setHeaderVisible(true);
        this.m_fontTable.setLinesVisible(true);
        new TableColumn(this.m_fontTable, 0).setText(ModelMessages.JFaceFontPage_nameColumn);
        new TableColumn(this.m_fontTable, 0).setText(ModelMessages.JFaceFontPage_valueColumn);
        try {
            fonts = JFaceSupport.getJFaceFonts();
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
            fonts = Collections.emptyList();
        }
        this.m_fonts = fonts;
        for (FontInfo fontInfo : this.m_fonts) {
            TableItem tableItem = new TableItem(this.m_fontTable, 0);
            tableItem.setText(0, fontInfo.getName());
            try {
                Object fontData = FontSupport.getFontData(fontInfo.getFont());
                tableItem.setText(1, FontSupport.getFontName(fontData) + " " + FontSupport.getFontSize(fontData));
            }
            catch (Throwable e) {
                tableItem.setText(1, "???");
            }
        }
        int i = 0;
        while (i < this.m_fontTable.getColumnCount()) {
            this.m_fontTable.getColumn(i).pack();
            ++i;
        }
        this.m_fontTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FontInfo fontInfo = (FontInfo)JFaceFontPage.this.m_fonts.get(JFaceFontPage.this.m_fontTable.getSelectionIndex());
                JFaceFontPage.this.m_fontDialog.setFontInfo(fontInfo);
            }
        });
        this.m_fontTable.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                JFaceFontPage.this.m_fontDialog.closeOk();
            }
        });
    }

    @Override
    public void setFont(FontInfo fontInfo) {
    }
}

