/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.widgets.menu;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.AssociationObject;
import org.eclipse.wb.core.model.association.AssociationObjects;
import org.eclipse.wb.core.model.broadcast.DisplayEventListener;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildrenGraphical;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.generation.GenerationUtils;
import org.eclipse.wb.internal.core.model.generation.statement.StatementGenerator;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuItemInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;
import org.eclipse.wb.internal.core.model.menu.IMenuPopupInfo;
import org.eclipse.wb.internal.core.model.menu.JavaMenuMenuObject;
import org.eclipse.wb.internal.core.model.menu.MenuObjectInfoUtils;
import org.eclipse.wb.internal.core.model.menu.MenuVisualData;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.model.variable.EmptyPureVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.IAdaptable;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.swt.model.widgets.WidgetInfo;
import org.eclipse.wb.internal.swt.model.widgets.live.SwtLiveManager;
import org.eclipse.wb.internal.swt.model.widgets.live.menu.MenuLiveManager;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuItemInfo;
import org.eclipse.wb.internal.swt.model.widgets.menu.MenuStylePresentation;
import org.eclipse.wb.internal.swt.support.MenuSupport;
import org.eclipse.wb.internal.swt.support.ToolkitSupport;

public final class MenuInfo
extends WidgetInfo
implements IAdaptable {
    private final MenuInfo m_this = this;
    private final IObjectPresentation m_presentation = new MenuStylePresentation(this);
    private final IMenuPopupInfo m_popupImpl = new MenuPopupImpl();
    private final IMenuInfo m_menuImpl = new MenuImpl();

    public MenuInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.putPopupAboveOtherChildren();
        this.addClipboardSupport();
    }

    private void putPopupAboveOtherChildren() {
        this.addBroadcastListener(new ObjectInfoChildrenGraphical(){

            public void invoke(List<ObjectInfo> children) throws Exception {
                if (children.remove((Object)MenuInfo.this.m_this)) {
                    children.add(0, (ObjectInfo)MenuInfo.this.m_this);
                }
            }
        });
    }

    private void addClipboardSupport() {
        this.addBroadcastListener(new JavaEventListener(){

            public void clipboardCopy_Argument(JavaInfo javaInfo, ParameterDescription parameter, Expression argument, String[] source) throws Exception {
                if (javaInfo == MenuInfo.this.m_this && parameter.getIndex() == 0) {
                    source[0] = "%parent%";
                }
            }

            public void clipboardCopy(JavaInfo javaInfo, List<ClipboardCommand> commands) throws Exception {
                if (javaInfo == MenuInfo.this.m_this) {
                    for (MenuItemInfo item : MenuInfo.this.getChildrenItems()) {
                        final JavaInfoMemento itemMemento = JavaInfoMemento.createMemento((JavaInfo)item);
                        commands.add(new ClipboardCommand(){
                            private static final long serialVersionUID = 0L;

                            public void execute(JavaInfo javaInfo) throws Exception {
                                MenuItemInfo item = (MenuItemInfo)itemMemento.create(javaInfo);
                                IMenuPolicy policy = MenuObjectInfoUtils.getMenuInfo((Object)javaInfo).getPolicy();
                                policy.commandCreate((Object)item, null);
                                itemMemento.apply();
                            }
                        });
                    }
                }
            }
        });
    }

    protected void refresh_afterCreate() throws Exception {
        Object[] items = MenuSupport.getItems(this.getObject());
        if (items.length == 0) {
            MenuSupport.addPlaceholder(this.getObject());
        }
        super.refresh_afterCreate();
    }

    protected void refresh_fetch() throws Exception {
        DisplayEventListener displayListener = (DisplayEventListener)this.getBroadcast(DisplayEventListener.class);
        MenuVisualData visualData = null;
        try {
            displayListener.beforeMessagesLoop();
            visualData = ToolkitSupport.fetchMenuVisualData(this.getObject());
        }
        finally {
            displayListener.afterMessagesLoop();
        }
        this.setModelBounds(visualData.m_menuBounds);
        this.setBounds(visualData.m_menuBounds);
        this.setImage(visualData.m_menuImage);
        List<MenuItemInfo> items = this.getChildrenItems();
        int i = 0;
        while (i < items.size()) {
            MenuItemInfo itemInfo = items.get(i);
            itemInfo.setModelBounds((Rectangle)visualData.m_itemBounds.get(i));
            ++i;
        }
        super.refresh_fetch();
    }

    @Override
    protected SwtLiveManager getLiveComponentsManager() {
        return new MenuLiveManager(this);
    }

    public List<MenuItemInfo> getChildrenItems() {
        return this.getChildren(MenuItemInfo.class);
    }

    public boolean isBar() {
        return (this.getStyle() & 2) != 0;
    }

    public boolean isPopup() {
        return (this.getStyle() & 8) != 0;
    }

    public IObjectPresentation getPresentation() {
        return this.m_presentation;
    }

    public void command_CREATE(WidgetInfo parent) throws Exception {
        JavaInfoUtils.add((JavaInfo)this, (AssociationObject)this.command_getAssociation(), (JavaInfo)parent, null);
    }

    public void command_ADD(WidgetInfo parent) throws Exception {
        JavaInfoUtils.move((JavaInfo)this, (AssociationObject)this.command_getAssociation(), (JavaInfo)parent, null);
        this.replaceParentReferenceInCreation(parent);
    }

    private void replaceParentReferenceInCreation(WidgetInfo parent) throws Exception {
        if (this.getCreationSupport() instanceof ConstructorCreationSupport) {
            ConstructorCreationSupport creationSupport = (ConstructorCreationSupport)this.getCreationSupport();
            ClassInstanceCreation creation = creationSupport.getCreation();
            NodeTarget target = JavaInfoUtils.getNodeTarget_afterCreation((JavaInfo)this);
            String parentReference = parent.getVariableSupport().getReferenceExpression(target);
            this.getEditor().replaceCreationArguments(creation, (List)Lists.newArrayList((Object[])new String[]{parentReference}));
        }
    }

    private AssociationObject command_getAssociation() throws Exception {
        if (this.isBar()) {
            return AssociationObjects.invocationChild((String)"%parent%.setMenuBar(%child%)", (boolean)true);
        }
        return AssociationObjects.invocationChild((String)"%parent%.setMenu(%child%)", (boolean)true);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(IMenuInfo.class)) {
            return adapter.cast(this.m_menuImpl);
        }
        if (adapter.isAssignableFrom(IMenuPopupInfo.class)) {
            return adapter.cast(this.m_popupImpl);
        }
        return null;
    }

    private abstract class MenuAbstractImpl
    extends JavaMenuMenuObject {
        public MenuAbstractImpl() {
            super((JavaInfo)MenuInfo.this.m_this);
        }
    }

    private final class MenuImpl
    extends MenuAbstractImpl
    implements IMenuInfo,
    IMenuPolicy {
        private MenuImpl() {
        }

        public Object getModel() {
            return MenuInfo.this.isPopup() ? this : MenuInfo.this.m_this;
        }

        public Image getImage() {
            return MenuInfo.this.m_this.getImage();
        }

        public Rectangle getBounds() {
            return MenuInfo.this.m_this.getBounds();
        }

        public boolean isHorizontal() {
            return MenuInfo.this.isBar();
        }

        public List<IMenuItemInfo> getItems() {
            ArrayList items = Lists.newArrayList();
            for (MenuItemInfo item : MenuInfo.this.getChildrenItems()) {
                items.add(MenuObjectInfoUtils.getMenuItemInfo((Object)item));
            }
            return items;
        }

        public IMenuPolicy getPolicy() {
            return this;
        }

        public boolean validateCreate(Object newObject) {
            return newObject instanceof MenuItemInfo;
        }

        public boolean validatePaste(final Object mementoObject) {
            return (Boolean)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<Boolean>(){

                public Boolean runObject() throws Exception {
                    List mementos = (List)mementoObject;
                    for (JavaInfoMemento memento : mementos) {
                        JavaInfo component = memento.create((JavaInfo)MenuInfo.this.m_this);
                        if (component instanceof MenuItemInfo) continue;
                        return false;
                    }
                    return true;
                }
            }, (Object)false);
        }

        public boolean validateMove(Object object) {
            if (object instanceof MenuItemInfo) {
                MenuItemInfo item = (MenuItemInfo)object;
                return !item.isParentOf((ObjectInfo)MenuInfo.this.m_this);
            }
            return false;
        }

        public void commandCreate(Object newObject, Object nextObject) throws Exception {
            MenuItemInfo newItem = (MenuItemInfo)newObject;
            MenuItemInfo nextItem = (MenuItemInfo)nextObject;
            if ((newItem.getStyle() & 2) != 0) {
                EmptyPureVariableSupport variableSupport = new EmptyPureVariableSupport((JavaInfo)newItem);
                StatementGenerator statementGenerator = GenerationUtils.getStatementGenerator((JavaInfo)newItem);
                JavaInfoUtils.add((JavaInfo)newItem, (VariableSupport)variableSupport, (StatementGenerator)statementGenerator, null, (JavaInfo)MenuInfo.this.m_this, (JavaInfo)nextItem);
            } else {
                JavaInfoUtils.add((JavaInfo)newItem, null, (JavaInfo)MenuInfo.this.m_this, (JavaInfo)nextItem);
            }
            MenuObjectInfoUtils.setSelectingObject((Object)newItem);
        }

        public List<?> commandPaste(Object mementoObject, Object nextObject) throws Exception {
            ArrayList pastedObjects = Lists.newArrayList();
            List mementos = (List)mementoObject;
            for (JavaInfoMemento memento : mementos) {
                MenuItemInfo item = (MenuItemInfo)memento.create((JavaInfo)MenuInfo.this.m_this);
                this.commandCreate(item, nextObject);
                memento.apply();
                pastedObjects.add(item);
            }
            return pastedObjects;
        }

        public void commandMove(Object object, Object nextObject) throws Exception {
            MenuItemInfo item = (MenuItemInfo)object;
            MenuItemInfo nextItem = (MenuItemInfo)nextObject;
            JavaInfoUtils.move((JavaInfo)item, null, (JavaInfo)MenuInfo.this.m_this, (JavaInfo)nextItem);
            MenuObjectInfoUtils.setSelectingObject((Object)item);
        }
    }

    private final class MenuPopupImpl
    extends MenuAbstractImpl
    implements IMenuPopupInfo {
        private MenuPopupImpl() {
        }

        public Object getModel() {
            return MenuInfo.this.m_this;
        }

        public Image getImage() {
            return (Image)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<Image>(){

                public Image runObject() throws Exception {
                    return MenuInfo.this.getPresentation().getIcon();
                }
            }, (Object)MenuInfo.this.getDescription().getIcon());
        }

        public Rectangle getBounds() {
            Image image = this.getImage();
            return new Rectangle(0, 0, image.getBounds().width, image.getBounds().height);
        }

        public IMenuInfo getMenu() {
            return MenuInfo.this.m_menuImpl;
        }

        public IMenuPolicy getPolicy() {
            return IMenuPolicy.NOOP;
        }
    }
}

