"use strict";
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
__export(require("vscode-jsonrpc"));
__export(require("vscode-languageserver-types"));
__export(require("./messages"));
__export(require("./protocol"));
var connection_1 = require("./connection");
exports.createProtocolConnection = connection_1.createProtocolConnection;
const st = require("./protocol.semanticTokens.proposed");
var Proposed;
(function (Proposed) {
    Proposed.SemanticTokenTypes = st.SemanticTokenTypes;
    Proposed.SemanticTokenModifiers = st.SemanticTokenModifiers;
    Proposed.SemanticTokens = st.SemanticTokens;
    let SemanticTokensRequest;
    (function (SemanticTokensRequest) {
        SemanticTokensRequest.method = st.SemanticTokensRequest.method;
        SemanticTokensRequest.type = st.SemanticTokensRequest.type;
    })(SemanticTokensRequest = Proposed.SemanticTokensRequest || (Proposed.SemanticTokensRequest = {}));
    let SemanticTokensEditsRequest;
    (function (SemanticTokensEditsRequest) {
        SemanticTokensEditsRequest.method = st.SemanticTokensEditsRequest.method;
        SemanticTokensEditsRequest.type = st.SemanticTokensEditsRequest.type;
    })(SemanticTokensEditsRequest = Proposed.SemanticTokensEditsRequest || (Proposed.SemanticTokensEditsRequest = {}));
    let SemanticTokensRangeRequest;
    (function (SemanticTokensRangeRequest) {
        SemanticTokensRangeRequest.method = st.SemanticTokensRangeRequest.method;
        SemanticTokensRangeRequest.type = st.SemanticTokensRangeRequest.type;
    })(SemanticTokensRangeRequest = Proposed.SemanticTokensRangeRequest || (Proposed.SemanticTokensRangeRequest = {}));
})(Proposed = exports.Proposed || (exports.Proposed = {}));
//# sourceMappingURL=api.js.map