/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.chromium.DebugContext;
import org.eclipse.wst.jsdt.chromium.DebugEventListener;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.BreakpointSynchronizer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptThread;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptVmEmbedder;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.model.SourceWrapSupport;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResource;
import org.eclipse.wst.jsdt.chromium.debug.core.model.WorkspaceBridge;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.PositionMapBuilderImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMap;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.SourcePositionMapBuilder;

public class ConnectedTargetData {
    private final DebugTargetImpl debugTargetImpl;
    private final TargetInnerState debugTargetState = new TargetInnerState();
    private final JavascriptThread singleThread;
    private final JavascriptThread[] threadArray;
    private final SourcePositionMapBuilder sourcePositionMapBuilder = new PositionMapBuilderImpl();
    private final DebugTargetImpl.ListenerBlock listenerBlock;
    private final DebugEventListenerImpl debugEventListener = new DebugEventListenerImpl();
    private JavascriptVmEmbedder vmEmbedder = null;
    private WorkspaceBridge workspaceRelations = null;
    private volatile boolean isDisconnected = false;
    private final VmStatusListenerImpl vmStatusListener = new VmStatusListenerImpl();
    private final IDisconnect disconnectAspect = new IDisconnect(){

        public boolean canDisconnect() {
            return !this.isDisconnected();
        }

        public void disconnect() throws DebugException {
            if (!this.canDisconnect()) {
                return;
            }
            ConnectedTargetData.this.workspaceRelations.beforeDetach();
            if (!ConnectedTargetData.this.vmEmbedder.getJavascriptVm().detach()) {
                ChromiumDebugPlugin.logWarning(Messages.DebugTargetImpl_BadResultWhileDisconnecting, new Object[0]);
            }
            ConnectedTargetData.this.debugEventListener.disconnected();
        }

        public boolean isDisconnected() {
            return ConnectedTargetData.this.isDisconnected;
        }
    };
    private final ITerminate terminateAspect = new ITerminate(){

        public boolean canTerminate() {
            return !this.isTerminated();
        }

        public boolean isTerminated() {
            return ConnectedTargetData.this.disconnectAspect.isDisconnected();
        }

        public void terminate() throws DebugException {
            ConnectedTargetData.this.disconnectAspect.disconnect();
        }
    };
    private final JavascriptVmEmbedder.Listener embedderListener = new JavascriptVmEmbedder.Listener(){

        @Override
        public void reset() {
            ConnectedTargetData.this.listenerBlock.waitUntilReady();
            ConnectedTargetData.this.workspaceRelations.handleVmResetEvent();
            DebugTargetImpl.fireDebugEvent(new DebugEvent((Object)ConnectedTargetData.this.debugTargetImpl, 16, 512));
        }

        @Override
        public void closed() {
            ConnectedTargetData.this.debugEventListener.disconnected();
        }
    };

    static TargetInnerState create(DebugTargetImpl debugTargetImpl, DebugTargetImpl.ListenerBlock listenerBlock) {
        ConnectedTargetData data = new ConnectedTargetData(debugTargetImpl, listenerBlock);
        return data.debugTargetState;
    }

    private ConnectedTargetData(DebugTargetImpl debugTargetImpl, DebugTargetImpl.ListenerBlock listenerBlock) {
        this.debugTargetImpl = debugTargetImpl;
        this.singleThread = new JavascriptThread(this);
        this.threadArray = new JavascriptThread[]{this.singleThread};
        this.listenerBlock = listenerBlock;
    }

    void setVmEmbedder(JavascriptVmEmbedder vmEmbedder) {
        this.vmEmbedder = vmEmbedder;
        this.initWorkspaceRelations();
    }

    public void initListeners() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointListener(this.debugTargetState.getBreakpointListner());
        breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this.workspaceRelations.getBreakpointHandler());
        this.workspaceRelations.getBreakpointHandler().initBreakpointManagerListenerState(breakpointManager);
        this.workspaceRelations.startInitialization();
    }

    public JavascriptVmEmbedder getJavascriptEmbedder() {
        return this.vmEmbedder;
    }

    public JavascriptVm getJavascriptVm() {
        return this.getJavascriptEmbedder().getJavascriptVm();
    }

    void fireBecameConnectedEvents() {
        this.setDisconnected(false);
        DebugTargetImpl.fireDebugEvent(new DebugEvent((Object)this.debugTargetImpl, 16));
        this.fireEventForThread(4, 0);
    }

    void fireResumeEvent(int detail) {
        this.fireEventForThread(1, detail);
        DebugTargetImpl.fireDebugEvent(new DebugEvent((Object)this.debugTargetImpl, 1, detail));
    }

    public Collection<? extends VmResource> getVmResource(IFile resource) throws CoreException {
        return this.workspaceRelations.findVmResourcesFromWorkspaceFile(resource);
    }

    public void synchronizeBreakpoints(BreakpointSynchronizer.Direction direction, BreakpointSynchronizer.Callback callback) {
        this.workspaceRelations.synchronizeBreakpoints(direction, callback);
    }

    public DebugEventListenerImpl getDebugEventListener() {
        return this.debugEventListener;
    }

    public JavascriptVmEmbedder.Listener getEmbedderListener() {
        return this.embedderListener;
    }

    public WorkspaceBridge getWorkspaceRelations() {
        return this.workspaceRelations;
    }

    public SourcePositionMap getSourcePositionMap() {
        return this.sourcePositionMapBuilder.getSourcePositionMap();
    }

    public SourcePositionMapBuilder getSourcePositionMapBuilder() {
        return this.sourcePositionMapBuilder;
    }

    public SourceWrapSupport getSourceWrapSupport() {
        return this.debugTargetImpl.getSourceWrapSupport();
    }

    public DebugTargetImpl getDebugTarget() {
        return this.debugTargetImpl;
    }

    public String getName() {
        return this.debugTargetState.getName();
    }

    private JavascriptThread getThread() {
        return this.disconnectAspect.isDisconnected() ? null : this.singleThread;
    }

    private void fireEventForThread(int kind, int detail) {
        try {
            IThread[] threads = this.debugTargetState.getThreads();
            if (threads.length > 0) {
                DebugTargetImpl.fireDebugEvent(new DebugEvent((Object)threads[0], kind, detail));
            }
        }
        catch (DebugException debugException) {
            return;
        }
    }

    private void fireTerminateEvent() {
        DebugTargetImpl.fireDebugEvent(new DebugEvent((Object)this.debugTargetImpl, 8, 0));
        DebugTargetImpl.fireDebugEvent(new DebugEvent((Object)this.debugTargetImpl.getLaunch(), 8, 0));
    }

    void fireSuspendEvent(int detail) {
        this.fireEventForThread(2, detail);
        DebugTargetImpl.fireDebugEvent(new DebugEvent((Object)this.debugTargetImpl, 2, detail));
    }

    private void setDisconnected(boolean disconnected) {
        this.isDisconnected = disconnected;
    }

    boolean isDisconnected() {
        return this.isDisconnected;
    }

    private void initWorkspaceRelations() {
        this.workspaceRelations = this.debugTargetImpl.getWorkspaceBridgeFactory().attachedToVm(this, this.vmEmbedder.getJavascriptVm());
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(new ILaunchListener(){

            public void launchAdded(ILaunch launch) {
            }

            public void launchChanged(ILaunch launch) {
            }

            public void launchRemoved(ILaunch launch) {
                if (launch != ConnectedTargetData.this.debugTargetImpl.getLaunch()) {
                    return;
                }
                DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
                ConnectedTargetData.this.workspaceRelations.launchRemoved();
            }
        });
    }

    private class DebugEventListenerImpl
    implements DebugEventListener {
        private DebugEventListenerImpl() {
        }

        public void disconnected() {
            if (!ConnectedTargetData.this.disconnectAspect.isDisconnected()) {
                ConnectedTargetData.this.setDisconnected(true);
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpointManagerListener((IBreakpointManagerListener)ConnectedTargetData.this.workspaceRelations.getBreakpointHandler());
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)ConnectedTargetData.this.debugTargetImpl);
                ConnectedTargetData.this.fireTerminateEvent();
            }
        }

        public void resumed() {
            ConnectedTargetData.this.listenerBlock.waitUntilReady();
            ConnectedTargetData.this.singleThread.getRemoteEventListener().resumed(null);
        }

        public void suspended(DebugContext context) {
            ConnectedTargetData.this.listenerBlock.waitUntilReady();
            ConnectedTargetData.this.singleThread.getRemoteEventListener().suspended(context);
        }

        public void scriptLoaded(Script newScript) {
            ConnectedTargetData.this.listenerBlock.waitUntilReady();
            ConnectedTargetData.this.workspaceRelations.scriptLoaded(newScript);
        }

        public void scriptCollected(Script script) {
            ConnectedTargetData.this.listenerBlock.waitUntilReady();
            ConnectedTargetData.this.workspaceRelations.scriptCollected(script);
        }

        public void scriptContentChanged(Script newScript) {
            ConnectedTargetData.this.listenerBlock.waitUntilReady();
            ConnectedTargetData.this.workspaceRelations.reloadScript(newScript);
        }

        public DebugEventListener.VmStatusListener getVmStatusListener() {
            return ConnectedTargetData.this.vmStatusListener;
        }
    }

    class TargetInnerState
    extends DebugTargetImpl.State {
        TargetInnerState() {
        }

        @Override
        boolean supportsBreakpoint(IBreakpoint breakpoint) {
            return ConnectedTargetData.this.workspaceRelations.getBreakpointHandler().supportsBreakpoint(breakpoint);
        }

        @Override
        String getVmStatus() {
            if (ConnectedTargetData.this.isDisconnected) {
                return null;
            }
            return ConnectedTargetData.this.vmStatusListener.getStatusString();
        }

        @Override
        IThread[] getThreads() throws DebugException {
            return ConnectedTargetData.this.disconnectAspect.isDisconnected() ? DebugTargetImpl.EMPTY_THREADS : ConnectedTargetData.this.threadArray;
        }

        @Override
        ConnectedTargetData getConnectedTargetDataOrNull() {
            return this.getConnectedTargetData();
        }

        ConnectedTargetData getConnectedTargetData() {
            return ConnectedTargetData.this;
        }

        @Override
        ISuspendResume getSuspendResume() {
            return ConnectedTargetData.this.singleThread.getSuspendResumeAspect();
        }

        @Override
        ITerminate getTerminate() {
            return ConnectedTargetData.this.terminateAspect;
        }

        @Override
        IDisconnect getDisconnect() {
            return ConnectedTargetData.this.disconnectAspect;
        }

        @Override
        String getName() {
            JavascriptVmEmbedder vmEmbedder = ConnectedTargetData.this.getJavascriptEmbedder();
            return vmEmbedder.getTargetName();
        }

        @Override
        EvaluateContext getEvaluateContext() {
            JavascriptThread thread = ConnectedTargetData.this.getThread();
            if (thread == null) {
                return null;
            }
            return thread.getEvaluateContext();
        }

        @Override
        IBreakpointListener getBreakpointListner() {
            return ConnectedTargetData.this.workspaceRelations.getBreakpointHandler();
        }
    }

    private class VmStatusListenerImpl
    implements DebugEventListener.VmStatusListener {
        private String currentRequest = null;
        private int numberOfEnqueued;

        private VmStatusListenerImpl() {
        }

        public synchronized void busyStatusChanged(String currentRequest, int numberOfEnqueued) {
            this.currentRequest = currentRequest;
            this.numberOfEnqueued = numberOfEnqueued;
            DebugTargetImpl.fireDebugEvent(new DebugEvent((Object)ConnectedTargetData.this.debugTargetImpl, 16));
        }

        public synchronized String getStatusString() {
            if (this.currentRequest == null) {
                return null;
            }
            return NLS.bind((String)Messages.DebugTargetImpl_BUSY_WITH, (Object)this.currentRequest, (Object)this.numberOfEnqueued);
        }
    }
}

