/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.tasks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;
import org.eclipse.wst.sse.core.internal.provisional.tasks.IFileTaskScanner;
import org.eclipse.wst.sse.core.internal.provisional.tasks.TaskTag;

public class JSFileTaskScanner
implements IFileTaskScanner {
    private static final String MARKER_TYPE_TASK = "org.eclipse.wst.jsdt.core.task";

    public String getMarkerType() {
        return MARKER_TYPE_TASK;
    }

    protected Map<String, Object> createInitialMarkerAttributes(String text, int documentLine, int startOffset, int length, int priority) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(6);
        attributes.put("lineNumber", documentLine + 1);
        attributes.put("org.eclipse.core.resources.taskmarker", this.getMarkerType());
        attributes.put("charStart", startOffset);
        attributes.put("charEnd", startOffset + length);
        attributes.put("message", text);
        attributes.put("userEditable", Boolean.FALSE);
        switch (priority) {
            case 2: {
                attributes.put("priority", new Integer(2));
                break;
            }
            case 0: {
                attributes.put("priority", new Integer(0));
                break;
            }
            default: {
                attributes.put("priority", new Integer(1));
            }
        }
        return attributes;
    }

    public Map<String, Object>[] scan(IFile file, TaskTag[] taskTags, IProgressMonitor monitor) {
        ArrayList<Map<String, Object>> newMarkers;
        block41: {
            newMarkers = new ArrayList<Map<String, Object>>();
            ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
            SubMonitor localMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            try {
                textFileBufferManager.connect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)localMonitor.newChild(1));
                IDocument document = textFileBufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE).getDocument();
                IDocumentPartitioner partitioner = JavaScriptPlugin.getDefault().getJavaTextTools().createDocumentPartitioner();
                partitioner.connect(document);
                ITypedRegion[] partitions = partitioner.computePartitioning(0, document.getLength());
                SubMonitor partitionMonitor = localMonitor.newChild(1);
                partitionMonitor.beginTask("", partitions.length);
                String[] lowerTags = new String[taskTags.length];
                int i = 0;
                while (i < taskTags.length) {
                    lowerTags[i] = taskTags[i].getTag().toLowerCase(Locale.US);
                    ++i;
                }
                i = 0;
                while (i < partitions.length) {
                    int openingLength = 2;
                    switch (partitions[i].getType()) {
                        case "__java_singleline_comment": {
                            IRegion lineInfo = document.getLineInformationOfOffset(partitions[i].getOffset());
                            int start = partitions[i].getOffset() + openingLength;
                            int lengthToEndOfLine = lineInfo.getOffset() + lineInfo.getLength() - start;
                            String text = document.get(start, lengthToEndOfLine);
                            String lowerText = text.toLowerCase(Locale.US);
                            int j = 0;
                            while (j < lowerTags.length) {
                                if (lowerText.indexOf(lowerTags[j]) >= 0) {
                                    while (start < lineInfo.getOffset() + lineInfo.getLength() && Character.isWhitespace(text.charAt(start - partitions[i].getOffset() - openingLength))) {
                                        ++start;
                                    }
                                    Map<String, Object> attributesForNewTaskMarker = this.createInitialMarkerAttributes(text.trim(), document.getLineOfOffset(partitions[i].getOffset()), start, lineInfo.getOffset() + lineInfo.getLength() - start, taskTags[j].getPriority());
                                    newMarkers.add(attributesForNewTaskMarker);
                                }
                                ++j;
                            }
                            break;
                        }
                        case "__java_javadoc": {
                            openingLength = 3;
                        }
                        case "__java_multiline_comment": {
                            int partitionEnd = partitions[i].getOffset() + partitions[i].getLength();
                            IRegion lineInformation = document.getLineInformationOfOffset(partitions[i].getOffset());
                            int start = partitions[i].getOffset() + openingLength;
                            int lengthToEndOfCommentLine = Math.min(lineInformation.getOffset() + lineInformation.getLength() - start, partitionEnd);
                            String text = document.get(start, lengthToEndOfCommentLine);
                            String lowerText = text.toLowerCase(Locale.US);
                            int j = 0;
                            while (j < lowerTags.length) {
                                if (lowerText.indexOf(lowerTags[j]) >= 0) {
                                    while (start < lineInformation.getOffset() + lineInformation.getLength() && Character.isWhitespace(text.charAt(start - partitions[i].getOffset() - openingLength))) {
                                        ++start;
                                    }
                                    Map<String, Object> attributesForNewTaskMarker = this.createInitialMarkerAttributes(text.trim(), document.getLineOfOffset(partitions[i].getOffset()), start, lengthToEndOfCommentLine, taskTags[j].getPriority());
                                    newMarkers.add(attributesForNewTaskMarker);
                                }
                                ++j;
                            }
                            int secondLineNumber = document.getLineOfOffset(start) + 1;
                            int lastLineNumber = document.getLineOfOffset(partitionEnd);
                            int currentLineNumber = secondLineNumber;
                            while (currentLineNumber <= lastLineNumber) {
                                lineInformation = document.getLineInformation(currentLineNumber);
                                int applicableLength = lineInformation.getLength();
                                text = document.get(lineInformation.getOffset(), applicableLength);
                                if (lineInformation.getOffset() + lineInformation.getLength() > partitionEnd) {
                                    applicableLength = partitionEnd - lineInformation.getOffset();
                                    text = document.get(lineInformation.getOffset(), applicableLength);
                                    while (text.length() > 2 && (text.charAt(text.length() - 1) == '/' || text.charAt(text.length() - 1) == '*')) {
                                        text = text.substring(0, text.length() - 1);
                                        --applicableLength;
                                    }
                                }
                                lowerText = text.toLowerCase(Locale.US);
                                int j2 = 0;
                                while (j2 < lowerTags.length) {
                                    int index = 0;
                                    index = lowerText.indexOf(lowerTags[j2]);
                                    if (index >= 0) {
                                        Map<String, Object> attributesForNewTaskMarker = this.createInitialMarkerAttributes(text.substring(index).trim(), currentLineNumber, lineInformation.getOffset() + index, applicableLength - index, taskTags[j2].getPriority());
                                        newMarkers.add(attributesForNewTaskMarker);
                                    }
                                    ++j2;
                                }
                                ++currentLineNumber;
                            }
                            break;
                        }
                    }
                    partitionMonitor.worked(1);
                    ++i;
                }
                partitioner.disconnect();
            }
            catch (CoreException e) {
                Logger.logException(e);
                try {
                    textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)localMonitor.newChild(1));
                }
                catch (CoreException e2) {
                    Logger.logException("Exception while disconnecting file buffer", e2);
                }
                localMonitor.done();
                break block41;
            }
            catch (BadLocationException e) {
                try {
                    Logger.logException(e);
                    break block41;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)localMonitor.newChild(1));
                    }
                    catch (CoreException e3) {
                        Logger.logException("Exception while disconnecting file buffer", e3);
                    }
                    localMonitor.done();
                }
            }
            try {
                textFileBufferManager.disconnect(file.getFullPath(), LocationKind.IFILE, (IProgressMonitor)localMonitor.newChild(1));
            }
            catch (CoreException e) {
                Logger.logException("Exception while disconnecting file buffer", e);
            }
            localMonitor.done();
        }
        return newMarkers.toArray(new Map[newMarkers.size()]);
    }

    public void shutdown(IProject project) {
    }

    public void startup(IProject project) {
    }
}

