/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.typesystem;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.eclipse.xtend.core.xtend.XtendFormalParameter;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.typesystem.computation.ClosureTypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.ClosureWithExpectationHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ClosureWithoutExpectationHelper;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeAssigner;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.computation.UnknownClosureTypeHelper;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;

public class ExtensionAwareClosureTypeComputer
extends ClosureTypeComputer {
    protected ExtensionAwareClosureTypeComputer(XClosure closure, ITypeExpectation expectation, ITypeComputationState state) {
        super(closure, expectation, state);
    }

    protected ClosureWithExpectationHelper createClosureWithExpectationHelper(JvmOperation operation) {
        return new ClosureWithExpectationHelper(this.getClosure(), operation, this.getExpectation(), this.getState()){

            protected ITypeComputationState assignParameters(ITypeAssigner typeAssigner) {
                ITypeComputationState result = super.assignParameters(typeAssigner);
                ExtensionAwareClosureTypeComputer.this.addExtensions(result);
                return result;
            }
        };
    }

    protected UnknownClosureTypeHelper createUnknownClosureTypeHelper() {
        return new UnknownClosureTypeHelper(this.getClosure(), this.getExpectation(), this.getState()){

            protected ITypeComputationState assignParameters(ITypeAssigner typeAssigner) {
                ITypeComputationState result = super.assignParameters(typeAssigner);
                ExtensionAwareClosureTypeComputer.this.addExtensions(result);
                return result;
            }
        };
    }

    protected ClosureWithoutExpectationHelper createClosureWithoutExpectationHelper() {
        return new ClosureWithoutExpectationHelper(this.getClosure(), this.getExpectation(), this.getState()){

            protected ITypeComputationState assignParameters(ITypeAssigner typeAssigner, FunctionTypeReference incompleteClosureType) {
                ITypeComputationState result = super.assignParameters(typeAssigner, incompleteClosureType);
                ExtensionAwareClosureTypeComputer.this.addExtensions(result);
                return result;
            }
        };
    }

    protected void addExtensions(ITypeComputationState state) {
        LinkedList extensionProviders = null;
        for (JvmFormalParameter parameter : this.getClosure().getDeclaredFormalParameters()) {
            if (!(parameter instanceof XtendFormalParameter) || !((XtendFormalParameter)parameter).isExtension()) continue;
            if (extensionProviders == null) {
                extensionProviders = Lists.newLinkedList();
            }
            extensionProviders.add(parameter);
        }
        if (extensionProviders != null) {
            state.addExtensionsToCurrentScope(extensionProviders);
        }
    }
}

