/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.mount;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.mount.TmpfsOptions;

final class ImmutableTmpfsOptions
implements TmpfsOptions {
    @Nullable
    private final Long sizeBytes;
    @Nullable
    private final Integer mode;

    private ImmutableTmpfsOptions(@Nullable Long sizeBytes, @Nullable Integer mode) {
        this.sizeBytes = sizeBytes;
        this.mode = mode;
    }

    @Override
    @JsonProperty(value="SizeBytes")
    @Nullable
    public Long sizeBytes() {
        return this.sizeBytes;
    }

    @Override
    @JsonProperty(value="Mode")
    @Nullable
    public Integer mode() {
        return this.mode;
    }

    public final ImmutableTmpfsOptions withSizeBytes(@Nullable Long value) {
        if (Objects.equals(this.sizeBytes, value)) {
            return this;
        }
        return new ImmutableTmpfsOptions(value, this.mode);
    }

    public final ImmutableTmpfsOptions withMode(@Nullable Integer value) {
        if (Objects.equals(this.mode, value)) {
            return this;
        }
        return new ImmutableTmpfsOptions(this.sizeBytes, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTmpfsOptions && this.equalTo((ImmutableTmpfsOptions)another);
    }

    private boolean equalTo(ImmutableTmpfsOptions another) {
        return Objects.equals(this.sizeBytes, another.sizeBytes) && Objects.equals(this.mode, another.mode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.sizeBytes);
        h += (h << 5) + Objects.hashCode(this.mode);
        return h;
    }

    public String toString() {
        return "TmpfsOptions{sizeBytes=" + this.sizeBytes + ", mode=" + this.mode + "}";
    }

    public static ImmutableTmpfsOptions copyOf(TmpfsOptions instance) {
        if (instance instanceof ImmutableTmpfsOptions) {
            return (ImmutableTmpfsOptions)instance;
        }
        return ImmutableTmpfsOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements TmpfsOptions.Builder {
        private Long sizeBytes;
        private Integer mode;

        private Builder() {
        }

        public final Builder from(TmpfsOptions instance) {
            Integer modeValue;
            Objects.requireNonNull(instance, "instance");
            Long sizeBytesValue = instance.sizeBytes();
            if (sizeBytesValue != null) {
                this.sizeBytes(sizeBytesValue);
            }
            if ((modeValue = instance.mode()) != null) {
                this.mode(modeValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="SizeBytes")
        public final Builder sizeBytes(@Nullable Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        @Override
        @JsonProperty(value="Mode")
        public final Builder mode(@Nullable Integer mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public ImmutableTmpfsOptions build() {
            return new ImmutableTmpfsOptions(this.sizeBytes, this.mode);
        }
    }
}

