/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.eclipse.core.tests.session.SessionTestSuite;
import org.eclipse.core.tests.session.SetupManager;
import org.eclipse.core.tests.session.TestDescriptor;

public class PerformanceSessionTestSuite
extends SessionTestSuite {
    public static final String PROP_PERFORMANCE = "perf_ctrl";
    private int timesToRun;

    public PerformanceSessionTestSuite(String pluginId, int timesToRun) {
        super(pluginId);
        this.timesToRun = timesToRun;
    }

    public PerformanceSessionTestSuite(String pluginId, int timesToRun, Class<?> theClass) {
        super(pluginId, theClass);
        this.timesToRun = timesToRun;
    }

    public PerformanceSessionTestSuite(String pluginId, int timesToRun, Class<? extends TestCase> theClass, String name) {
        super(pluginId, theClass, name);
        this.timesToRun = timesToRun;
    }

    public PerformanceSessionTestSuite(String pluginId, int timesToRun, String name) {
        super(pluginId, name);
        this.timesToRun = timesToRun;
    }

    @Override
    protected void runSessionTest(TestDescriptor descriptor, TestResult result) {
        try {
            this.fillTestDescriptor(descriptor);
        }
        catch (SetupManager.SetupException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            result.addError(descriptor.getTest(), cause);
            return;
        }
        descriptor.getSetup().setSystemProperty("eclipse.perf.dbloc", System.getProperty("eclipse.perf.dbloc"));
        descriptor.getSetup().setSystemProperty("eclipse.perf.config", System.getProperty("eclipse.perf.config"));
        ConsolidatedTestResult consolidated = new ConsolidatedTestResult(result, this.timesToRun);
        int i = 0;
        while (!consolidated.shouldStop() && i < this.timesToRun - 1) {
            descriptor.run(consolidated);
            ++i;
        }
        if (consolidated.shouldStop()) {
            return;
        }
        descriptor.getSetup().setSystemProperty("eclipse.perf.assertAgainst", System.getProperty("eclipse.perf.assertAgainst"));
        descriptor.run(consolidated);
    }

    private static class ConsolidatedTestResult
    extends TestResult {
        private boolean failed;
        private int runs = 0;
        private boolean started = false;
        private TestResult target;
        private int timesToRun;

        public ConsolidatedTestResult(TestResult target, int timesToRun) {
            this.target = target;
            this.timesToRun = timesToRun;
        }

        public synchronized void addError(Test test, Throwable t) {
            this.failed = true;
            this.target.addError(test, t);
        }

        public synchronized void addFailure(Test test, AssertionFailedError t) {
            this.failed = true;
            this.target.addFailure(test, t);
        }

        public void endTest(Test test) {
            ++this.runs;
            if (!this.failed && this.runs < this.timesToRun) {
                return;
            }
            this.target.endTest(test);
        }

        public synchronized boolean shouldStop() {
            if (this.failed) {
                return true;
            }
            return this.target.shouldStop();
        }

        public void startTest(Test test) {
            if (this.failed) {
                throw new IllegalStateException();
            }
            if (this.started) {
                return;
            }
            this.started = true;
            this.target.startTest(test);
        }
    }
}

