/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.efs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.internal.efs.FilteredWorktreeFileStore;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class EgitFileSystem
extends FileSystem {
    public static final String SCHEME = "egit-internal";

    public IFileStore getStore(IPath path) {
        return EFS.getNullFileSystem().getStore(path);
    }

    public IFileStore getStore(URI uri) {
        if (uri.getScheme().equalsIgnoreCase(this.getScheme())) {
            try {
                UriComponents parsedUri = UriComponents.parse(uri);
                switch (parsedUri.getKind()) {
                    case COMMIT: {
                        throw new URISyntaxException(uri.toString(), "COMMIT selector not implemented yet");
                    }
                    case INDEX: {
                        throw new URISyntaxException(uri.toString(), "INDEX selector not implemented yet");
                    }
                    case WORKTREE: {
                        if (StringUtils.isEmptyOrNull((String)parsedUri.getArguments())) {
                            return parsedUri.getBaseFile();
                        }
                        return new FilteredWorktreeFileStore(parsedUri);
                    }
                }
                throw new URISyntaxException(uri.toString(), MessageFormat.format("Unknown selector {0}", new Object[]{parsedUri.getKind()}));
            }
            catch (IOException | URISyntaxException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
        }
        return EFS.getNullFileSystem().getStore(uri);
    }

    public boolean canWrite() {
        return true;
    }

    public int attributes() {
        return 34;
    }

    public static URI createURI(Repository repository, String gitPath, String arguments) throws URISyntaxException {
        File gitDir = repository.getDirectory();
        String repoPath = gitDir.toURI().getPath();
        int n = EgitFileSystem.slashCount(repoPath);
        if (n > 0 && --n > 0 && repoPath.length() > 2 && repoPath.charAt(1) == '/') {
            --n;
        }
        URI uri = new URI(SCHEME, null, "//" + repoPath + '$' + n + '$' + arguments + '/' + gitPath, null);
        UriComponents.parse(uri);
        return uri;
    }

    private static int slashCount(String s) {
        int n = 0;
        int l = s.length();
        int i = 0;
        while (i < l) {
            if (s.charAt(i) == '/') {
                ++n;
            }
            ++i;
        }
        return n;
    }

    static enum StoreKind {
        INDEX{

            @Override
            public boolean validate(String args) {
                return false;
            }
        }
        ,
        COMMIT{

            @Override
            public boolean validate(String args) {
                return false;
            }
        }
        ,
        WORKTREE{

            @Override
            public boolean validate(String args) {
                if (StringUtils.isEmptyOrNull((String)args)) {
                    return true;
                }
                return WORKTREE_ARGS.matcher(args).matches();
            }
        };

        private static final Pattern WORKTREE_ARGS;

        static {
            WORKTREE_ARGS = Pattern.compile("[oO]\\d*");
        }

        public abstract boolean validate(String var1);
    }

    static class UriComponents {
        private static final Pattern MARKER = Pattern.compile("/\\$(\\d+)\\$([^/]*)(?:/|$)");
        private final String repoPath;
        private final int segmentCount;
        private final StoreKind kind;
        private final String arguments;
        private final String gitPath;

        private UriComponents(String repoPath, int segmentCount, StoreKind kind, String arguments, String gitPath) {
            this.repoPath = repoPath;
            this.segmentCount = segmentCount;
            this.kind = kind;
            this.arguments = arguments;
            this.gitPath = gitPath;
        }

        static UriComponents parse(URI uri) throws URISyntaxException {
            String repoPath;
            String path = uri.getPath();
            if (!path.startsWith("/")) {
                throw new URISyntaxException(uri.toString(), "URI must be absolute");
            }
            Matcher m = MARKER.matcher(path);
            int segments = -1;
            if (m.find()) {
                repoPath = path.substring(0, m.start());
                try {
                    segments = Integer.parseInt(m.group(1));
                }
                catch (NumberFormatException e) {
                    throw new URISyntaxException(uri.toString(), "Invalid number of segments", m.start(1));
                }
            } else {
                throw new URISyntaxException(uri.toString(), "Invalid URI");
            }
            String selector = m.group(2);
            String filePath = path.substring(m.end());
            if (repoPath.isEmpty()) {
                throw new URISyntaxException(uri.toString(), "No repository path");
            }
            int n = UriComponents.segmentCount(repoPath);
            if (segments >= 0 && n != segments) {
                throw new URISyntaxException(uri.toString(), MessageFormat.format("Expected {0} segments for the repository path", Integer.toString(segments)));
            }
            int i = selector.indexOf(58);
            StoreKind kind = null;
            String arguments = null;
            try {
                if (i < 0) {
                    kind = StoreKind.valueOf(selector);
                } else {
                    kind = StoreKind.valueOf(selector.substring(0, i));
                    arguments = selector.substring(i + 1);
                }
            }
            catch (IllegalArgumentException e) {
                throw new URISyntaxException(uri.toString(), MessageFormat.format("Unknown selector {0}", selector));
            }
            if (!kind.validate(arguments)) {
                throw new URISyntaxException(uri.toString(), MessageFormat.format("Unknown selector arguments {0}", arguments));
            }
            return new UriComponents(repoPath, segments, kind, arguments, filePath);
        }

        private static int segmentCount(String path) {
            int n = EgitFileSystem.slashCount(path);
            if (path.length() > 1 && path.charAt(1) == '/') {
                return n - 1;
            }
            return n;
        }

        UriComponents parent() {
            int i = this.gitPath.lastIndexOf(47);
            if (i > 0) {
                return new UriComponents(this.repoPath, this.segmentCount, this.kind, this.arguments, this.gitPath.substring(0, i));
            }
            return null;
        }

        UriComponents child(String name) {
            return new UriComponents(this.repoPath, this.segmentCount, this.kind, this.arguments, this.gitPath.isEmpty() ? name : String.valueOf(this.gitPath) + '/' + name);
        }

        private String path() {
            String args = StringUtils.isEmptyOrNull((String)this.arguments) ? "" : String.valueOf(':') + this.arguments;
            return String.valueOf(this.repoPath) + '/' + '$' + this.segmentCount + '$' + this.kind.name() + args + '/' + this.gitPath;
        }

        URI toUri() {
            try {
                return new URI(EgitFileSystem.SCHEME, null, this.path(), null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        IFileStore getBaseFile() throws IOException {
            File gitDir = this.getRepoDir();
            Repository repository = RepositoryCache.getInstance().lookupRepository(gitDir);
            if (repository == null) {
                throw new IOException(MessageFormat.format("Cannot find repository {0}", gitDir));
            }
            File worktree = repository.getWorkTree();
            if (!StringUtils.isEmptyOrNull((String)this.gitPath)) {
                worktree = new File(worktree, this.gitPath);
            }
            return EFS.getLocalFileSystem().fromLocalFile(worktree);
        }

        final Repository getRepository() {
            try {
                return RepositoryCache.getInstance().lookupRepository(this.getRepoDir());
            }
            catch (IOException e) {
                return null;
            }
        }

        final File getRepoDir() {
            char ch;
            String path = this.repoPath;
            if (SystemReader.getInstance().isWindows() && path.length() > 2 && path.charAt(0) == '/' && path.charAt(2) == ':' && (ch = path.charAt(1)) >= 'A' && ch <= 'Z') {
                path = path.substring(1);
            }
            if (File.separatorChar != '/') {
                path = path.replace('/', File.separatorChar);
            }
            return new File(path);
        }

        final int getSegmentCount() {
            return this.segmentCount;
        }

        final String getGitPath() {
            return this.gitPath;
        }

        final StoreKind getKind() {
            return this.kind;
        }

        final String getArguments() {
            return this.arguments;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            UriComponents other = (UriComponents)obj;
            return this.segmentCount == other.segmentCount && Objects.equals(this.repoPath, other.repoPath) && Objects.equals(this.gitPath, other.gitPath) && Objects.equals(this.arguments, other.arguments);
        }

        public int hashCode() {
            return Objects.hash(this.repoPath, this.gitPath, this.arguments) * 31 + Integer.hashCode(this.segmentCount);
        }

        public String toString() {
            return "egit-internal://" + this.path();
        }
    }
}

