/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.properties;

import java.io.File;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.gitflow.GitFlowConfig;
import org.eclipse.egit.ui.internal.expressions.AbstractPropertyTester;
import org.eclipse.egit.ui.internal.selection.SelectionRepositoryStateCache;
import org.eclipse.jgit.lib.Repository;

public class RepositoryPropertyTester
extends AbstractPropertyTester {
    private static final String IS_MASTER = "isMaster";
    private static final String IS_DEVELOP = "isDevelop";
    private static final String IS_HOTFIX = "isHotfix";
    private static final String IS_RELEASE = "isRelease";
    private static final String IS_INITIALIZED = "isInitialized";
    private static final String IS_FEATURE = "isFeature";
    private static final String HAS_DEFAULT_REMOTE = "hasDefaultRemote";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver == null) {
            return false;
        }
        Repository repository = null;
        if (receiver instanceof String) {
            String gitDir = (String)receiver;
            repository = RepositoryCache.getInstance().getRepository(new File(gitDir));
        } else if (receiver instanceof Repository) {
            repository = (Repository)receiver;
        }
        if (repository == null || repository.isBare()) {
            return false;
        }
        return this.computeResult(expectedValue, this.internalTest(repository, property));
    }

    private boolean internalTest(Repository repository, String property) {
        GitFlowConfig config = new GitFlowConfig(SelectionRepositoryStateCache.INSTANCE.getConfig(repository));
        if (IS_INITIALIZED.equals(property)) {
            return config.isInitialized();
        }
        if (HAS_DEFAULT_REMOTE.equals(property)) {
            return config.hasDefaultRemote();
        }
        String branch = SelectionRepositoryStateCache.INSTANCE.getFullBranchName(repository);
        if (branch == null) {
            return false;
        }
        branch = Repository.shortenRefName((String)branch);
        if (IS_FEATURE.equals(property)) {
            return branch.startsWith(config.getFeaturePrefix());
        }
        if (IS_RELEASE.equals(property)) {
            return branch.startsWith(config.getReleasePrefix());
        }
        if (IS_HOTFIX.equals(property)) {
            return branch.startsWith(config.getHotfixPrefix());
        }
        if (IS_DEVELOP.equals(property)) {
            return branch.equals(config.getDevelop());
        }
        if (IS_MASTER.equals(property)) {
            return branch.equals(config.getMaster());
        }
        return false;
    }
}

