/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.m2e.core.ui.internal.markers.MavenProblemResolution;
import org.eclipse.m2e.editor.MavenEditorImages;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.PomHyperlinkDetector;
import org.eclipse.m2e.editor.pom.PomTextHover;
import org.eclipse.m2e.internal.discovery.markers.MavenDiscoveryMarkerResolutionGenerator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class MarkerHoverControl
extends AbstractInformationControl
implements IInformationControlExtension2,
IInformationControlExtension3,
IInformationControlExtension5 {
    private PomTextHover.CompoundRegion region;
    private Control focusControl;
    private Composite parent;
    private final DefaultMarkerAnnotationAccess markerAccess = new DefaultMarkerAnnotationAccess();

    public MarkerHoverControl(Shell shell, ToolBarManager toolbarManager) {
        super(shell, toolbarManager);
        this.create();
    }

    public MarkerHoverControl(Shell shell) {
        super(shell, EditorsUI.getTooltipAffordanceString());
        this.create();
    }

    public void setInput(Object input) {
        assert (input instanceof PomTextHover.CompoundRegion);
        if (!(input instanceof PomTextHover.CompoundRegion)) {
            throw new IllegalStateException("Not CompoundRegion");
        }
        this.region = (PomTextHover.CompoundRegion)input;
        this.disposeDeferredCreatedContent();
        this.deferredCreateContent();
    }

    Shell getMyShell() {
        return super.getShell();
    }

    Control getRoot() {
        return this.parent;
    }

    public boolean hasContents() {
        return this.region != null;
    }

    public void setFocus() {
        super.setFocus();
        if (this.focusControl != null) {
            this.focusControl.setFocus();
        }
    }

    public final void setVisible(boolean visible) {
        if (!visible) {
            this.disposeDeferredCreatedContent();
        }
        super.setVisible(visible);
    }

    protected void disposeDeferredCreatedContent() {
        Control[] children;
        Control[] controlArray = children = this.parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        ToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.removeAll();
        }
    }

    protected void createContent(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
    }

    public Point computeSizeHint() {
        Point preferedSize = this.getShell().computeSize(-1, -1, true);
        Point constrains = this.getSizeConstraints();
        if (constrains == null) {
            return preferedSize;
        }
        int trimWidth = this.getShell().computeTrim((int)0, (int)0, (int)0, (int)0).width;
        Point constrainedSize = this.getShell().computeSize(constrains.x - trimWidth, -1, true);
        int width = Math.min(preferedSize.x, constrainedSize.x);
        int height = Math.max(preferedSize.y, constrainedSize.y);
        return new Point(width, height);
    }

    protected void deferredCreateContent() {
        if (this.region != null) {
            PomHyperlinkDetector.MarkerRegion markerReg;
            IMarker mark;
            final ScrolledComposite scrolledComposite = new ScrolledComposite(this.parent, 512);
            GridData gridData = new GridData(4, 4, true, true);
            scrolledComposite.setLayoutData((Object)gridData);
            scrolledComposite.setExpandVertical(true);
            scrolledComposite.setExpandHorizontal(true);
            final Composite composite = new Composite((Composite)scrolledComposite, 0);
            GridLayout layout = new GridLayout(1, false);
            composite.setLayout((Layout)layout);
            scrolledComposite.setContent((Control)composite);
            composite.addListener(11, new Listener(){
                int width = -1;

                public void handleEvent(Event e) {
                    int newWidth = composite.getSize().x;
                    if (newWidth != this.width) {
                        scrolledComposite.setMinHeight(composite.computeSize((int)newWidth, (int)-1).y);
                        this.width = newWidth;
                    }
                }
            });
            boolean lifecycleMarkers = false;
            for (IRegion reg : this.region.getRegions()) {
                if (!(reg instanceof PomHyperlinkDetector.MarkerRegion) || !MavenDiscoveryMarkerResolutionGenerator.canResolve((IMarker)(mark = (markerReg = (PomHyperlinkDetector.MarkerRegion)reg).getAnnotation().getMarker()))) continue;
                lifecycleMarkers = true;
                break;
            }
            this.fillToolbar(lifecycleMarkers);
            for (IRegion reg : this.region.getRegions()) {
                Link link;
                if (reg instanceof PomHyperlinkDetector.MarkerRegion) {
                    markerReg = (PomHyperlinkDetector.MarkerRegion)reg;
                    this.createAnnotationInformation(composite, markerReg);
                    mark = markerReg.getAnnotation().getMarker();
                    if (MavenProblemResolution.hasResolutions((IMarker)mark)) {
                        List resolutions = MavenProblemResolution.getResolutions((IMarker)mark);
                        this.createResolutionsControl(composite, mark, resolutions);
                    }
                }
                if (reg instanceof PomHyperlinkDetector.ManagedArtifactRegion) {
                    PomHyperlinkDetector.ManagedArtifactRegion man = (PomHyperlinkDetector.ManagedArtifactRegion)reg;
                    Composite comp = this.createTooltipComposite(composite, PomTextHover.getLabelForRegion(man));
                    if (PomHyperlinkDetector.canCreateHyperLink(man)) {
                        link = this.createHyperlink(comp);
                        link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                            this.dispose();
                            PomHyperlinkDetector.createHyperlink(man).open();
                        }));
                    }
                }
                if (reg instanceof PomHyperlinkDetector.ExpressionRegion) {
                    PomHyperlinkDetector.ExpressionRegion expr = (PomHyperlinkDetector.ExpressionRegion)reg;
                    Composite tooltipComposite = this.createTooltipComposite(composite, PomTextHover.getLabelForRegion(expr));
                    if (PomHyperlinkDetector.canCreateHyperLink(expr)) {
                        link = this.createHyperlink(tooltipComposite);
                        link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                            this.dispose();
                            PomHyperlinkDetector.createHyperlink(expr).open();
                        }));
                    }
                }
                if (this.region.getRegions().indexOf(reg) >= this.region.getRegions().size() - 1) continue;
                this.createSeparator(composite);
            }
            Point constraints = this.getSizeConstraints();
            Point contentSize = composite.computeSize(constraints != null ? constraints.x : -1, -1);
            composite.setSize(new Point(contentSize.x, contentSize.y));
        }
        this.setColorAndFont((Control)this.parent, this.parent.getForeground(), this.parent.getBackground(), JFaceResources.getDialogFont());
        this.parent.layout(true);
    }

    protected void fillToolbar(boolean includeLifecycle) {
        ToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager == null) {
            return;
        }
        toolBarManager.add((IAction)new OpenPreferencesAction((IInformationControl)this, MavenEditorImages.IMGD_WARNINGS, Messages.MarkerHoverControl_openWarningsPrefs, "org.eclipse.m2e.core.ui.preferences.WarningsPreferencePage"));
        if (includeLifecycle) {
            toolBarManager.add((IAction)new OpenPreferencesAction((IInformationControl)this, MavenEditorImages.IMGD_EXECUTION, Messages.MarkerHoverControl_openLifecyclePrefs, "org.eclipse.m2e.core.preferences.LifecycleMappingPreferencePag"));
            toolBarManager.add((IAction)new OpenPreferencesAction((IInformationControl)this, MavenEditorImages.IMGD_DISCOVERY, Messages.MarkerHoverControl_openDiscoveryPrefs, "org.eclipse.m2e.discovery.internal.preferences.DiscoveryPreferencePage"));
        }
        toolBarManager.update(true);
    }

    private Link createHyperlink(Composite parent) {
        Link link = new Link(parent, 0);
        GridData data2 = new GridData(4, 4, true, true);
        data2.horizontalIndent = 18;
        link.setLayoutData((Object)data2);
        link.setText(Messages.PomTextHover_jump_to);
        return link;
    }

    private Composite createTooltipComposite(Composite parent, StyledString text) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        Canvas canvas = new Canvas(composite, 524288);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.widthHint = 17;
        gridData.heightHint = 16;
        canvas.setLayoutData((Object)gridData);
        StyledText styledtext = new StyledText(composite, 74);
        GridData data = new GridData(4, 4, true, true);
        styledtext.setLayoutData((Object)data);
        styledtext.setText(text.getString());
        styledtext.setStyleRanges(text.getStyleRanges());
        new Label(composite, 0);
        return composite;
    }

    private void setColorAndFont(Control control, Color foreground, Color background, Font font) {
        control.setForeground(foreground);
        control.setBackground(background);
        control.setFont(font);
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setColorAndFont(child, foreground, background, font);
                ++n2;
            }
        }
    }

    private void createAnnotationInformation(Composite parent, PomHyperlinkDetector.MarkerRegion annotation) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        Canvas canvas = new Canvas(composite, 524288);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.widthHint = 17;
        gridData.heightHint = 16;
        canvas.setLayoutData((Object)gridData);
        canvas.addPaintListener(e -> {
            e.gc.setFont(null);
            this.markerAccess.paint((Annotation)annotation.getAnnotation(), e.gc, canvas, new Rectangle(0, 0, 16, 16));
        });
        StyledText text = new StyledText(composite, 74);
        GridData data = new GridData(4, 4, true, true);
        text.setLayoutData((Object)data);
        String annotationText = annotation.getAnnotation().getText();
        if (annotationText != null) {
            text.setText(annotationText);
        }
        if (annotation.isDefinedInParent()) {
            new Label(composite, 0);
            Link link = new Link(composite, 0);
            GridData data2 = new GridData(4, 4, true, true);
            data2.horizontalIndent = 18;
            link.setLayoutData((Object)data2);
            link.setText(Messages.MarkerHoverControl_openParentDefinition);
            link.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                PomHyperlinkDetector.createHyperlink(annotation).open();
                this.dispose();
            }));
        }
    }

    private void createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData(4, 128, true, false);
        gridData.verticalIndent = 2;
        separator.setLayoutData((Object)gridData);
    }

    private void createResolutionsControl(Composite parent, IMarker mark, List<IMarkerResolution> resolutions) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label quickFixLabel = new Label(composite, 0);
        GridData layoutData = new GridData(1, 128, false, false);
        layoutData.horizontalIndent = 4;
        quickFixLabel.setLayoutData((Object)layoutData);
        String text = resolutions.size() == 1 ? Messages.PomTextHover_one_quickfix : NLS.bind((String)Messages.PomTextHover_more_quickfixes, (Object)String.valueOf(resolutions.size()));
        quickFixLabel.setText(text);
        Composite composite2 = new Composite(parent, 0);
        composite2.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginLeft = 5;
        layout2.verticalSpacing = 2;
        composite2.setLayout((Layout)layout2);
        ArrayList<Link> list = new ArrayList<Link>();
        for (IMarkerResolution r : resolutions) {
            list.add(this.createCompletionProposalLink(composite2, mark, r, 1));
        }
        final Link[] links = list.toArray(new Link[list.size()]);
        this.focusControl = links.length == 0 ? null : links[0];
        int i = 0;
        while (i < links.length) {
            final int index = i++;
            Link link = links[index];
            link.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    switch (e.keyCode) {
                        case 0x1000002: {
                            if (index + 1 >= links.length) break;
                            links[index + 1].setFocus();
                            break;
                        }
                        case 0x1000001: {
                            if (index <= 0) break;
                            links[index - 1].setFocus();
                            break;
                        }
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
        }
    }

    private Link createCompletionProposalLink(Composite parent, IMarker mark, IMarkerResolution proposal, int count) {
        boolean isMultiFix;
        boolean bl = isMultiFix = count > 1;
        if (isMultiFix) {
            new Label(parent, 0);
            parent = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            parent.setLayout((Layout)layout);
        }
        Label proposalImage = new Label(parent, 0);
        proposalImage.setLayoutData((Object)new GridData(1, 128, false, false));
        Image image = null;
        if (proposal instanceof ICompletionProposal) {
            image = ((ICompletionProposal)proposal).getImage();
        } else if (proposal instanceof IMarkerResolution2) {
            image = ((IMarkerResolution2)proposal).getImage();
        }
        if (image != null) {
            proposalImage.setImage(image);
            proposalImage.addMouseListener(MouseListener.mouseUpAdapter(e -> {
                if (e.button == 1) {
                    this.apply(proposal, mark, this.region.textViewer, this.region.textOffset);
                }
            }));
        }
        Link proposalLink = new Link(parent, 64);
        GridData layoutData = new GridData(1, 128, false, false);
        String linkText = isMultiFix ? NLS.bind((String)Messages.PomTextHover_category_fix, (Object)count) : proposal.getLabel();
        proposalLink.setText("<a>" + linkText + "</a>");
        proposalLink.setLayoutData((Object)layoutData);
        proposalLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.apply(proposal, mark, this.region.textViewer, this.region.textOffset)));
        return proposalLink;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return parent -> new MarkerHoverControl(parent, new ToolBarManager(0x800000));
    }

    private void apply(IMarkerResolution res, IMarker mark, ITextViewer viewer, int offset) {
        if (res instanceof ICompletionProposal) {
            this.apply((ICompletionProposal)res, viewer, offset, false);
        } else {
            this.dispose();
            res.run(mark);
        }
    }

    private void apply(ICompletionProposal p, ITextViewer viewer, int offset, boolean isMultiFix) {
        this.dispose();
        IRewriteTarget target = null;
        try {
            ICompletionProposalExtension2 e;
            IDocument document = viewer.getDocument();
            if (viewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)viewer;
                target = extension.getRewriteTarget();
            }
            if (target != null) {
                target.beginCompoundChange();
            }
            if (p instanceof ICompletionProposalExtension2) {
                e = (ICompletionProposalExtension2)p;
                e.apply(viewer, '\u0000', isMultiFix ? 262144 : 0, offset);
            } else if (p instanceof ICompletionProposalExtension) {
                e = (ICompletionProposalExtension)p;
                e.apply(document, '\u0000', offset);
            } else {
                p.apply(document);
            }
            Point selection = p.getSelection(document);
            if (selection != null) {
                viewer.setSelectedRange(selection.x, selection.y);
                viewer.revealRange(selection.x, selection.y);
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    private static final class OpenPreferencesAction
    extends Action {
        private final IInformationControl infoControl;
        private final String prefsId;

        public OpenPreferencesAction(IInformationControl infoControl, ImageDescriptor imageDesc, String tooltip, String prefsId) {
            this.infoControl = infoControl;
            this.prefsId = prefsId;
            this.setImageDescriptor(imageDesc);
            this.setToolTipText(tooltip);
        }

        public void run() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            this.infoControl.dispose();
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)this.prefsId, null, null).open();
        }
    }
}

