/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.extension.log.collector;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.direct.platform.Platform;

public class LogCollector {
    private static final long timestamp = System.currentTimeMillis();
    private static final Logger log = Logger.getLogger(LogCollector.class);

    public String getFileName(String config, String className) {
        return "config-" + config + "_class-" + className + "_" + this.getID();
    }

    private String getID() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        return dateFormat.format(new Date(timestamp)).toString();
    }

    public String getDirectory() {
        return String.valueOf(System.getProperty("user.dir")) + File.separator + "target" + File.separator + "reddeer-log" + File.separator;
    }

    public String getLogFilePath(String config, String className) {
        return String.valueOf(this.getDirectory()) + File.separator + this.getFileName(config, className);
    }

    public File getLogFile(String config, String className) {
        File logFile = new File(this.getLogFilePath(config, className));
        if (!logFile.exists()) {
            logFile.getParentFile().mkdirs();
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return logFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processWorkbenchLog(String config, String className, String logDescription) {
        if (this.eclipseLogFileExists()) {
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try {
                    BufferedReader br = new BufferedReader(new FileReader(Platform.getWorkbenchLog()));
                    try {
                        try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.getLogFile(config, className), true));){
                            String line = br.readLine();
                            if (line != null) {
                                bw.write(String.valueOf(logDescription) + "\n\n");
                                bw.write(String.valueOf(line) + "\n");
                                while ((line = br.readLine()) != null) {
                                    bw.write(String.valueOf(line) + "\n");
                                }
                                bw.write("\n\n");
                            }
                        }
                        if (br == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (br == null) throw throwable;
                        br.close();
                        throw throwable;
                    }
                    br.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return;
        }
        log.debug("Log file does not exist");
    }

    protected boolean eclipseLogFileExists() {
        File logFile = Platform.getWorkbenchLog();
        return logFile != null && logFile.exists();
    }
}

