/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.internal.ui.actions.RegisterPackagesAction;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class RegisterFilesystemPackagesAction
extends RegisterPackagesAction {
    private static final String TITLE = Messages.getString("RegisterFilesystemPackagesAction.0");
    private static final String TOOL_TIP = Messages.getString("RegisterFilesystemPackagesAction.1");
    private static final String[] FILTER_NAMES = new String[]{Messages.getString("RegisterFilesystemPackagesAction.2"), Messages.getString("RegisterFilesystemPackagesAction.3"), Messages.getString("RegisterFilesystemPackagesAction.4"), Messages.getString("RegisterFilesystemPackagesAction.5")};
    private static final String[] FILTER_EXTENSIONS;

    static {
        String[] stringArray = new String[4];
        stringArray[0] = "ecore";
        stringArray[1] = "xmi";
        stringArray[2] = "xml";
        FILTER_EXTENSIONS = stringArray;
    }

    public RegisterFilesystemPackagesAction(IWorkbenchPage page, CDOSession session) {
        super(page, TITLE, TOOL_TIP, null, session);
    }

    @Override
    protected List<EPackage> getEPackages(IWorkbenchPage page, CDOSession session) {
        Shell shell = page.getWorkbenchWindow().getShell();
        FileDialog dialog = new FileDialog(shell, 4098);
        dialog.setFileName("*.ecore");
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterExtensions(FILTER_EXTENSIONS);
        if (dialog.open() != null) {
            String filterPath = dialog.getFilterPath();
            String[] fileNames = dialog.getFileNames();
            if (fileNames != null && fileNames.length != 0) {
                ResourceSet resourceSet = EMFUtil.newEcoreResourceSet();
                ArrayList<EPackage> ePackages = new ArrayList<EPackage>(fileNames.length);
                String[] stringArray = fileNames;
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    String path = String.valueOf(filterPath) + File.separator + fileName;
                    URI uri = URI.createFileURI((String)path);
                    Resource resource = resourceSet.getResource(uri, true);
                    EPackage ePackage = (EPackage)resource.getContents().get(0);
                    ePackages.add(ePackage);
                    ++n2;
                }
                return ePackages;
            }
        }
        return null;
    }
}

