package org.eclipse.gef.dot.internal.ide.language.contentassist.antlr.internal;
import java.util.Map;
import java.util.HashMap;

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.DFA;
import org.eclipse.gef.dot.internal.language.services.DotColorListGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class InternalDotColorListParser extends AbstractInternalContentAssistParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "NumberSign", "Comma", "Solidus", "Colon", "Semicolon", "RULE_DIGITS", "RULE_ZERO_OR_ONE", "RULE_COLOR_NUMBER", "RULE_HEXADECIMAL_DIGIT", "RULE_COLOR_STRING", "RULE_WS"
    };
    public static final int RULE_WS=14;
    public static final int RULE_COLOR_STRING=13;
    public static final int RULE_DIGITS=9;
    public static final int RULE_ZERO_OR_ONE=10;
    public static final int Semicolon=8;
    public static final int Comma=5;
    public static final int RULE_COLOR_NUMBER=11;
    public static final int NumberSign=4;
    public static final int RULE_HEXADECIMAL_DIGIT=12;
    public static final int Solidus=6;
    public static final int Colon=7;
    public static final int EOF=-1;

    // delegates
    // delegators


        public InternalDotColorListParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalDotColorListParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalDotColorListParser.tokenNames; }
    public String getGrammarFileName() { return "InternalDotColorListParser.g"; }


    	private DotColorListGrammarAccess grammarAccess;
    	private final Map<String, String> tokenNameToValue = new HashMap<String, String>();
    	
    	{
    		tokenNameToValue.put("NumberSign", "'#'");
    		tokenNameToValue.put("Comma", "','");
    		tokenNameToValue.put("Solidus", "'/'");
    		tokenNameToValue.put("Colon", "':'");
    		tokenNameToValue.put("Semicolon", "';'");
    	}

    	public void setGrammarAccess(DotColorListGrammarAccess grammarAccess) {
    		this.grammarAccess = grammarAccess;
    	}

    	@Override
    	protected Grammar getGrammar() {
    		return grammarAccess.getGrammar();
    	}

    	@Override
    	protected String getValueForTokenName(String tokenName) {
    		String result = tokenNameToValue.get(tokenName);
    		if (result == null)
    			result = tokenName;
    		return result;
    	}



    // $ANTLR start "entryRuleColorList"
    // InternalDotColorListParser.g:60:1: entryRuleColorList : ruleColorList EOF ;
    public final void entryRuleColorList() throws RecognitionException {
        try {
            // InternalDotColorListParser.g:61:1: ( ruleColorList EOF )
            // InternalDotColorListParser.g:62:1: ruleColorList EOF
            {
             before(grammarAccess.getColorListRule()); 
            pushFollow(FOLLOW_1);
            ruleColorList();

            state._fsp--;

             after(grammarAccess.getColorListRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleColorList"


    // $ANTLR start "ruleColorList"
    // InternalDotColorListParser.g:69:1: ruleColorList : ( ( rule__ColorList__Group__0 ) ) ;
    public final void ruleColorList() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:73:2: ( ( ( rule__ColorList__Group__0 ) ) )
            // InternalDotColorListParser.g:74:2: ( ( rule__ColorList__Group__0 ) )
            {
            // InternalDotColorListParser.g:74:2: ( ( rule__ColorList__Group__0 ) )
            // InternalDotColorListParser.g:75:3: ( rule__ColorList__Group__0 )
            {
             before(grammarAccess.getColorListAccess().getGroup()); 
            // InternalDotColorListParser.g:76:3: ( rule__ColorList__Group__0 )
            // InternalDotColorListParser.g:76:4: rule__ColorList__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__ColorList__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getColorListAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleColorList"


    // $ANTLR start "entryRuleWC"
    // InternalDotColorListParser.g:85:1: entryRuleWC : ruleWC EOF ;
    public final void entryRuleWC() throws RecognitionException {
        try {
            // InternalDotColorListParser.g:86:1: ( ruleWC EOF )
            // InternalDotColorListParser.g:87:1: ruleWC EOF
            {
             before(grammarAccess.getWCRule()); 
            pushFollow(FOLLOW_1);
            ruleWC();

            state._fsp--;

             after(grammarAccess.getWCRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleWC"


    // $ANTLR start "ruleWC"
    // InternalDotColorListParser.g:94:1: ruleWC : ( ( rule__WC__Group__0 ) ) ;
    public final void ruleWC() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:98:2: ( ( ( rule__WC__Group__0 ) ) )
            // InternalDotColorListParser.g:99:2: ( ( rule__WC__Group__0 ) )
            {
            // InternalDotColorListParser.g:99:2: ( ( rule__WC__Group__0 ) )
            // InternalDotColorListParser.g:100:3: ( rule__WC__Group__0 )
            {
             before(grammarAccess.getWCAccess().getGroup()); 
            // InternalDotColorListParser.g:101:3: ( rule__WC__Group__0 )
            // InternalDotColorListParser.g:101:4: rule__WC__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__WC__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getWCAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleWC"


    // $ANTLR start "entryRuleColor"
    // InternalDotColorListParser.g:110:1: entryRuleColor : ruleColor EOF ;
    public final void entryRuleColor() throws RecognitionException {
        try {
            // InternalDotColorListParser.g:111:1: ( ruleColor EOF )
            // InternalDotColorListParser.g:112:1: ruleColor EOF
            {
             before(grammarAccess.getColorRule()); 
            pushFollow(FOLLOW_1);
            ruleColor();

            state._fsp--;

             after(grammarAccess.getColorRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleColor"


    // $ANTLR start "ruleColor"
    // InternalDotColorListParser.g:119:1: ruleColor : ( ( rule__Color__Alternatives )? ) ;
    public final void ruleColor() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:123:2: ( ( ( rule__Color__Alternatives )? ) )
            // InternalDotColorListParser.g:124:2: ( ( rule__Color__Alternatives )? )
            {
            // InternalDotColorListParser.g:124:2: ( ( rule__Color__Alternatives )? )
            // InternalDotColorListParser.g:125:3: ( rule__Color__Alternatives )?
            {
             before(grammarAccess.getColorAccess().getAlternatives()); 
            // InternalDotColorListParser.g:126:3: ( rule__Color__Alternatives )?
            int alt1=2;
            int LA1_0 = input.LA(1);

            if ( (LA1_0==NumberSign||LA1_0==Solidus||(LA1_0>=RULE_COLOR_NUMBER && LA1_0<=RULE_COLOR_STRING)) ) {
                alt1=1;
            }
            switch (alt1) {
                case 1 :
                    // InternalDotColorListParser.g:126:4: rule__Color__Alternatives
                    {
                    pushFollow(FOLLOW_2);
                    rule__Color__Alternatives();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getColorAccess().getAlternatives()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleColor"


    // $ANTLR start "entryRuleRGBColor"
    // InternalDotColorListParser.g:135:1: entryRuleRGBColor : ruleRGBColor EOF ;
    public final void entryRuleRGBColor() throws RecognitionException {
        try {
            // InternalDotColorListParser.g:136:1: ( ruleRGBColor EOF )
            // InternalDotColorListParser.g:137:1: ruleRGBColor EOF
            {
             before(grammarAccess.getRGBColorRule()); 
            pushFollow(FOLLOW_1);
            ruleRGBColor();

            state._fsp--;

             after(grammarAccess.getRGBColorRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleRGBColor"


    // $ANTLR start "ruleRGBColor"
    // InternalDotColorListParser.g:144:1: ruleRGBColor : ( ( rule__RGBColor__Group__0 ) ) ;
    public final void ruleRGBColor() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:148:2: ( ( ( rule__RGBColor__Group__0 ) ) )
            // InternalDotColorListParser.g:149:2: ( ( rule__RGBColor__Group__0 ) )
            {
            // InternalDotColorListParser.g:149:2: ( ( rule__RGBColor__Group__0 ) )
            // InternalDotColorListParser.g:150:3: ( rule__RGBColor__Group__0 )
            {
             before(grammarAccess.getRGBColorAccess().getGroup()); 
            // InternalDotColorListParser.g:151:3: ( rule__RGBColor__Group__0 )
            // InternalDotColorListParser.g:151:4: rule__RGBColor__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getRGBColorAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleRGBColor"


    // $ANTLR start "entryRuleHSVColor"
    // InternalDotColorListParser.g:160:1: entryRuleHSVColor : ruleHSVColor EOF ;
    public final void entryRuleHSVColor() throws RecognitionException {
        try {
            // InternalDotColorListParser.g:161:1: ( ruleHSVColor EOF )
            // InternalDotColorListParser.g:162:1: ruleHSVColor EOF
            {
             before(grammarAccess.getHSVColorRule()); 
            pushFollow(FOLLOW_1);
            ruleHSVColor();

            state._fsp--;

             after(grammarAccess.getHSVColorRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleHSVColor"


    // $ANTLR start "ruleHSVColor"
    // InternalDotColorListParser.g:169:1: ruleHSVColor : ( ( rule__HSVColor__Group__0 ) ) ;
    public final void ruleHSVColor() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:173:2: ( ( ( rule__HSVColor__Group__0 ) ) )
            // InternalDotColorListParser.g:174:2: ( ( rule__HSVColor__Group__0 ) )
            {
            // InternalDotColorListParser.g:174:2: ( ( rule__HSVColor__Group__0 ) )
            // InternalDotColorListParser.g:175:3: ( rule__HSVColor__Group__0 )
            {
             before(grammarAccess.getHSVColorAccess().getGroup()); 
            // InternalDotColorListParser.g:176:3: ( rule__HSVColor__Group__0 )
            // InternalDotColorListParser.g:176:4: rule__HSVColor__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getHSVColorAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleHSVColor"


    // $ANTLR start "entryRuleStringColor"
    // InternalDotColorListParser.g:185:1: entryRuleStringColor : ruleStringColor EOF ;
    public final void entryRuleStringColor() throws RecognitionException {
        try {
            // InternalDotColorListParser.g:186:1: ( ruleStringColor EOF )
            // InternalDotColorListParser.g:187:1: ruleStringColor EOF
            {
             before(grammarAccess.getStringColorRule()); 
            pushFollow(FOLLOW_1);
            ruleStringColor();

            state._fsp--;

             after(grammarAccess.getStringColorRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleStringColor"


    // $ANTLR start "ruleStringColor"
    // InternalDotColorListParser.g:194:1: ruleStringColor : ( ( rule__StringColor__Group__0 ) ) ;
    public final void ruleStringColor() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:198:2: ( ( ( rule__StringColor__Group__0 ) ) )
            // InternalDotColorListParser.g:199:2: ( ( rule__StringColor__Group__0 ) )
            {
            // InternalDotColorListParser.g:199:2: ( ( rule__StringColor__Group__0 ) )
            // InternalDotColorListParser.g:200:3: ( rule__StringColor__Group__0 )
            {
             before(grammarAccess.getStringColorAccess().getGroup()); 
            // InternalDotColorListParser.g:201:3: ( rule__StringColor__Group__0 )
            // InternalDotColorListParser.g:201:4: rule__StringColor__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__StringColor__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getStringColorAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleStringColor"


    // $ANTLR start "entryRulehex"
    // InternalDotColorListParser.g:210:1: entryRulehex : rulehex EOF ;
    public final void entryRulehex() throws RecognitionException {
        try {
            // InternalDotColorListParser.g:211:1: ( rulehex EOF )
            // InternalDotColorListParser.g:212:1: rulehex EOF
            {
             before(grammarAccess.getHexRule()); 
            pushFollow(FOLLOW_1);
            rulehex();

            state._fsp--;

             after(grammarAccess.getHexRule()); 
            match(input,EOF,FOLLOW_2); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRulehex"


    // $ANTLR start "rulehex"
    // InternalDotColorListParser.g:219:1: rulehex : ( ( rule__Hex__Group__0 ) ) ;
    public final void rulehex() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:223:2: ( ( ( rule__Hex__Group__0 ) ) )
            // InternalDotColorListParser.g:224:2: ( ( rule__Hex__Group__0 ) )
            {
            // InternalDotColorListParser.g:224:2: ( ( rule__Hex__Group__0 ) )
            // InternalDotColorListParser.g:225:3: ( rule__Hex__Group__0 )
            {
             before(grammarAccess.getHexAccess().getGroup()); 
            // InternalDotColorListParser.g:226:3: ( rule__Hex__Group__0 )
            // InternalDotColorListParser.g:226:4: rule__Hex__Group__0
            {
            pushFollow(FOLLOW_2);
            rule__Hex__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getHexAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rulehex"


    // $ANTLR start "rule__Color__Alternatives"
    // InternalDotColorListParser.g:234:1: rule__Color__Alternatives : ( ( ruleRGBColor ) | ( ruleHSVColor ) | ( ruleStringColor ) );
    public final void rule__Color__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:238:1: ( ( ruleRGBColor ) | ( ruleHSVColor ) | ( ruleStringColor ) )
            int alt2=3;
            switch ( input.LA(1) ) {
            case NumberSign:
                {
                alt2=1;
                }
                break;
            case RULE_COLOR_NUMBER:
                {
                int LA2_2 = input.LA(2);

                if ( (LA2_2==EOF||(LA2_2>=Colon && LA2_2<=Semicolon)) ) {
                    alt2=3;
                }
                else if ( (LA2_2==Comma||LA2_2==RULE_COLOR_NUMBER) ) {
                    alt2=2;
                }
                else {
                    NoViableAltException nvae =
                        new NoViableAltException("", 2, 2, input);

                    throw nvae;
                }
                }
                break;
            case Solidus:
            case RULE_HEXADECIMAL_DIGIT:
            case RULE_COLOR_STRING:
                {
                alt2=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 2, 0, input);

                throw nvae;
            }

            switch (alt2) {
                case 1 :
                    // InternalDotColorListParser.g:239:2: ( ruleRGBColor )
                    {
                    // InternalDotColorListParser.g:239:2: ( ruleRGBColor )
                    // InternalDotColorListParser.g:240:3: ruleRGBColor
                    {
                     before(grammarAccess.getColorAccess().getRGBColorParserRuleCall_0()); 
                    pushFollow(FOLLOW_2);
                    ruleRGBColor();

                    state._fsp--;

                     after(grammarAccess.getColorAccess().getRGBColorParserRuleCall_0()); 

                    }


                    }
                    break;
                case 2 :
                    // InternalDotColorListParser.g:245:2: ( ruleHSVColor )
                    {
                    // InternalDotColorListParser.g:245:2: ( ruleHSVColor )
                    // InternalDotColorListParser.g:246:3: ruleHSVColor
                    {
                     before(grammarAccess.getColorAccess().getHSVColorParserRuleCall_1()); 
                    pushFollow(FOLLOW_2);
                    ruleHSVColor();

                    state._fsp--;

                     after(grammarAccess.getColorAccess().getHSVColorParserRuleCall_1()); 

                    }


                    }
                    break;
                case 3 :
                    // InternalDotColorListParser.g:251:2: ( ruleStringColor )
                    {
                    // InternalDotColorListParser.g:251:2: ( ruleStringColor )
                    // InternalDotColorListParser.g:252:3: ruleStringColor
                    {
                     before(grammarAccess.getColorAccess().getStringColorParserRuleCall_2()); 
                    pushFollow(FOLLOW_2);
                    ruleStringColor();

                    state._fsp--;

                     after(grammarAccess.getColorAccess().getStringColorParserRuleCall_2()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Color__Alternatives"


    // $ANTLR start "rule__StringColor__NameAlternatives_1_0"
    // InternalDotColorListParser.g:261:1: rule__StringColor__NameAlternatives_1_0 : ( ( RULE_HEXADECIMAL_DIGIT ) | ( RULE_COLOR_STRING ) | ( RULE_COLOR_NUMBER ) );
    public final void rule__StringColor__NameAlternatives_1_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:265:1: ( ( RULE_HEXADECIMAL_DIGIT ) | ( RULE_COLOR_STRING ) | ( RULE_COLOR_NUMBER ) )
            int alt3=3;
            switch ( input.LA(1) ) {
            case RULE_HEXADECIMAL_DIGIT:
                {
                alt3=1;
                }
                break;
            case RULE_COLOR_STRING:
                {
                alt3=2;
                }
                break;
            case RULE_COLOR_NUMBER:
                {
                alt3=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;
            }

            switch (alt3) {
                case 1 :
                    // InternalDotColorListParser.g:266:2: ( RULE_HEXADECIMAL_DIGIT )
                    {
                    // InternalDotColorListParser.g:266:2: ( RULE_HEXADECIMAL_DIGIT )
                    // InternalDotColorListParser.g:267:3: RULE_HEXADECIMAL_DIGIT
                    {
                     before(grammarAccess.getStringColorAccess().getNameHEXADECIMAL_DIGITTerminalRuleCall_1_0_0()); 
                    match(input,RULE_HEXADECIMAL_DIGIT,FOLLOW_2); 
                     after(grammarAccess.getStringColorAccess().getNameHEXADECIMAL_DIGITTerminalRuleCall_1_0_0()); 

                    }


                    }
                    break;
                case 2 :
                    // InternalDotColorListParser.g:272:2: ( RULE_COLOR_STRING )
                    {
                    // InternalDotColorListParser.g:272:2: ( RULE_COLOR_STRING )
                    // InternalDotColorListParser.g:273:3: RULE_COLOR_STRING
                    {
                     before(grammarAccess.getStringColorAccess().getNameCOLOR_STRINGTerminalRuleCall_1_0_1()); 
                    match(input,RULE_COLOR_STRING,FOLLOW_2); 
                     after(grammarAccess.getStringColorAccess().getNameCOLOR_STRINGTerminalRuleCall_1_0_1()); 

                    }


                    }
                    break;
                case 3 :
                    // InternalDotColorListParser.g:278:2: ( RULE_COLOR_NUMBER )
                    {
                    // InternalDotColorListParser.g:278:2: ( RULE_COLOR_NUMBER )
                    // InternalDotColorListParser.g:279:3: RULE_COLOR_NUMBER
                    {
                     before(grammarAccess.getStringColorAccess().getNameCOLOR_NUMBERTerminalRuleCall_1_0_2()); 
                    match(input,RULE_COLOR_NUMBER,FOLLOW_2); 
                     after(grammarAccess.getStringColorAccess().getNameCOLOR_NUMBERTerminalRuleCall_1_0_2()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__NameAlternatives_1_0"


    // $ANTLR start "rule__ColorList__Group__0"
    // InternalDotColorListParser.g:288:1: rule__ColorList__Group__0 : rule__ColorList__Group__0__Impl rule__ColorList__Group__1 ;
    public final void rule__ColorList__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:292:1: ( rule__ColorList__Group__0__Impl rule__ColorList__Group__1 )
            // InternalDotColorListParser.g:293:2: rule__ColorList__Group__0__Impl rule__ColorList__Group__1
            {
            pushFollow(FOLLOW_3);
            rule__ColorList__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__ColorList__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ColorList__Group__0"


    // $ANTLR start "rule__ColorList__Group__0__Impl"
    // InternalDotColorListParser.g:300:1: rule__ColorList__Group__0__Impl : ( ( rule__ColorList__ColorValuesAssignment_0 ) ) ;
    public final void rule__ColorList__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:304:1: ( ( ( rule__ColorList__ColorValuesAssignment_0 ) ) )
            // InternalDotColorListParser.g:305:1: ( ( rule__ColorList__ColorValuesAssignment_0 ) )
            {
            // InternalDotColorListParser.g:305:1: ( ( rule__ColorList__ColorValuesAssignment_0 ) )
            // InternalDotColorListParser.g:306:2: ( rule__ColorList__ColorValuesAssignment_0 )
            {
             before(grammarAccess.getColorListAccess().getColorValuesAssignment_0()); 
            // InternalDotColorListParser.g:307:2: ( rule__ColorList__ColorValuesAssignment_0 )
            // InternalDotColorListParser.g:307:3: rule__ColorList__ColorValuesAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__ColorList__ColorValuesAssignment_0();

            state._fsp--;


            }

             after(grammarAccess.getColorListAccess().getColorValuesAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ColorList__Group__0__Impl"


    // $ANTLR start "rule__ColorList__Group__1"
    // InternalDotColorListParser.g:315:1: rule__ColorList__Group__1 : rule__ColorList__Group__1__Impl ;
    public final void rule__ColorList__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:319:1: ( rule__ColorList__Group__1__Impl )
            // InternalDotColorListParser.g:320:2: rule__ColorList__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__ColorList__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ColorList__Group__1"


    // $ANTLR start "rule__ColorList__Group__1__Impl"
    // InternalDotColorListParser.g:326:1: rule__ColorList__Group__1__Impl : ( ( rule__ColorList__Group_1__0 )* ) ;
    public final void rule__ColorList__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:330:1: ( ( ( rule__ColorList__Group_1__0 )* ) )
            // InternalDotColorListParser.g:331:1: ( ( rule__ColorList__Group_1__0 )* )
            {
            // InternalDotColorListParser.g:331:1: ( ( rule__ColorList__Group_1__0 )* )
            // InternalDotColorListParser.g:332:2: ( rule__ColorList__Group_1__0 )*
            {
             before(grammarAccess.getColorListAccess().getGroup_1()); 
            // InternalDotColorListParser.g:333:2: ( rule__ColorList__Group_1__0 )*
            loop4:
            do {
                int alt4=2;
                int LA4_0 = input.LA(1);

                if ( (LA4_0==Colon) ) {
                    alt4=1;
                }


                switch (alt4) {
            	case 1 :
            	    // InternalDotColorListParser.g:333:3: rule__ColorList__Group_1__0
            	    {
            	    pushFollow(FOLLOW_4);
            	    rule__ColorList__Group_1__0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop4;
                }
            } while (true);

             after(grammarAccess.getColorListAccess().getGroup_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ColorList__Group__1__Impl"


    // $ANTLR start "rule__ColorList__Group_1__0"
    // InternalDotColorListParser.g:342:1: rule__ColorList__Group_1__0 : rule__ColorList__Group_1__0__Impl rule__ColorList__Group_1__1 ;
    public final void rule__ColorList__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:346:1: ( rule__ColorList__Group_1__0__Impl rule__ColorList__Group_1__1 )
            // InternalDotColorListParser.g:347:2: rule__ColorList__Group_1__0__Impl rule__ColorList__Group_1__1
            {
            pushFollow(FOLLOW_5);
            rule__ColorList__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__ColorList__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ColorList__Group_1__0"


    // $ANTLR start "rule__ColorList__Group_1__0__Impl"
    // InternalDotColorListParser.g:354:1: rule__ColorList__Group_1__0__Impl : ( Colon ) ;
    public final void rule__ColorList__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:358:1: ( ( Colon ) )
            // InternalDotColorListParser.g:359:1: ( Colon )
            {
            // InternalDotColorListParser.g:359:1: ( Colon )
            // InternalDotColorListParser.g:360:2: Colon
            {
             before(grammarAccess.getColorListAccess().getColonKeyword_1_0()); 
            match(input,Colon,FOLLOW_2); 
             after(grammarAccess.getColorListAccess().getColonKeyword_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ColorList__Group_1__0__Impl"


    // $ANTLR start "rule__ColorList__Group_1__1"
    // InternalDotColorListParser.g:369:1: rule__ColorList__Group_1__1 : rule__ColorList__Group_1__1__Impl ;
    public final void rule__ColorList__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:373:1: ( rule__ColorList__Group_1__1__Impl )
            // InternalDotColorListParser.g:374:2: rule__ColorList__Group_1__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__ColorList__Group_1__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ColorList__Group_1__1"


    // $ANTLR start "rule__ColorList__Group_1__1__Impl"
    // InternalDotColorListParser.g:380:1: rule__ColorList__Group_1__1__Impl : ( ( rule__ColorList__ColorValuesAssignment_1_1 ) ) ;
    public final void rule__ColorList__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:384:1: ( ( ( rule__ColorList__ColorValuesAssignment_1_1 ) ) )
            // InternalDotColorListParser.g:385:1: ( ( rule__ColorList__ColorValuesAssignment_1_1 ) )
            {
            // InternalDotColorListParser.g:385:1: ( ( rule__ColorList__ColorValuesAssignment_1_1 ) )
            // InternalDotColorListParser.g:386:2: ( rule__ColorList__ColorValuesAssignment_1_1 )
            {
             before(grammarAccess.getColorListAccess().getColorValuesAssignment_1_1()); 
            // InternalDotColorListParser.g:387:2: ( rule__ColorList__ColorValuesAssignment_1_1 )
            // InternalDotColorListParser.g:387:3: rule__ColorList__ColorValuesAssignment_1_1
            {
            pushFollow(FOLLOW_2);
            rule__ColorList__ColorValuesAssignment_1_1();

            state._fsp--;


            }

             after(grammarAccess.getColorListAccess().getColorValuesAssignment_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ColorList__Group_1__1__Impl"


    // $ANTLR start "rule__WC__Group__0"
    // InternalDotColorListParser.g:396:1: rule__WC__Group__0 : rule__WC__Group__0__Impl rule__WC__Group__1 ;
    public final void rule__WC__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:400:1: ( rule__WC__Group__0__Impl rule__WC__Group__1 )
            // InternalDotColorListParser.g:401:2: rule__WC__Group__0__Impl rule__WC__Group__1
            {
            pushFollow(FOLLOW_6);
            rule__WC__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__WC__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__WC__Group__0"


    // $ANTLR start "rule__WC__Group__0__Impl"
    // InternalDotColorListParser.g:408:1: rule__WC__Group__0__Impl : ( ( rule__WC__ColorAssignment_0 ) ) ;
    public final void rule__WC__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:412:1: ( ( ( rule__WC__ColorAssignment_0 ) ) )
            // InternalDotColorListParser.g:413:1: ( ( rule__WC__ColorAssignment_0 ) )
            {
            // InternalDotColorListParser.g:413:1: ( ( rule__WC__ColorAssignment_0 ) )
            // InternalDotColorListParser.g:414:2: ( rule__WC__ColorAssignment_0 )
            {
             before(grammarAccess.getWCAccess().getColorAssignment_0()); 
            // InternalDotColorListParser.g:415:2: ( rule__WC__ColorAssignment_0 )
            // InternalDotColorListParser.g:415:3: rule__WC__ColorAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__WC__ColorAssignment_0();

            state._fsp--;


            }

             after(grammarAccess.getWCAccess().getColorAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__WC__Group__0__Impl"


    // $ANTLR start "rule__WC__Group__1"
    // InternalDotColorListParser.g:423:1: rule__WC__Group__1 : rule__WC__Group__1__Impl ;
    public final void rule__WC__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:427:1: ( rule__WC__Group__1__Impl )
            // InternalDotColorListParser.g:428:2: rule__WC__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__WC__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__WC__Group__1"


    // $ANTLR start "rule__WC__Group__1__Impl"
    // InternalDotColorListParser.g:434:1: rule__WC__Group__1__Impl : ( ( rule__WC__Group_1__0 )? ) ;
    public final void rule__WC__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:438:1: ( ( ( rule__WC__Group_1__0 )? ) )
            // InternalDotColorListParser.g:439:1: ( ( rule__WC__Group_1__0 )? )
            {
            // InternalDotColorListParser.g:439:1: ( ( rule__WC__Group_1__0 )? )
            // InternalDotColorListParser.g:440:2: ( rule__WC__Group_1__0 )?
            {
             before(grammarAccess.getWCAccess().getGroup_1()); 
            // InternalDotColorListParser.g:441:2: ( rule__WC__Group_1__0 )?
            int alt5=2;
            int LA5_0 = input.LA(1);

            if ( (LA5_0==Semicolon) ) {
                alt5=1;
            }
            switch (alt5) {
                case 1 :
                    // InternalDotColorListParser.g:441:3: rule__WC__Group_1__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__WC__Group_1__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getWCAccess().getGroup_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__WC__Group__1__Impl"


    // $ANTLR start "rule__WC__Group_1__0"
    // InternalDotColorListParser.g:450:1: rule__WC__Group_1__0 : rule__WC__Group_1__0__Impl rule__WC__Group_1__1 ;
    public final void rule__WC__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:454:1: ( rule__WC__Group_1__0__Impl rule__WC__Group_1__1 )
            // InternalDotColorListParser.g:455:2: rule__WC__Group_1__0__Impl rule__WC__Group_1__1
            {
            pushFollow(FOLLOW_7);
            rule__WC__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__WC__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__WC__Group_1__0"


    // $ANTLR start "rule__WC__Group_1__0__Impl"
    // InternalDotColorListParser.g:462:1: rule__WC__Group_1__0__Impl : ( Semicolon ) ;
    public final void rule__WC__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:466:1: ( ( Semicolon ) )
            // InternalDotColorListParser.g:467:1: ( Semicolon )
            {
            // InternalDotColorListParser.g:467:1: ( Semicolon )
            // InternalDotColorListParser.g:468:2: Semicolon
            {
             before(grammarAccess.getWCAccess().getSemicolonKeyword_1_0()); 
            match(input,Semicolon,FOLLOW_2); 
             after(grammarAccess.getWCAccess().getSemicolonKeyword_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__WC__Group_1__0__Impl"


    // $ANTLR start "rule__WC__Group_1__1"
    // InternalDotColorListParser.g:477:1: rule__WC__Group_1__1 : rule__WC__Group_1__1__Impl ;
    public final void rule__WC__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:481:1: ( rule__WC__Group_1__1__Impl )
            // InternalDotColorListParser.g:482:2: rule__WC__Group_1__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__WC__Group_1__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__WC__Group_1__1"


    // $ANTLR start "rule__WC__Group_1__1__Impl"
    // InternalDotColorListParser.g:488:1: rule__WC__Group_1__1__Impl : ( ( rule__WC__WeightAssignment_1_1 ) ) ;
    public final void rule__WC__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:492:1: ( ( ( rule__WC__WeightAssignment_1_1 ) ) )
            // InternalDotColorListParser.g:493:1: ( ( rule__WC__WeightAssignment_1_1 ) )
            {
            // InternalDotColorListParser.g:493:1: ( ( rule__WC__WeightAssignment_1_1 ) )
            // InternalDotColorListParser.g:494:2: ( rule__WC__WeightAssignment_1_1 )
            {
             before(grammarAccess.getWCAccess().getWeightAssignment_1_1()); 
            // InternalDotColorListParser.g:495:2: ( rule__WC__WeightAssignment_1_1 )
            // InternalDotColorListParser.g:495:3: rule__WC__WeightAssignment_1_1
            {
            pushFollow(FOLLOW_2);
            rule__WC__WeightAssignment_1_1();

            state._fsp--;


            }

             after(grammarAccess.getWCAccess().getWeightAssignment_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__WC__Group_1__1__Impl"


    // $ANTLR start "rule__RGBColor__Group__0"
    // InternalDotColorListParser.g:504:1: rule__RGBColor__Group__0 : rule__RGBColor__Group__0__Impl rule__RGBColor__Group__1 ;
    public final void rule__RGBColor__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:508:1: ( rule__RGBColor__Group__0__Impl rule__RGBColor__Group__1 )
            // InternalDotColorListParser.g:509:2: rule__RGBColor__Group__0__Impl rule__RGBColor__Group__1
            {
            pushFollow(FOLLOW_8);
            rule__RGBColor__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__0"


    // $ANTLR start "rule__RGBColor__Group__0__Impl"
    // InternalDotColorListParser.g:516:1: rule__RGBColor__Group__0__Impl : ( NumberSign ) ;
    public final void rule__RGBColor__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:520:1: ( ( NumberSign ) )
            // InternalDotColorListParser.g:521:1: ( NumberSign )
            {
            // InternalDotColorListParser.g:521:1: ( NumberSign )
            // InternalDotColorListParser.g:522:2: NumberSign
            {
             before(grammarAccess.getRGBColorAccess().getNumberSignKeyword_0()); 
            match(input,NumberSign,FOLLOW_2); 
             after(grammarAccess.getRGBColorAccess().getNumberSignKeyword_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__0__Impl"


    // $ANTLR start "rule__RGBColor__Group__1"
    // InternalDotColorListParser.g:531:1: rule__RGBColor__Group__1 : rule__RGBColor__Group__1__Impl rule__RGBColor__Group__2 ;
    public final void rule__RGBColor__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:535:1: ( rule__RGBColor__Group__1__Impl rule__RGBColor__Group__2 )
            // InternalDotColorListParser.g:536:2: rule__RGBColor__Group__1__Impl rule__RGBColor__Group__2
            {
            pushFollow(FOLLOW_8);
            rule__RGBColor__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__1"


    // $ANTLR start "rule__RGBColor__Group__1__Impl"
    // InternalDotColorListParser.g:543:1: rule__RGBColor__Group__1__Impl : ( ( rule__RGBColor__RAssignment_1 ) ) ;
    public final void rule__RGBColor__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:547:1: ( ( ( rule__RGBColor__RAssignment_1 ) ) )
            // InternalDotColorListParser.g:548:1: ( ( rule__RGBColor__RAssignment_1 ) )
            {
            // InternalDotColorListParser.g:548:1: ( ( rule__RGBColor__RAssignment_1 ) )
            // InternalDotColorListParser.g:549:2: ( rule__RGBColor__RAssignment_1 )
            {
             before(grammarAccess.getRGBColorAccess().getRAssignment_1()); 
            // InternalDotColorListParser.g:550:2: ( rule__RGBColor__RAssignment_1 )
            // InternalDotColorListParser.g:550:3: rule__RGBColor__RAssignment_1
            {
            pushFollow(FOLLOW_2);
            rule__RGBColor__RAssignment_1();

            state._fsp--;


            }

             after(grammarAccess.getRGBColorAccess().getRAssignment_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__1__Impl"


    // $ANTLR start "rule__RGBColor__Group__2"
    // InternalDotColorListParser.g:558:1: rule__RGBColor__Group__2 : rule__RGBColor__Group__2__Impl rule__RGBColor__Group__3 ;
    public final void rule__RGBColor__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:562:1: ( rule__RGBColor__Group__2__Impl rule__RGBColor__Group__3 )
            // InternalDotColorListParser.g:563:2: rule__RGBColor__Group__2__Impl rule__RGBColor__Group__3
            {
            pushFollow(FOLLOW_8);
            rule__RGBColor__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__2"


    // $ANTLR start "rule__RGBColor__Group__2__Impl"
    // InternalDotColorListParser.g:570:1: rule__RGBColor__Group__2__Impl : ( ( rule__RGBColor__GAssignment_2 ) ) ;
    public final void rule__RGBColor__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:574:1: ( ( ( rule__RGBColor__GAssignment_2 ) ) )
            // InternalDotColorListParser.g:575:1: ( ( rule__RGBColor__GAssignment_2 ) )
            {
            // InternalDotColorListParser.g:575:1: ( ( rule__RGBColor__GAssignment_2 ) )
            // InternalDotColorListParser.g:576:2: ( rule__RGBColor__GAssignment_2 )
            {
             before(grammarAccess.getRGBColorAccess().getGAssignment_2()); 
            // InternalDotColorListParser.g:577:2: ( rule__RGBColor__GAssignment_2 )
            // InternalDotColorListParser.g:577:3: rule__RGBColor__GAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__RGBColor__GAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getRGBColorAccess().getGAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__2__Impl"


    // $ANTLR start "rule__RGBColor__Group__3"
    // InternalDotColorListParser.g:585:1: rule__RGBColor__Group__3 : rule__RGBColor__Group__3__Impl rule__RGBColor__Group__4 ;
    public final void rule__RGBColor__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:589:1: ( rule__RGBColor__Group__3__Impl rule__RGBColor__Group__4 )
            // InternalDotColorListParser.g:590:2: rule__RGBColor__Group__3__Impl rule__RGBColor__Group__4
            {
            pushFollow(FOLLOW_8);
            rule__RGBColor__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__3"


    // $ANTLR start "rule__RGBColor__Group__3__Impl"
    // InternalDotColorListParser.g:597:1: rule__RGBColor__Group__3__Impl : ( ( rule__RGBColor__BAssignment_3 ) ) ;
    public final void rule__RGBColor__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:601:1: ( ( ( rule__RGBColor__BAssignment_3 ) ) )
            // InternalDotColorListParser.g:602:1: ( ( rule__RGBColor__BAssignment_3 ) )
            {
            // InternalDotColorListParser.g:602:1: ( ( rule__RGBColor__BAssignment_3 ) )
            // InternalDotColorListParser.g:603:2: ( rule__RGBColor__BAssignment_3 )
            {
             before(grammarAccess.getRGBColorAccess().getBAssignment_3()); 
            // InternalDotColorListParser.g:604:2: ( rule__RGBColor__BAssignment_3 )
            // InternalDotColorListParser.g:604:3: rule__RGBColor__BAssignment_3
            {
            pushFollow(FOLLOW_2);
            rule__RGBColor__BAssignment_3();

            state._fsp--;


            }

             after(grammarAccess.getRGBColorAccess().getBAssignment_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__3__Impl"


    // $ANTLR start "rule__RGBColor__Group__4"
    // InternalDotColorListParser.g:612:1: rule__RGBColor__Group__4 : rule__RGBColor__Group__4__Impl ;
    public final void rule__RGBColor__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:616:1: ( rule__RGBColor__Group__4__Impl )
            // InternalDotColorListParser.g:617:2: rule__RGBColor__Group__4__Impl
            {
            pushFollow(FOLLOW_2);
            rule__RGBColor__Group__4__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__4"


    // $ANTLR start "rule__RGBColor__Group__4__Impl"
    // InternalDotColorListParser.g:623:1: rule__RGBColor__Group__4__Impl : ( ( rule__RGBColor__AAssignment_4 )? ) ;
    public final void rule__RGBColor__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:627:1: ( ( ( rule__RGBColor__AAssignment_4 )? ) )
            // InternalDotColorListParser.g:628:1: ( ( rule__RGBColor__AAssignment_4 )? )
            {
            // InternalDotColorListParser.g:628:1: ( ( rule__RGBColor__AAssignment_4 )? )
            // InternalDotColorListParser.g:629:2: ( rule__RGBColor__AAssignment_4 )?
            {
             before(grammarAccess.getRGBColorAccess().getAAssignment_4()); 
            // InternalDotColorListParser.g:630:2: ( rule__RGBColor__AAssignment_4 )?
            int alt6=2;
            int LA6_0 = input.LA(1);

            if ( (LA6_0==RULE_HEXADECIMAL_DIGIT) ) {
                alt6=1;
            }
            switch (alt6) {
                case 1 :
                    // InternalDotColorListParser.g:630:3: rule__RGBColor__AAssignment_4
                    {
                    pushFollow(FOLLOW_2);
                    rule__RGBColor__AAssignment_4();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getRGBColorAccess().getAAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__Group__4__Impl"


    // $ANTLR start "rule__HSVColor__Group__0"
    // InternalDotColorListParser.g:639:1: rule__HSVColor__Group__0 : rule__HSVColor__Group__0__Impl rule__HSVColor__Group__1 ;
    public final void rule__HSVColor__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:643:1: ( rule__HSVColor__Group__0__Impl rule__HSVColor__Group__1 )
            // InternalDotColorListParser.g:644:2: rule__HSVColor__Group__0__Impl rule__HSVColor__Group__1
            {
            pushFollow(FOLLOW_9);
            rule__HSVColor__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__0"


    // $ANTLR start "rule__HSVColor__Group__0__Impl"
    // InternalDotColorListParser.g:651:1: rule__HSVColor__Group__0__Impl : ( ( rule__HSVColor__HAssignment_0 ) ) ;
    public final void rule__HSVColor__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:655:1: ( ( ( rule__HSVColor__HAssignment_0 ) ) )
            // InternalDotColorListParser.g:656:1: ( ( rule__HSVColor__HAssignment_0 ) )
            {
            // InternalDotColorListParser.g:656:1: ( ( rule__HSVColor__HAssignment_0 ) )
            // InternalDotColorListParser.g:657:2: ( rule__HSVColor__HAssignment_0 )
            {
             before(grammarAccess.getHSVColorAccess().getHAssignment_0()); 
            // InternalDotColorListParser.g:658:2: ( rule__HSVColor__HAssignment_0 )
            // InternalDotColorListParser.g:658:3: rule__HSVColor__HAssignment_0
            {
            pushFollow(FOLLOW_2);
            rule__HSVColor__HAssignment_0();

            state._fsp--;


            }

             after(grammarAccess.getHSVColorAccess().getHAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__0__Impl"


    // $ANTLR start "rule__HSVColor__Group__1"
    // InternalDotColorListParser.g:666:1: rule__HSVColor__Group__1 : rule__HSVColor__Group__1__Impl rule__HSVColor__Group__2 ;
    public final void rule__HSVColor__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:670:1: ( rule__HSVColor__Group__1__Impl rule__HSVColor__Group__2 )
            // InternalDotColorListParser.g:671:2: rule__HSVColor__Group__1__Impl rule__HSVColor__Group__2
            {
            pushFollow(FOLLOW_9);
            rule__HSVColor__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__1"


    // $ANTLR start "rule__HSVColor__Group__1__Impl"
    // InternalDotColorListParser.g:678:1: rule__HSVColor__Group__1__Impl : ( ( Comma )? ) ;
    public final void rule__HSVColor__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:682:1: ( ( ( Comma )? ) )
            // InternalDotColorListParser.g:683:1: ( ( Comma )? )
            {
            // InternalDotColorListParser.g:683:1: ( ( Comma )? )
            // InternalDotColorListParser.g:684:2: ( Comma )?
            {
             before(grammarAccess.getHSVColorAccess().getCommaKeyword_1()); 
            // InternalDotColorListParser.g:685:2: ( Comma )?
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==Comma) ) {
                alt7=1;
            }
            switch (alt7) {
                case 1 :
                    // InternalDotColorListParser.g:685:3: Comma
                    {
                    match(input,Comma,FOLLOW_2); 

                    }
                    break;

            }

             after(grammarAccess.getHSVColorAccess().getCommaKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__1__Impl"


    // $ANTLR start "rule__HSVColor__Group__2"
    // InternalDotColorListParser.g:693:1: rule__HSVColor__Group__2 : rule__HSVColor__Group__2__Impl rule__HSVColor__Group__3 ;
    public final void rule__HSVColor__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:697:1: ( rule__HSVColor__Group__2__Impl rule__HSVColor__Group__3 )
            // InternalDotColorListParser.g:698:2: rule__HSVColor__Group__2__Impl rule__HSVColor__Group__3
            {
            pushFollow(FOLLOW_9);
            rule__HSVColor__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__2"


    // $ANTLR start "rule__HSVColor__Group__2__Impl"
    // InternalDotColorListParser.g:705:1: rule__HSVColor__Group__2__Impl : ( ( rule__HSVColor__SAssignment_2 ) ) ;
    public final void rule__HSVColor__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:709:1: ( ( ( rule__HSVColor__SAssignment_2 ) ) )
            // InternalDotColorListParser.g:710:1: ( ( rule__HSVColor__SAssignment_2 ) )
            {
            // InternalDotColorListParser.g:710:1: ( ( rule__HSVColor__SAssignment_2 ) )
            // InternalDotColorListParser.g:711:2: ( rule__HSVColor__SAssignment_2 )
            {
             before(grammarAccess.getHSVColorAccess().getSAssignment_2()); 
            // InternalDotColorListParser.g:712:2: ( rule__HSVColor__SAssignment_2 )
            // InternalDotColorListParser.g:712:3: rule__HSVColor__SAssignment_2
            {
            pushFollow(FOLLOW_2);
            rule__HSVColor__SAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getHSVColorAccess().getSAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__2__Impl"


    // $ANTLR start "rule__HSVColor__Group__3"
    // InternalDotColorListParser.g:720:1: rule__HSVColor__Group__3 : rule__HSVColor__Group__3__Impl rule__HSVColor__Group__4 ;
    public final void rule__HSVColor__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:724:1: ( rule__HSVColor__Group__3__Impl rule__HSVColor__Group__4 )
            // InternalDotColorListParser.g:725:2: rule__HSVColor__Group__3__Impl rule__HSVColor__Group__4
            {
            pushFollow(FOLLOW_9);
            rule__HSVColor__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__3"


    // $ANTLR start "rule__HSVColor__Group__3__Impl"
    // InternalDotColorListParser.g:732:1: rule__HSVColor__Group__3__Impl : ( ( Comma )? ) ;
    public final void rule__HSVColor__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:736:1: ( ( ( Comma )? ) )
            // InternalDotColorListParser.g:737:1: ( ( Comma )? )
            {
            // InternalDotColorListParser.g:737:1: ( ( Comma )? )
            // InternalDotColorListParser.g:738:2: ( Comma )?
            {
             before(grammarAccess.getHSVColorAccess().getCommaKeyword_3()); 
            // InternalDotColorListParser.g:739:2: ( Comma )?
            int alt8=2;
            int LA8_0 = input.LA(1);

            if ( (LA8_0==Comma) ) {
                alt8=1;
            }
            switch (alt8) {
                case 1 :
                    // InternalDotColorListParser.g:739:3: Comma
                    {
                    match(input,Comma,FOLLOW_2); 

                    }
                    break;

            }

             after(grammarAccess.getHSVColorAccess().getCommaKeyword_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__3__Impl"


    // $ANTLR start "rule__HSVColor__Group__4"
    // InternalDotColorListParser.g:747:1: rule__HSVColor__Group__4 : rule__HSVColor__Group__4__Impl ;
    public final void rule__HSVColor__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:751:1: ( rule__HSVColor__Group__4__Impl )
            // InternalDotColorListParser.g:752:2: rule__HSVColor__Group__4__Impl
            {
            pushFollow(FOLLOW_2);
            rule__HSVColor__Group__4__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__4"


    // $ANTLR start "rule__HSVColor__Group__4__Impl"
    // InternalDotColorListParser.g:758:1: rule__HSVColor__Group__4__Impl : ( ( rule__HSVColor__VAssignment_4 ) ) ;
    public final void rule__HSVColor__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:762:1: ( ( ( rule__HSVColor__VAssignment_4 ) ) )
            // InternalDotColorListParser.g:763:1: ( ( rule__HSVColor__VAssignment_4 ) )
            {
            // InternalDotColorListParser.g:763:1: ( ( rule__HSVColor__VAssignment_4 ) )
            // InternalDotColorListParser.g:764:2: ( rule__HSVColor__VAssignment_4 )
            {
             before(grammarAccess.getHSVColorAccess().getVAssignment_4()); 
            // InternalDotColorListParser.g:765:2: ( rule__HSVColor__VAssignment_4 )
            // InternalDotColorListParser.g:765:3: rule__HSVColor__VAssignment_4
            {
            pushFollow(FOLLOW_2);
            rule__HSVColor__VAssignment_4();

            state._fsp--;


            }

             after(grammarAccess.getHSVColorAccess().getVAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__Group__4__Impl"


    // $ANTLR start "rule__StringColor__Group__0"
    // InternalDotColorListParser.g:774:1: rule__StringColor__Group__0 : rule__StringColor__Group__0__Impl rule__StringColor__Group__1 ;
    public final void rule__StringColor__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:778:1: ( rule__StringColor__Group__0__Impl rule__StringColor__Group__1 )
            // InternalDotColorListParser.g:779:2: rule__StringColor__Group__0__Impl rule__StringColor__Group__1
            {
            pushFollow(FOLLOW_5);
            rule__StringColor__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StringColor__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group__0"


    // $ANTLR start "rule__StringColor__Group__0__Impl"
    // InternalDotColorListParser.g:786:1: rule__StringColor__Group__0__Impl : ( ( rule__StringColor__Group_0__0 )? ) ;
    public final void rule__StringColor__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:790:1: ( ( ( rule__StringColor__Group_0__0 )? ) )
            // InternalDotColorListParser.g:791:1: ( ( rule__StringColor__Group_0__0 )? )
            {
            // InternalDotColorListParser.g:791:1: ( ( rule__StringColor__Group_0__0 )? )
            // InternalDotColorListParser.g:792:2: ( rule__StringColor__Group_0__0 )?
            {
             before(grammarAccess.getStringColorAccess().getGroup_0()); 
            // InternalDotColorListParser.g:793:2: ( rule__StringColor__Group_0__0 )?
            int alt9=2;
            int LA9_0 = input.LA(1);

            if ( (LA9_0==Solidus) ) {
                alt9=1;
            }
            switch (alt9) {
                case 1 :
                    // InternalDotColorListParser.g:793:3: rule__StringColor__Group_0__0
                    {
                    pushFollow(FOLLOW_2);
                    rule__StringColor__Group_0__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getStringColorAccess().getGroup_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group__0__Impl"


    // $ANTLR start "rule__StringColor__Group__1"
    // InternalDotColorListParser.g:801:1: rule__StringColor__Group__1 : rule__StringColor__Group__1__Impl ;
    public final void rule__StringColor__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:805:1: ( rule__StringColor__Group__1__Impl )
            // InternalDotColorListParser.g:806:2: rule__StringColor__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__StringColor__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group__1"


    // $ANTLR start "rule__StringColor__Group__1__Impl"
    // InternalDotColorListParser.g:812:1: rule__StringColor__Group__1__Impl : ( ( rule__StringColor__NameAssignment_1 ) ) ;
    public final void rule__StringColor__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:816:1: ( ( ( rule__StringColor__NameAssignment_1 ) ) )
            // InternalDotColorListParser.g:817:1: ( ( rule__StringColor__NameAssignment_1 ) )
            {
            // InternalDotColorListParser.g:817:1: ( ( rule__StringColor__NameAssignment_1 ) )
            // InternalDotColorListParser.g:818:2: ( rule__StringColor__NameAssignment_1 )
            {
             before(grammarAccess.getStringColorAccess().getNameAssignment_1()); 
            // InternalDotColorListParser.g:819:2: ( rule__StringColor__NameAssignment_1 )
            // InternalDotColorListParser.g:819:3: rule__StringColor__NameAssignment_1
            {
            pushFollow(FOLLOW_2);
            rule__StringColor__NameAssignment_1();

            state._fsp--;


            }

             after(grammarAccess.getStringColorAccess().getNameAssignment_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group__1__Impl"


    // $ANTLR start "rule__StringColor__Group_0__0"
    // InternalDotColorListParser.g:828:1: rule__StringColor__Group_0__0 : rule__StringColor__Group_0__0__Impl rule__StringColor__Group_0__1 ;
    public final void rule__StringColor__Group_0__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:832:1: ( rule__StringColor__Group_0__0__Impl rule__StringColor__Group_0__1 )
            // InternalDotColorListParser.g:833:2: rule__StringColor__Group_0__0__Impl rule__StringColor__Group_0__1
            {
            pushFollow(FOLLOW_10);
            rule__StringColor__Group_0__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StringColor__Group_0__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__0"


    // $ANTLR start "rule__StringColor__Group_0__0__Impl"
    // InternalDotColorListParser.g:840:1: rule__StringColor__Group_0__0__Impl : ( Solidus ) ;
    public final void rule__StringColor__Group_0__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:844:1: ( ( Solidus ) )
            // InternalDotColorListParser.g:845:1: ( Solidus )
            {
            // InternalDotColorListParser.g:845:1: ( Solidus )
            // InternalDotColorListParser.g:846:2: Solidus
            {
             before(grammarAccess.getStringColorAccess().getSolidusKeyword_0_0()); 
            match(input,Solidus,FOLLOW_2); 
             after(grammarAccess.getStringColorAccess().getSolidusKeyword_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__0__Impl"


    // $ANTLR start "rule__StringColor__Group_0__1"
    // InternalDotColorListParser.g:855:1: rule__StringColor__Group_0__1 : rule__StringColor__Group_0__1__Impl rule__StringColor__Group_0__2 ;
    public final void rule__StringColor__Group_0__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:859:1: ( rule__StringColor__Group_0__1__Impl rule__StringColor__Group_0__2 )
            // InternalDotColorListParser.g:860:2: rule__StringColor__Group_0__1__Impl rule__StringColor__Group_0__2
            {
            pushFollow(FOLLOW_10);
            rule__StringColor__Group_0__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__StringColor__Group_0__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__1"


    // $ANTLR start "rule__StringColor__Group_0__1__Impl"
    // InternalDotColorListParser.g:867:1: rule__StringColor__Group_0__1__Impl : ( ( rule__StringColor__SchemeAssignment_0_1 )? ) ;
    public final void rule__StringColor__Group_0__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:871:1: ( ( ( rule__StringColor__SchemeAssignment_0_1 )? ) )
            // InternalDotColorListParser.g:872:1: ( ( rule__StringColor__SchemeAssignment_0_1 )? )
            {
            // InternalDotColorListParser.g:872:1: ( ( rule__StringColor__SchemeAssignment_0_1 )? )
            // InternalDotColorListParser.g:873:2: ( rule__StringColor__SchemeAssignment_0_1 )?
            {
             before(grammarAccess.getStringColorAccess().getSchemeAssignment_0_1()); 
            // InternalDotColorListParser.g:874:2: ( rule__StringColor__SchemeAssignment_0_1 )?
            int alt10=2;
            int LA10_0 = input.LA(1);

            if ( (LA10_0==RULE_COLOR_STRING) ) {
                alt10=1;
            }
            switch (alt10) {
                case 1 :
                    // InternalDotColorListParser.g:874:3: rule__StringColor__SchemeAssignment_0_1
                    {
                    pushFollow(FOLLOW_2);
                    rule__StringColor__SchemeAssignment_0_1();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getStringColorAccess().getSchemeAssignment_0_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__1__Impl"


    // $ANTLR start "rule__StringColor__Group_0__2"
    // InternalDotColorListParser.g:882:1: rule__StringColor__Group_0__2 : rule__StringColor__Group_0__2__Impl ;
    public final void rule__StringColor__Group_0__2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:886:1: ( rule__StringColor__Group_0__2__Impl )
            // InternalDotColorListParser.g:887:2: rule__StringColor__Group_0__2__Impl
            {
            pushFollow(FOLLOW_2);
            rule__StringColor__Group_0__2__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__2"


    // $ANTLR start "rule__StringColor__Group_0__2__Impl"
    // InternalDotColorListParser.g:893:1: rule__StringColor__Group_0__2__Impl : ( Solidus ) ;
    public final void rule__StringColor__Group_0__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:897:1: ( ( Solidus ) )
            // InternalDotColorListParser.g:898:1: ( Solidus )
            {
            // InternalDotColorListParser.g:898:1: ( Solidus )
            // InternalDotColorListParser.g:899:2: Solidus
            {
             before(grammarAccess.getStringColorAccess().getSolidusKeyword_0_2()); 
            match(input,Solidus,FOLLOW_2); 
             after(grammarAccess.getStringColorAccess().getSolidusKeyword_0_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__Group_0__2__Impl"


    // $ANTLR start "rule__Hex__Group__0"
    // InternalDotColorListParser.g:909:1: rule__Hex__Group__0 : rule__Hex__Group__0__Impl rule__Hex__Group__1 ;
    public final void rule__Hex__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:913:1: ( rule__Hex__Group__0__Impl rule__Hex__Group__1 )
            // InternalDotColorListParser.g:914:2: rule__Hex__Group__0__Impl rule__Hex__Group__1
            {
            pushFollow(FOLLOW_8);
            rule__Hex__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_2);
            rule__Hex__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Hex__Group__0"


    // $ANTLR start "rule__Hex__Group__0__Impl"
    // InternalDotColorListParser.g:921:1: rule__Hex__Group__0__Impl : ( RULE_HEXADECIMAL_DIGIT ) ;
    public final void rule__Hex__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:925:1: ( ( RULE_HEXADECIMAL_DIGIT ) )
            // InternalDotColorListParser.g:926:1: ( RULE_HEXADECIMAL_DIGIT )
            {
            // InternalDotColorListParser.g:926:1: ( RULE_HEXADECIMAL_DIGIT )
            // InternalDotColorListParser.g:927:2: RULE_HEXADECIMAL_DIGIT
            {
             before(grammarAccess.getHexAccess().getHEXADECIMAL_DIGITTerminalRuleCall_0()); 
            match(input,RULE_HEXADECIMAL_DIGIT,FOLLOW_2); 
             after(grammarAccess.getHexAccess().getHEXADECIMAL_DIGITTerminalRuleCall_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Hex__Group__0__Impl"


    // $ANTLR start "rule__Hex__Group__1"
    // InternalDotColorListParser.g:936:1: rule__Hex__Group__1 : rule__Hex__Group__1__Impl ;
    public final void rule__Hex__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:940:1: ( rule__Hex__Group__1__Impl )
            // InternalDotColorListParser.g:941:2: rule__Hex__Group__1__Impl
            {
            pushFollow(FOLLOW_2);
            rule__Hex__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Hex__Group__1"


    // $ANTLR start "rule__Hex__Group__1__Impl"
    // InternalDotColorListParser.g:947:1: rule__Hex__Group__1__Impl : ( RULE_HEXADECIMAL_DIGIT ) ;
    public final void rule__Hex__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:951:1: ( ( RULE_HEXADECIMAL_DIGIT ) )
            // InternalDotColorListParser.g:952:1: ( RULE_HEXADECIMAL_DIGIT )
            {
            // InternalDotColorListParser.g:952:1: ( RULE_HEXADECIMAL_DIGIT )
            // InternalDotColorListParser.g:953:2: RULE_HEXADECIMAL_DIGIT
            {
             before(grammarAccess.getHexAccess().getHEXADECIMAL_DIGITTerminalRuleCall_1()); 
            match(input,RULE_HEXADECIMAL_DIGIT,FOLLOW_2); 
             after(grammarAccess.getHexAccess().getHEXADECIMAL_DIGITTerminalRuleCall_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Hex__Group__1__Impl"


    // $ANTLR start "rule__ColorList__ColorValuesAssignment_0"
    // InternalDotColorListParser.g:963:1: rule__ColorList__ColorValuesAssignment_0 : ( ruleWC ) ;
    public final void rule__ColorList__ColorValuesAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:967:1: ( ( ruleWC ) )
            // InternalDotColorListParser.g:968:2: ( ruleWC )
            {
            // InternalDotColorListParser.g:968:2: ( ruleWC )
            // InternalDotColorListParser.g:969:3: ruleWC
            {
             before(grammarAccess.getColorListAccess().getColorValuesWCParserRuleCall_0_0()); 
            pushFollow(FOLLOW_2);
            ruleWC();

            state._fsp--;

             after(grammarAccess.getColorListAccess().getColorValuesWCParserRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ColorList__ColorValuesAssignment_0"


    // $ANTLR start "rule__ColorList__ColorValuesAssignment_1_1"
    // InternalDotColorListParser.g:978:1: rule__ColorList__ColorValuesAssignment_1_1 : ( ruleWC ) ;
    public final void rule__ColorList__ColorValuesAssignment_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:982:1: ( ( ruleWC ) )
            // InternalDotColorListParser.g:983:2: ( ruleWC )
            {
            // InternalDotColorListParser.g:983:2: ( ruleWC )
            // InternalDotColorListParser.g:984:3: ruleWC
            {
             before(grammarAccess.getColorListAccess().getColorValuesWCParserRuleCall_1_1_0()); 
            pushFollow(FOLLOW_2);
            ruleWC();

            state._fsp--;

             after(grammarAccess.getColorListAccess().getColorValuesWCParserRuleCall_1_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__ColorList__ColorValuesAssignment_1_1"


    // $ANTLR start "rule__WC__ColorAssignment_0"
    // InternalDotColorListParser.g:993:1: rule__WC__ColorAssignment_0 : ( ruleColor ) ;
    public final void rule__WC__ColorAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:997:1: ( ( ruleColor ) )
            // InternalDotColorListParser.g:998:2: ( ruleColor )
            {
            // InternalDotColorListParser.g:998:2: ( ruleColor )
            // InternalDotColorListParser.g:999:3: ruleColor
            {
             before(grammarAccess.getWCAccess().getColorColorParserRuleCall_0_0()); 
            pushFollow(FOLLOW_2);
            ruleColor();

            state._fsp--;

             after(grammarAccess.getWCAccess().getColorColorParserRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__WC__ColorAssignment_0"


    // $ANTLR start "rule__WC__WeightAssignment_1_1"
    // InternalDotColorListParser.g:1008:1: rule__WC__WeightAssignment_1_1 : ( RULE_COLOR_NUMBER ) ;
    public final void rule__WC__WeightAssignment_1_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:1012:1: ( ( RULE_COLOR_NUMBER ) )
            // InternalDotColorListParser.g:1013:2: ( RULE_COLOR_NUMBER )
            {
            // InternalDotColorListParser.g:1013:2: ( RULE_COLOR_NUMBER )
            // InternalDotColorListParser.g:1014:3: RULE_COLOR_NUMBER
            {
             before(grammarAccess.getWCAccess().getWeightCOLOR_NUMBERTerminalRuleCall_1_1_0()); 
            match(input,RULE_COLOR_NUMBER,FOLLOW_2); 
             after(grammarAccess.getWCAccess().getWeightCOLOR_NUMBERTerminalRuleCall_1_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__WC__WeightAssignment_1_1"


    // $ANTLR start "rule__RGBColor__RAssignment_1"
    // InternalDotColorListParser.g:1023:1: rule__RGBColor__RAssignment_1 : ( rulehex ) ;
    public final void rule__RGBColor__RAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:1027:1: ( ( rulehex ) )
            // InternalDotColorListParser.g:1028:2: ( rulehex )
            {
            // InternalDotColorListParser.g:1028:2: ( rulehex )
            // InternalDotColorListParser.g:1029:3: rulehex
            {
             before(grammarAccess.getRGBColorAccess().getRHexParserRuleCall_1_0()); 
            pushFollow(FOLLOW_2);
            rulehex();

            state._fsp--;

             after(grammarAccess.getRGBColorAccess().getRHexParserRuleCall_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__RAssignment_1"


    // $ANTLR start "rule__RGBColor__GAssignment_2"
    // InternalDotColorListParser.g:1038:1: rule__RGBColor__GAssignment_2 : ( rulehex ) ;
    public final void rule__RGBColor__GAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:1042:1: ( ( rulehex ) )
            // InternalDotColorListParser.g:1043:2: ( rulehex )
            {
            // InternalDotColorListParser.g:1043:2: ( rulehex )
            // InternalDotColorListParser.g:1044:3: rulehex
            {
             before(grammarAccess.getRGBColorAccess().getGHexParserRuleCall_2_0()); 
            pushFollow(FOLLOW_2);
            rulehex();

            state._fsp--;

             after(grammarAccess.getRGBColorAccess().getGHexParserRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__GAssignment_2"


    // $ANTLR start "rule__RGBColor__BAssignment_3"
    // InternalDotColorListParser.g:1053:1: rule__RGBColor__BAssignment_3 : ( rulehex ) ;
    public final void rule__RGBColor__BAssignment_3() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:1057:1: ( ( rulehex ) )
            // InternalDotColorListParser.g:1058:2: ( rulehex )
            {
            // InternalDotColorListParser.g:1058:2: ( rulehex )
            // InternalDotColorListParser.g:1059:3: rulehex
            {
             before(grammarAccess.getRGBColorAccess().getBHexParserRuleCall_3_0()); 
            pushFollow(FOLLOW_2);
            rulehex();

            state._fsp--;

             after(grammarAccess.getRGBColorAccess().getBHexParserRuleCall_3_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__BAssignment_3"


    // $ANTLR start "rule__RGBColor__AAssignment_4"
    // InternalDotColorListParser.g:1068:1: rule__RGBColor__AAssignment_4 : ( rulehex ) ;
    public final void rule__RGBColor__AAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:1072:1: ( ( rulehex ) )
            // InternalDotColorListParser.g:1073:2: ( rulehex )
            {
            // InternalDotColorListParser.g:1073:2: ( rulehex )
            // InternalDotColorListParser.g:1074:3: rulehex
            {
             before(grammarAccess.getRGBColorAccess().getAHexParserRuleCall_4_0()); 
            pushFollow(FOLLOW_2);
            rulehex();

            state._fsp--;

             after(grammarAccess.getRGBColorAccess().getAHexParserRuleCall_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__RGBColor__AAssignment_4"


    // $ANTLR start "rule__HSVColor__HAssignment_0"
    // InternalDotColorListParser.g:1083:1: rule__HSVColor__HAssignment_0 : ( RULE_COLOR_NUMBER ) ;
    public final void rule__HSVColor__HAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:1087:1: ( ( RULE_COLOR_NUMBER ) )
            // InternalDotColorListParser.g:1088:2: ( RULE_COLOR_NUMBER )
            {
            // InternalDotColorListParser.g:1088:2: ( RULE_COLOR_NUMBER )
            // InternalDotColorListParser.g:1089:3: RULE_COLOR_NUMBER
            {
             before(grammarAccess.getHSVColorAccess().getHCOLOR_NUMBERTerminalRuleCall_0_0()); 
            match(input,RULE_COLOR_NUMBER,FOLLOW_2); 
             after(grammarAccess.getHSVColorAccess().getHCOLOR_NUMBERTerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__HAssignment_0"


    // $ANTLR start "rule__HSVColor__SAssignment_2"
    // InternalDotColorListParser.g:1098:1: rule__HSVColor__SAssignment_2 : ( RULE_COLOR_NUMBER ) ;
    public final void rule__HSVColor__SAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:1102:1: ( ( RULE_COLOR_NUMBER ) )
            // InternalDotColorListParser.g:1103:2: ( RULE_COLOR_NUMBER )
            {
            // InternalDotColorListParser.g:1103:2: ( RULE_COLOR_NUMBER )
            // InternalDotColorListParser.g:1104:3: RULE_COLOR_NUMBER
            {
             before(grammarAccess.getHSVColorAccess().getSCOLOR_NUMBERTerminalRuleCall_2_0()); 
            match(input,RULE_COLOR_NUMBER,FOLLOW_2); 
             after(grammarAccess.getHSVColorAccess().getSCOLOR_NUMBERTerminalRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__SAssignment_2"


    // $ANTLR start "rule__HSVColor__VAssignment_4"
    // InternalDotColorListParser.g:1113:1: rule__HSVColor__VAssignment_4 : ( RULE_COLOR_NUMBER ) ;
    public final void rule__HSVColor__VAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:1117:1: ( ( RULE_COLOR_NUMBER ) )
            // InternalDotColorListParser.g:1118:2: ( RULE_COLOR_NUMBER )
            {
            // InternalDotColorListParser.g:1118:2: ( RULE_COLOR_NUMBER )
            // InternalDotColorListParser.g:1119:3: RULE_COLOR_NUMBER
            {
             before(grammarAccess.getHSVColorAccess().getVCOLOR_NUMBERTerminalRuleCall_4_0()); 
            match(input,RULE_COLOR_NUMBER,FOLLOW_2); 
             after(grammarAccess.getHSVColorAccess().getVCOLOR_NUMBERTerminalRuleCall_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__HSVColor__VAssignment_4"


    // $ANTLR start "rule__StringColor__SchemeAssignment_0_1"
    // InternalDotColorListParser.g:1128:1: rule__StringColor__SchemeAssignment_0_1 : ( RULE_COLOR_STRING ) ;
    public final void rule__StringColor__SchemeAssignment_0_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:1132:1: ( ( RULE_COLOR_STRING ) )
            // InternalDotColorListParser.g:1133:2: ( RULE_COLOR_STRING )
            {
            // InternalDotColorListParser.g:1133:2: ( RULE_COLOR_STRING )
            // InternalDotColorListParser.g:1134:3: RULE_COLOR_STRING
            {
             before(grammarAccess.getStringColorAccess().getSchemeCOLOR_STRINGTerminalRuleCall_0_1_0()); 
            match(input,RULE_COLOR_STRING,FOLLOW_2); 
             after(grammarAccess.getStringColorAccess().getSchemeCOLOR_STRINGTerminalRuleCall_0_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__SchemeAssignment_0_1"


    // $ANTLR start "rule__StringColor__NameAssignment_1"
    // InternalDotColorListParser.g:1143:1: rule__StringColor__NameAssignment_1 : ( ( rule__StringColor__NameAlternatives_1_0 ) ) ;
    public final void rule__StringColor__NameAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
        	
        try {
            // InternalDotColorListParser.g:1147:1: ( ( ( rule__StringColor__NameAlternatives_1_0 ) ) )
            // InternalDotColorListParser.g:1148:2: ( ( rule__StringColor__NameAlternatives_1_0 ) )
            {
            // InternalDotColorListParser.g:1148:2: ( ( rule__StringColor__NameAlternatives_1_0 ) )
            // InternalDotColorListParser.g:1149:3: ( rule__StringColor__NameAlternatives_1_0 )
            {
             before(grammarAccess.getStringColorAccess().getNameAlternatives_1_0()); 
            // InternalDotColorListParser.g:1150:3: ( rule__StringColor__NameAlternatives_1_0 )
            // InternalDotColorListParser.g:1150:4: rule__StringColor__NameAlternatives_1_0
            {
            pushFollow(FOLLOW_2);
            rule__StringColor__NameAlternatives_1_0();

            state._fsp--;


            }

             after(grammarAccess.getStringColorAccess().getNameAlternatives_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__StringColor__NameAssignment_1"

    // Delegated rules


 

    public static final BitSet FOLLOW_1 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_2 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_3 = new BitSet(new long[]{0x0000000000000080L});
    public static final BitSet FOLLOW_4 = new BitSet(new long[]{0x0000000000000082L});
    public static final BitSet FOLLOW_5 = new BitSet(new long[]{0x0000000000003850L});
    public static final BitSet FOLLOW_6 = new BitSet(new long[]{0x0000000000000100L});
    public static final BitSet FOLLOW_7 = new BitSet(new long[]{0x0000000000000800L});
    public static final BitSet FOLLOW_8 = new BitSet(new long[]{0x0000000000001000L});
    public static final BitSet FOLLOW_9 = new BitSet(new long[]{0x0000000000000820L});
    public static final BitSet FOLLOW_10 = new BitSet(new long[]{0x0000000000002040L});

}