/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.actions;

import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Parent;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.handlers.PanningSupport;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.policies.ViewportPolicy;
import org.eclipse.gef.mvc.fx.ui.actions.AbstractViewerAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;

public abstract class AbstractScrollAction
extends AbstractViewerAction {
    private PanningSupport panningSupport = new PanningSupport();

    protected AbstractScrollAction(String text) {
        super(text, 1, null);
    }

    protected AbstractScrollAction(String text, int style, ImageDescriptor imageDescriptor) {
        super(text, style, imageDescriptor);
    }

    @Override
    protected ITransactionalOperation createOperation(Event event) {
        InfiniteCanvas infiniteCanvas = this.getInfiniteCanvas();
        if (infiniteCanvas == null) {
            throw new IllegalStateException("Cannot perform ResetZoomAction, because no InfiniteCanvas can be determiend.");
        }
        Bounds contentBounds = infiniteCanvas.getContentBounds();
        Point contentPivot = this.determinePivotPoint(contentBounds);
        Bounds viewportBounds = Geometry2FX.toFXBounds((Rectangle)new Rectangle(0.0, 0.0, infiniteCanvas.getWidth(), infiniteCanvas.getHeight()));
        Point viewportPivot = this.determinePivotPoint(viewportBounds);
        ViewportPolicy viewportPolicy = (ViewportPolicy)this.getViewer().getRootPart().getAdapter(ViewportPolicy.class);
        if (viewportPolicy == null) {
            throw new IllegalStateException("Cannot perform AbstractScrollAction, because no ViewportPolicy can be determined for the root part.");
        }
        viewportPolicy.init();
        if (this.isContentRestricted()) {
            this.panningSupport.removeFreeSpace(viewportPolicy, Pos.TOP_LEFT, true);
        }
        viewportPolicy.scroll(false, viewportPivot.x - contentPivot.x, viewportPivot.y - contentPivot.y);
        if (this.isContentRestricted()) {
            this.panningSupport.removeFreeSpace(viewportPolicy, Pos.BOTTOM_RIGHT, false);
        }
        return viewportPolicy.commit();
    }

    protected abstract Point determinePivotPoint(Bounds var1);

    protected InfiniteCanvas getInfiniteCanvas() {
        Parent canvas = this.getViewer().getCanvas();
        if (canvas instanceof InfiniteCanvas) {
            return (InfiniteCanvas)canvas;
        }
        return null;
    }

    protected boolean isContentRestricted() {
        return false;
    }
}

