/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.internal.archetype.ArchetypeCatalogFactory;
import org.eclipse.m2e.core.internal.builder.IIncrementalBuildFramework;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionReader {
    private static final Logger log = LoggerFactory.getLogger(ExtensionReader.class);
    public static final String EXTENSION_ARCHETYPES = "org.eclipse.m2e.core.archetypeCatalogs";
    public static final String EXTENSION_PROJECT_CHANGED_EVENT_LISTENERS = "org.eclipse.m2e.core.mavenProjectChangedListeners";
    public static final String EXTENSION_INCREMENTAL_BUILD_FRAMEWORKS = "org.eclipse.m2e.core.incrementalBuildFrameworks";
    private static final String ELEMENT_LOCAL_ARCHETYPE = "local";
    private static final String ELEMENT_REMOTE_ARCHETYPE = "remote";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_URL = "url";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ELEMENT_LISTENER = "listener";

    public static List<ArchetypeCatalogFactory> readArchetypeExtensions() {
        ArrayList<ArchetypeCatalogFactory> archetypeCatalogs = new ArrayList<ArchetypeCatalogFactory>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint archetypesExtensionPoint = registry.getExtensionPoint(EXTENSION_ARCHETYPES);
        if (archetypesExtensionPoint != null) {
            IExtension[] archetypesExtensions;
            IExtension[] iExtensionArray = archetypesExtensions = archetypesExtensionPoint.getExtensions();
            int n = archetypesExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                IContributor contributor = extension.getContributor();
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    ArchetypeCatalogFactory factory = ExtensionReader.readArchetypeCatalogs(element, contributor);
                    archetypeCatalogs.add(factory);
                    ++n4;
                }
                ++n2;
            }
        }
        return archetypeCatalogs;
    }

    private static ArchetypeCatalogFactory readArchetypeCatalogs(IConfigurationElement element, IContributor contributor) {
        String url;
        if (ELEMENT_LOCAL_ARCHETYPE.equals(element.getName())) {
            String name = element.getAttribute(ATTR_NAME);
            if (name != null) {
                Bundle[] bundles = Platform.getBundles((String)contributor.getName(), null);
                URL catalogUrl = null;
                Bundle[] bundleArray = bundles;
                int n = bundles.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundle = bundleArray[n2];
                    catalogUrl = bundle.getEntry(name);
                    if (catalogUrl != null) {
                        String description = element.getAttribute(ATTR_DESCRIPTION);
                        String url2 = catalogUrl.toString();
                        return new ArchetypeCatalogFactory.LocalCatalogFactory(url2, description, false);
                    }
                    ++n2;
                }
                log.error("Unable to find Archetype catalog " + name + " in " + contributor.getName());
            }
        } else if (ELEMENT_REMOTE_ARCHETYPE.equals(element.getName()) && (url = element.getAttribute(ATTR_URL)) != null) {
            String description = element.getAttribute(ATTR_DESCRIPTION);
            return new ArchetypeCatalogFactory.RemoteCatalogFactory(url, description, false);
        }
        return null;
    }

    public static List<IMavenProjectChangedListener> readProjectChangedEventListenerExtentions() {
        ArrayList<IMavenProjectChangedListener> listeners = new ArrayList<IMavenProjectChangedListener>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint mappingsExtensionPoint = registry.getExtensionPoint(EXTENSION_PROJECT_CHANGED_EVENT_LISTENERS);
        if (mappingsExtensionPoint != null) {
            IExtension[] mappingsExtensions;
            IExtension[] iExtensionArray = mappingsExtensions = mappingsExtensionPoint.getExtensions();
            int n = mappingsExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (ELEMENT_LISTENER.equals(element.getName())) {
                        try {
                            listeners.add((IMavenProjectChangedListener)element.createExecutableExtension("class"));
                        }
                        catch (CoreException ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return listeners;
    }

    public static List<IIncrementalBuildFramework> readIncrementalBuildFrameworks() {
        ArrayList<IIncrementalBuildFramework> frameworks = new ArrayList<IIncrementalBuildFramework>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint mappingsExtensionPoint = registry.getExtensionPoint(EXTENSION_INCREMENTAL_BUILD_FRAMEWORKS);
        if (mappingsExtensionPoint != null) {
            IExtension[] mappingsExtensions;
            IExtension[] iExtensionArray = mappingsExtensions = mappingsExtensionPoint.getExtensions();
            int n = mappingsExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("framework".equals(element.getName())) {
                        try {
                            frameworks.add((IIncrementalBuildFramework)element.createExecutableExtension("class"));
                        }
                        catch (CoreException ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return frameworks;
    }
}

