/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteMarkerTypeDefinition;

public class SystemRemoteMarkerTypeDefinitionCache {
    protected HashMap definitions;
    protected HashMap lookup;

    public SystemRemoteMarkerTypeDefinitionCache() {
        this.initializeCache();
    }

    private void initializeCache() {
        this.loadDefinitions();
        this.lookup = new HashMap(this.definitions.size());
        Iterator i = this.definitions.keySet().iterator();
        while (i.hasNext()) {
            this.computeSuperTypes((String)i.next());
        }
    }

    private void loadDefinitions() {
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.rse.ui", "remoteMarkers");
        IExtension[] types = point.getExtensions();
        this.definitions = new HashMap(types.length);
        int i = 0;
        while (i < types.length) {
            this.definitions.put(types[i].getUniqueIdentifier(), new SystemRemoteMarkerTypeDefinition(types[i]));
            ++i;
        }
    }

    private void computeSuperTypes(String id) {
        HashSet<String> entry = new HashSet<String>(5);
        ArrayList<String> queue = new ArrayList<String>(5);
        queue.add(id);
        while (!queue.isEmpty()) {
            Set newEntries;
            String type = (String)queue.remove(0);
            entry.add(type);
            SystemRemoteMarkerTypeDefinition def = (SystemRemoteMarkerTypeDefinition)this.definitions.get(type);
            if (def == null || (newEntries = def.getSuperTypes()) == null) continue;
            queue.addAll(newEntries);
        }
        this.lookup.put(id, entry);
    }

    public boolean isPersistent(String type) {
        SystemRemoteMarkerTypeDefinition def = (SystemRemoteMarkerTypeDefinition)this.definitions.get(type);
        return def != null && def.isPersistent();
    }

    public boolean isSubtype(String type, String superType) {
        Set entry = (Set)this.lookup.get(type);
        return entry != null && entry.contains(superType);
    }
}

