/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.extensions.Activator;
import org.eclipse.swtchart.extensions.preferences.PreferenceInitializer;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ResourceSupport {
    public static final String ICON_SET_RANGE = "set_range.gif";
    public static final String ICON_HIDE = "hide.gif";
    public static final String ICON_RESET = "reset.gif";
    public static final String ICON_CHECKED = "checked.gif";
    public static final String ICON_UNCHECKED = "unchecked.gif";
    public static final String ICON_LEGEND = "legend.gif";
    public static final String ICON_SORT_ENABLED = "sort.gif";
    public static final String ICON_SORT_DISABLED = "sort_disabled.gif";
    public static final String ICON_POSITION = "position.gif";
    public static final String ICON_SETTINGS = "preferences.gif";
    public static final String ICON_MAPPINGS = "mappings.gif";
    public static final String ICON_DELETE = "delete.gif";
    public static final String ICON_DELETE_ALL = "deleteAll.gif";
    public static final String ARROW_LEFT = "arrowLeft.gif";
    public static final String ARROW_RIGHT = "arrowRight.gif";
    public static final String ARROW_UP = "arrowUp.gif";
    public static final String ARROW_DOWN = "arrowDown.gif";
    public static final String ICON_SERIES_MARKER = "seriesMarker.gif";
    public static final String ICON_IMPORT = "import.gif";
    public static final String ICON_EXPORT = "export.gif";
    public static final String ICON_RESET_SELECTED = "resetSelected.gif";
    public static final String ICON_RESET_ALL = "resetAll.gif";
    private static final Map<RGB, Color> colorMap = new HashMap<RGB, Color>();
    private static final String RGB_DELIMITER = ",";
    private static final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private static IPreferenceStore preferenceStore = null;
    private static ImageRegistry imageRegistry = null;

    private ResourceSupport() {
    }

    public static Color getColorDefault() {
        return Display.getDefault().getSystemColor(3);
    }

    public static Color getColor(String color) {
        String[] values;
        if (color != null && !color.isEmpty() && (values = color.split(RGB_DELIMITER)).length == 3) {
            int red = Integer.parseInt(values[0]);
            int green = Integer.parseInt(values[1]);
            int blue = Integer.parseInt(values[2]);
            return ResourceSupport.getColor(new RGB(red, green, blue));
        }
        return ResourceSupport.getColorDefault();
    }

    public static String getColor(Color color) {
        if (color == null) {
            color = ResourceSupport.getColorDefault();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(color.getRed());
        builder.append(RGB_DELIMITER);
        builder.append(color.getGreen());
        builder.append(RGB_DELIMITER);
        builder.append(color.getBlue());
        return builder.toString();
    }

    public static Color getColor(RGB rgb) {
        Color color = colorMap.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getDefault(), rgb);
            colorMap.put(rgb, color);
        }
        return color;
    }

    public static Color getColor(int red, int green, int blue) {
        RGB rgb = new RGB(red, green, blue);
        return ResourceSupport.getColor(rgb);
    }

    public static IPreferenceStore getPreferenceStore() {
        if (preferenceStore == null) {
            try {
                preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getDefault().getBundle().getSymbolicName());
            }
            catch (Exception e) {
                String filename = String.valueOf(System.getProperty("user.home")) + File.separator + ".eclipseswtchartsettings";
                preferenceStore = new PreferenceStore(filename);
                PreferenceInitializer preferenceInitializer = new PreferenceInitializer();
                preferenceInitializer.initializeDefaultPreferences();
            }
        }
        return preferenceStore;
    }

    public static Image getImage(String key) {
        if (imageRegistry == null) {
            imageRegistry = ResourceSupport.initializeImageRegistry();
        }
        return resourceManager.createImage(imageRegistry.getDescriptor(key));
    }

    protected void finalize() throws Throwable {
        for (Color color : colorMap.values()) {
            if (color == null) continue;
            color.dispose();
        }
        super.finalize();
    }

    private static ImageRegistry initializeImageRegistry() {
        if (Display.getCurrent() == null) {
            throw new SWTException(22);
        }
        imageRegistry = new ImageRegistry();
        HashSet<String> imageSet = new HashSet<String>();
        imageSet.add(ICON_SET_RANGE);
        imageSet.add(ICON_HIDE);
        imageSet.add(ICON_RESET);
        imageSet.add(ICON_CHECKED);
        imageSet.add(ICON_UNCHECKED);
        imageSet.add(ICON_LEGEND);
        imageSet.add(ICON_SORT_ENABLED);
        imageSet.add(ICON_SORT_DISABLED);
        imageSet.add(ICON_POSITION);
        imageSet.add(ICON_SETTINGS);
        imageSet.add(ICON_MAPPINGS);
        imageSet.add(ICON_DELETE);
        imageSet.add(ICON_DELETE_ALL);
        imageSet.add(ARROW_LEFT);
        imageSet.add(ARROW_RIGHT);
        imageSet.add(ARROW_UP);
        imageSet.add(ARROW_DOWN);
        imageSet.add(ICON_SERIES_MARKER);
        imageSet.add(ICON_IMPORT);
        imageSet.add(ICON_EXPORT);
        imageSet.add(ICON_RESET_SELECTED);
        imageSet.add(ICON_RESET_ALL);
        for (String image : imageSet) {
            imageRegistry.put(image, ResourceSupport.createImageDescriptor(image));
        }
        return imageRegistry;
    }

    private static ImageDescriptor createImageDescriptor(String fileName) {
        URL url = ResourceSupport.class.getResource("/resources/icons/16x16/" + fileName);
        return ImageDescriptor.createFromURL((URL)url);
    }
}

