/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density2;

import com.google.common.annotations.VisibleForTesting;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ILegend;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.model.CartesianSeriesModel;
import org.eclipse.swtchart.model.DoubleArraySeriesModel;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density2.AbstractSegmentStoreDensityView;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density2.ISegmentStoreDensityViewerDataListener;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density2.Messages;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2.MouseDragZoomProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2.MouseSelectionProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2.SimpleTooltipProvider;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.table.SegmentStoreContentProvider;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.segmentstore.core.SegmentComparators;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.viewers.IImageSave;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.AxisRange;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;

public abstract class AbstractSegmentStoreDensityViewer
extends TmfViewer
implements IImageSave {
    private static final Format DENSITY_TIME_FORMATTER = SubSecondTimeWithUnitFormat.getInstance();
    private static final RGB BAR_COLOR = new RGB(66, 133, 244);
    private static final ColorRegistry COLOR_REGISTRY = new ColorRegistry();
    private static final RotatingPaletteProvider PALETTE = new RotatingPaletteProvider.Builder().setSaturation(0.73f).setBrightness(0.957f).setNbColors(60).build();
    private TimeGraphColorScheme fColorScheme = new TimeGraphColorScheme();
    private final Chart fChart;
    private final MouseDragZoomProvider fDragZoomProvider;
    private final MouseSelectionProvider fDragProvider;
    private final SimpleTooltipProvider fTooltipProvider;
    private @Nullable ITmfTrace fTrace;
    private Map<@NonNull String, @NonNull IAnalysisProgressListener> fProgressListeners = new HashMap<String, IAnalysisProgressListener>();
    private final Map<@NonNull String, @NonNull ISegmentStoreProvider> fSegmentStoreProviders = new HashMap<String, ISegmentStoreProvider>();
    private AxisRange fCurrentDurationRange = new AxisRange(((Double)AbstractSegmentStoreDensityView.DEFAULT_RANGE.getFirst()).doubleValue(), ((Double)AbstractSegmentStoreDensityView.DEFAULT_RANGE.getSecond()).doubleValue());
    private TmfTimeRange fCurrentTimeRange = TmfTimeRange.NULL_RANGE;
    private final List<ISegmentStoreDensityViewerDataListener> fListeners;
    private int fOverrideNbPoints;
    private String fSeriesType;
    private final Set<@NonNull ITmfTrace> fTraces = new HashSet<ITmfTrace>();

    public AbstractSegmentStoreDensityViewer(Composite parent) {
        super(parent);
        this.fListeners = new ArrayList<ISegmentStoreDensityViewerDataListener>();
        this.fChart = new Chart(parent, 0);
        Color backgroundColor = this.fColorScheme.getColor(38);
        this.fChart.setBackground(backgroundColor);
        backgroundColor = this.fColorScheme.getColor(32);
        this.fChart.getPlotArea().setBackground(backgroundColor);
        parent.setBackground(backgroundColor);
        Color foregroundColor = this.fColorScheme.getColor(39);
        this.fChart.setForeground(foregroundColor);
        this.fChart.getLegend().setVisible(false);
        this.fChart.getTitle().setVisible(false);
        IAxis xAxis = this.fChart.getAxisSet().getXAxis(0);
        IAxis yAxis = this.fChart.getAxisSet().getYAxis(0);
        xAxis.getTitle().setText(NonNullUtils.nullToEmptyString((Object)Messages.AbstractSegmentStoreDensityViewer_TimeAxisLabel));
        yAxis.getTitle().setText(NonNullUtils.nullToEmptyString((Object)Messages.AbstractSegmentStoreDensityViewer_CountAxisLabel));
        xAxis.getTitle().setForeground(foregroundColor);
        yAxis.getTitle().setForeground(foregroundColor);
        xAxis.getTick().setForeground(foregroundColor);
        yAxis.getTick().setForeground(foregroundColor);
        xAxis.getGrid().setStyle(LineStyle.DOT);
        yAxis.getGrid().setStyle(LineStyle.DOT);
        this.fSeriesType = "bar";
        this.fDragZoomProvider = new MouseDragZoomProvider(this);
        this.fDragProvider = new MouseSelectionProvider(this);
        this.fTooltipProvider = new SimpleTooltipProvider(this);
        this.fChart.addDisposeListener(e -> this.internalDispose());
    }

    protected abstract @Nullable ISegmentStoreProvider getSegmentStoreProvider(ITmfTrace var1);

    private static @Nullable ITmfTrace getTrace() {
        return TmfTraceManager.getInstance().getActiveTrace();
    }

    protected void setType(String type) {
        switch (type) {
            case "bar": {
                this.fSeriesType = "bar";
                break;
            }
            case "area": {
                this.fSeriesType = "area";
                break;
            }
        }
    }

    private synchronized void updateDisplay(String name, SegmentStoreContentProvider.SegmentStoreWithRange<ISegment> data) {
        int preWidth;
        ISeries<Integer> series = this.fSeriesType.equals("bar") ? this.createSeries() : this.createAreaSeries(name);
        int barWidth = 4;
        int n = preWidth = this.fOverrideNbPoints == 0 ? this.fChart.getPlotArea().getSize().x / barWidth : this.fOverrideNbPoints;
        if (!this.fSeriesType.equals("bar")) {
            preWidth += 2;
        }
        int width = preWidth;
        double[] xOrigSeries = new double[width];
        double[] yOrigSeries = new double[width];
        Arrays.fill(yOrigSeries, Double.MIN_VALUE);
        data.setComparator(SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
        ISegment maxSegment = data.getElement(Long.MIN_VALUE);
        long maxLength = Long.MIN_VALUE;
        if (maxSegment != null) {
            maxLength = maxSegment.getLength();
        } else {
            for (ISegment segment : data) {
                maxLength = Math.max(maxLength, segment.getLength());
            }
            if (maxLength == Long.MIN_VALUE) {
                maxLength = 1L;
            }
        }
        double maxFactor = 1.0 / ((double)maxLength + 1.0);
        long minX = Long.MAX_VALUE;
        for (ISegment segment : data) {
            double xBox = (double)segment.getLength() * maxFactor * (double)width;
            if (yOrigSeries[(int)xBox] < 1.0) {
                yOrigSeries[(int)xBox] = 1.0;
            } else {
                int n2 = (int)xBox;
                yOrigSeries[n2] = yOrigSeries[n2] + 1.0;
            }
            minX = Math.min(minX, segment.getLength());
        }
        double timeWidth = (double)maxLength / (double)width;
        int i = 0;
        while (i < width) {
            xOrigSeries[i] = (double)i * timeWidth;
            if (!this.fSeriesType.equals("bar")) {
                int n3 = i;
                xOrigSeries[n3] = xOrigSeries[n3] + timeWidth / 2.0;
            }
            ++i;
        }
        double maxY = Double.NEGATIVE_INFINITY;
        int i2 = 0;
        while (i2 < width) {
            maxY = Math.max(maxY, yOrigSeries[i2]);
            ++i2;
        }
        if (minX == maxLength) {
            ++maxLength;
            --minX;
        }
        series.setDataModel((CartesianSeriesModel)new DoubleArraySeriesModel(xOrigSeries, yOrigSeries));
        IAxis xAxis = this.fChart.getAxisSet().getXAxis(0);
        AxisRange currentDurationRange = this.fCurrentDurationRange;
        if (Double.isFinite(currentDurationRange.getLower()) && Double.isFinite(currentDurationRange.getUpper())) {
            xAxis.setRange(new Range(currentDurationRange.getLower(), currentDurationRange.getUpper()));
        } else {
            xAxis.adjustRange();
        }
        xAxis.getTick().setFormat(DENSITY_TIME_FORMATTER);
        ILegend legend = this.fChart.getLegend();
        legend.setVisible(this.fSegmentStoreProviders.size() > 1);
        legend.setPosition(1024);
        ISeries[] iSeriesArray = this.fChart.getSeriesSet().getSeries();
        int n4 = iSeriesArray.length;
        int n5 = 0;
        while (n5 < n4) {
            ISeries internalSeries = iSeriesArray[n5];
            maxY = Math.max(maxY, internalSeries.getDataModel().getMaxY().doubleValue());
            ++n5;
        }
        this.fChart.getAxisSet().getYAxis(0).setRange(new Range(0.9, Math.max(1.0, maxY)));
        this.fChart.getAxisSet().getYAxis(0).enableLogScale(true);
        this.fChart.redraw();
        new Thread(() -> {
            for (ISegmentStoreDensityViewerDataListener l : this.fListeners) {
                l.chartUpdated();
            }
        }).start();
    }

    private ISeries<Integer> createSeries() {
        IBarSeries series = (IBarSeries)this.fChart.getSeriesSet().createSeries(ISeries.SeriesType.BAR, Messages.AbstractSegmentStoreDensityViewer_SeriesLabel);
        series.setVisible(true);
        series.setBarPadding(0);
        series.setBarColor(AbstractSegmentStoreDensityViewer.getColorForRGB(BAR_COLOR));
        return series;
    }

    private ISeries<Integer> createAreaSeries(String name) {
        ILineSeries series = (ILineSeries)this.fChart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, name);
        series.setVisible(true);
        series.enableStep(true);
        series.enableArea(true);
        series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        RGB rgb = this.getColorForItem(name);
        Color color = AbstractSegmentStoreDensityViewer.getColorForRGB(rgb);
        series.setLineColor(color);
        return series;
    }

    private static Color getColorForRGB(RGB rgb) {
        String rgbString = rgb.toString();
        Color color = COLOR_REGISTRY.get(rgbString);
        if (color == null) {
            COLOR_REGISTRY.put(rgbString, rgb);
            color = Objects.requireNonNull(COLOR_REGISTRY.get(rgbString));
        }
        return color;
    }

    public RGB getColorForItem(String name) {
        if (this.fSegmentStoreProviders.size() == 1) {
            return BAR_COLOR;
        }
        Set<String> keys = this.fSegmentStoreProviders.keySet();
        int i = 0;
        for (String key : keys) {
            if (key.equals(name)) break;
            ++i;
        }
        float pos = (float)i / (float)keys.size();
        int index = Math.max((int)((float)PALETTE.getNbColors() * pos), 0) % PALETTE.getNbColors();
        return Objects.requireNonNull(RGBAUtil.fromRGBAColor((RGBAColor)((RGBAColor)AbstractSegmentStoreDensityViewer.PALETTE.get().get((int)index))).rgb);
    }

    public Chart getControl() {
        return this.fChart;
    }

    public void select(AxisRange durationRange) {
        this.fCurrentDurationRange = durationRange;
        TmfTimeRange timeRange = this.fCurrentTimeRange;
        this.computeDataAsync(timeRange, durationRange).thenAccept(data -> {
            List<ISegmentStoreDensityViewerDataListener> list = this.fListeners;
            synchronized (list) {
                if (this.fCurrentTimeRange.equals((Object)timeRange) && this.fCurrentDurationRange.equals(durationRange)) {
                    for (ISegmentStoreDensityViewerDataListener listener : this.fListeners) {
                        for (SegmentStoreContentProvider.SegmentStoreWithRange value : data.values()) {
                            listener.selectedDataChanged(value);
                        }
                    }
                }
            }
        });
    }

    public void zoom(AxisRange durationRange) {
        this.fCurrentDurationRange = durationRange;
        TmfTimeRange timeRange = this.fCurrentTimeRange;
        this.computeDataAsync(timeRange, durationRange).thenAccept(data -> {
            List<ISegmentStoreDensityViewerDataListener> list = this.fListeners;
            synchronized (list) {
                if (this.fCurrentTimeRange.equals((Object)timeRange) && this.fCurrentDurationRange.equals(durationRange)) {
                    this.applyData((Map<String, SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>>)data);
                }
            }
        });
    }

    private CompletableFuture<Map<String, SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>>> computeDataAsync(TmfTimeRange timeRange, AxisRange durationRange) {
        return CompletableFuture.supplyAsync(() -> this.computeData(timeRange, durationRange));
    }

    private @Nullable Map<String, SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>> computeData(TmfTimeRange timeRange, AxisRange durationRange) {
        HashMap<String, SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>> retVal = new HashMap<String, SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>>();
        for (Map.Entry<String, ISegmentStoreProvider> entry : this.fSegmentStoreProviders.entrySet()) {
            ISegmentStoreProvider segmentProvider = Objects.requireNonNull(entry.getValue());
            ISegmentStore segStore = segmentProvider.getSegmentStore();
            if (segStore == null) continue;
            if (durationRange.getLower() > Double.MIN_VALUE || durationRange.getUpper() < Double.MAX_VALUE) {
                Predicate<ISegment> predicate = segment -> (double)segment.getLength() >= durationRange.getLower() && (double)segment.getLength() <= durationRange.getUpper();
                retVal.put(entry.getKey(), new SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>(segStore, timeRange, predicate));
                continue;
            }
            retVal.put(entry.getKey(), new SegmentStoreContentProvider.SegmentStoreWithRange(segStore, timeRange));
        }
        return retVal;
    }

    private void applyData(Map<String, SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>> map) {
        Set<Map.Entry<String, SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>>> entrySet = map.entrySet();
        entrySet.parallelStream().forEach(entry -> {
            SegmentStoreContentProvider.SegmentStoreWithRange data = Objects.requireNonNull((SegmentStoreContentProvider.SegmentStoreWithRange)entry.getValue());
            data.setComparator(SegmentComparators.INTERVAL_LENGTH_COMPARATOR);
            Display.getDefault().asyncExec(() -> this.updateDisplay((String)entry.getKey(), data));
            if (this.fSegmentStoreProviders.size() > 1) {
                this.setType("area");
            } else {
                this.setType("bar");
            }
            for (ISegmentStoreDensityViewerDataListener l : this.fListeners) {
                l.viewDataChanged(data);
            }
        });
    }

    @VisibleForTesting
    public void setSegmentProvider(@Nullable ISegmentStoreProvider ssp) {
        this.fSegmentStoreProviders.clear();
        if (ssp != null) {
            this.fSegmentStoreProviders.put("", ssp);
        }
    }

    @TmfSignalHandler
    public void windowRangeUpdated(@Nullable TmfWindowRangeUpdatedSignal signal) {
        if (signal == null) {
            return;
        }
        ITmfTrace parent = AbstractSegmentStoreDensityViewer.getTrace();
        if (parent == null) {
            return;
        }
        this.fCurrentTimeRange = (TmfTimeRange)NonNullUtils.checkNotNull((Object)signal.getCurrentRange());
        this.updateWindowRange(this.fCurrentTimeRange, false);
        this.updateWithRange(this.fCurrentTimeRange);
    }

    @VisibleForTesting
    public void updateWithRange(TmfTimeRange timeRange) {
        AxisRange durationRange;
        this.fCurrentTimeRange = timeRange;
        this.fCurrentDurationRange = durationRange = AbstractSegmentStoreDensityViewer.getDefaultRange();
        this.computeDataAsync(timeRange, durationRange).thenAccept(data -> {
            List<ISegmentStoreDensityViewerDataListener> list = this.fListeners;
            synchronized (list) {
                if (this.fCurrentTimeRange.equals((Object)timeRange) && this.fCurrentDurationRange.equals(durationRange)) {
                    this.applyData((Map<String, SegmentStoreContentProvider.SegmentStoreWithRange<ISegment>>)data);
                }
            }
        });
    }

    public void refresh() {
        this.fChart.redraw();
    }

    public void dispose() {
        if (!this.fChart.isDisposed()) {
            this.fChart.dispose();
        }
    }

    private void internalDispose() {
        this.fSegmentStoreProviders.entrySet().forEach(entry -> {
            IAnalysisProgressListener listener = this.fProgressListeners.get(entry.getKey());
            if (listener != null) {
                Objects.requireNonNull((ISegmentStoreProvider)entry.getValue()).removeListener(listener);
            }
        });
        this.fTooltipProvider.dispose();
        this.fProgressListeners.clear();
        this.fDragZoomProvider.dispose();
        this.fDragProvider.dispose();
        super.dispose();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        if (this.fTrace != signal.getTrace()) {
            this.loadTrace(AbstractSegmentStoreDensityViewer.getTrace());
            this.fTrace = signal.getTrace();
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (this.fTrace != signal.getTrace()) {
            this.loadTrace(AbstractSegmentStoreDensityViewer.getTrace());
            this.fTrace = signal.getTrace();
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() != this.fTrace) {
            return;
        }
        this.fTrace = null;
        this.clearContent();
    }

    protected void loadTrace(@Nullable ITmfTrace trace) {
        this.clearContent();
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        TmfTimeRange windowRange = ctx.getWindowRange();
        this.innerLoadTrace(trace);
        this.updateWindowRange(windowRange, true);
        this.fTrace = trace;
        this.fCurrentTimeRange = windowRange;
        this.zoom(AbstractSegmentStoreDensityViewer.getDefaultRange());
    }

    private void innerLoadTrace(@Nullable ITmfTrace trace) {
        HashSet<ISegmentStoreProvider> sps = new HashSet<ISegmentStoreProvider>();
        if (trace != null) {
            boolean newTrace;
            boolean bl = newTrace = !Objects.equals(trace, this.fTrace) || this.fSegmentStoreProviders.isEmpty();
            if (newTrace) {
                this.fTraces.clear();
                this.fSegmentStoreProviders.clear();
                for (ITmfTrace child : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
                    this.fTraces.add(child);
                    ISegmentStoreProvider segmentStoreProvider = this.getSegmentStoreProvider(child);
                    String name = child.getName();
                    if (segmentStoreProvider == null || name == null) continue;
                    this.fSegmentStoreProviders.put(name, segmentStoreProvider);
                    sps.add(segmentStoreProvider);
                }
                ISegmentStoreProvider segmentStoreProvider = this.getSegmentStoreProvider(trace);
                String name = trace.getName();
                if (segmentStoreProvider != null && name != null && !sps.contains(segmentStoreProvider)) {
                    this.fSegmentStoreProviders.put(name, segmentStoreProvider);
                }
            }
        }
    }

    private void updateWindowRange(TmfTimeRange windowRange, boolean updateListeners) {
        for (Map.Entry<String, ISegmentStoreProvider> entry : this.fSegmentStoreProviders.entrySet()) {
            ISegmentStoreProvider provider = Objects.requireNonNull(entry.getValue());
            if (updateListeners) {
                IAnalysisProgressListener listener = (segmentProvider, data) -> this.updateWithRange(windowRange);
                provider.addListener(listener);
                this.fProgressListeners.put(entry.getKey(), listener);
            }
            if (!(provider instanceof IAnalysisModule)) continue;
            ((IAnalysisModule)provider).schedule();
        }
    }

    private static AxisRange getDefaultRange() {
        return new AxisRange(((Double)AbstractSegmentStoreDensityView.DEFAULT_RANGE.getFirst()).doubleValue(), ((Double)AbstractSegmentStoreDensityView.DEFAULT_RANGE.getSecond()).doubleValue());
    }

    private void clearContent() {
        Chart chart = this.fChart;
        if (!chart.isDisposed()) {
            ISeriesSet set = chart.getSeriesSet();
            ISeries[] series = set.getSeries();
            int i = 0;
            while (i < series.length) {
                set.deleteSeries(series[i].getId());
                ++i;
            }
            IAxis[] iAxisArray = chart.getAxisSet().getAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                axis.setRange(new Range(0.0, 1.0));
                ++n2;
            }
            chart.redraw();
        }
    }

    public synchronized void setNbPoints(int nbPoints) {
        if (nbPoints < 0) {
            throw new IllegalArgumentException("Number of points cannot be negative");
        }
        this.fOverrideNbPoints = nbPoints;
        this.updateWithRange(this.fCurrentTimeRange);
    }

    public void addDataListener(ISegmentStoreDensityViewerDataListener dataListener) {
        this.fListeners.add(dataListener);
    }

    public void removeDataListener(ISegmentStoreDensityViewerDataListener dataListener) {
        this.fListeners.remove(dataListener);
    }
}

