/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintCategory;
import org.eclipse.viatra.query.runtime.localsearch.planner.cost.IConstraintEvaluationContext;
import org.eclipse.viatra.query.runtime.matchers.backend.ResultProviderRequestor;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryResultProviderAccess;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.analysis.QueryAnalyzer;

public class PConstraintInfo
implements IConstraintEvaluationContext {
    private PConstraint constraint;
    private Set<PVariable> boundMaskVariables;
    private Set<PVariable> freeMaskVariables;
    private Set<PConstraintInfo> sameWithDifferentBindings;
    private IQueryRuntimeContext runtimeContext;
    private QueryAnalyzer queryAnalyzer;
    private IQueryResultProviderAccess resultProviderAccess;
    private ResultProviderRequestor resultRequestor;
    private Double cost;
    private Function<IConstraintEvaluationContext, Double> costFunction;

    public PConstraintInfo(PConstraint constraint, Set<PVariable> boundMaskVariables, Set<PVariable> freeMaskVariables, Set<PConstraintInfo> sameWithDifferentBindings, IQueryBackendContext context, ResultProviderRequestor resultRequestor, Function<IConstraintEvaluationContext, Double> costFunction) {
        this.constraint = constraint;
        this.costFunction = costFunction;
        this.boundMaskVariables = new LinkedHashSet<PVariable>(boundMaskVariables);
        this.freeMaskVariables = new LinkedHashSet<PVariable>(freeMaskVariables);
        this.sameWithDifferentBindings = sameWithDifferentBindings;
        this.resultRequestor = resultRequestor;
        this.runtimeContext = context.getRuntimeContext();
        this.queryAnalyzer = context.getQueryAnalyzer();
        this.resultProviderAccess = context.getResultProviderAccess();
        this.cost = null;
    }

    @Override
    public IQueryRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public QueryAnalyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    @Override
    public PConstraint getConstraint() {
        return this.constraint;
    }

    public Set<PVariable> getFreeVariables() {
        return this.freeMaskVariables;
    }

    public Set<PVariable> getBoundVariables() {
        return this.boundMaskVariables;
    }

    public Set<PConstraintInfo> getSameWithDifferentBindings() {
        return this.sameWithDifferentBindings;
    }

    public double getCost() {
        if (this.cost == null) {
            this.cost = this.costFunction.apply(this);
        }
        return this.cost;
    }

    public PConstraintCategory getCategory(PBody pBody, Set<PVariable> boundVariables) {
        if (!Collections.disjoint(boundVariables, this.freeMaskVariables)) {
            return PConstraintCategory.PAST;
        }
        if (!boundVariables.containsAll(this.boundMaskVariables)) {
            return PConstraintCategory.FUTURE;
        }
        return PConstraintCategory.PRESENT;
    }

    public String toString() {
        return String.format("%s, bound variables: %s, cost: \"%.2f\"", this.constraint.toString(), this.boundMaskVariables.toString(), this.cost);
    }

    @Override
    @Deprecated
    public IQueryResultProviderAccess resultProviderAccess() {
        return this.resultProviderAccess;
    }

    @Override
    public ResultProviderRequestor resultProviderRequestor() {
        return this.resultRequestor;
    }
}

