/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.sourcelookup.internal.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.sourcelookup.advanced.ISourceContainerResolver;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaProjectSourceContainer;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.sourcelookup.internal.launch.MavenArtifactIdentifier;

public class MavenSourceContainerResolver
implements ISourceContainerResolver {
    private static final MavenArtifactIdentifier INDENTIFIER = new MavenArtifactIdentifier();

    public Collection<ISourceContainer> resolveSourceContainers(File classesLocation, IProgressMonitor monitor) {
        Collection<ArtifactKey> classesArtifacts = INDENTIFIER.identify(classesLocation);
        if (classesArtifacts == null) {
            return null;
        }
        ArrayList<ISourceContainer> result = new ArrayList<ISourceContainer>();
        for (ArtifactKey classesArtifact : classesArtifacts) {
            ISourceContainer container = this.resolveSourceContainer(classesArtifact, monitor);
            if (container == null) continue;
            result.add(container);
        }
        return result;
    }

    protected ISourceContainer resolveSourceContainer(ArtifactKey artifact, IProgressMonitor monitor) {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        IMaven maven = MavenPlugin.getMaven();
        IMavenProjectRegistry projectRegistry = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade mavenProject = projectRegistry.getMavenProject(groupId, artifactId, version);
        if (mavenProject != null) {
            return new JavaProjectSourceContainer(JavaCore.create((IProject)mavenProject.getProject()));
        }
        try {
            ArrayList repositories = new ArrayList();
            repositories.addAll(maven.getArtifactRepositories());
            repositories.addAll(maven.getPluginArtifactRepositories());
            if (!maven.isUnavailable(groupId, artifactId, version, "jar", "sources", repositories)) {
                Artifact resolve = maven.resolve(groupId, artifactId, version, "jar", "sources", null, monitor);
                return new ExternalArchiveSourceContainer(resolve.getFile().getAbsolutePath(), true);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }
}

