/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.Messages;

public class LibrarySuperType {
    IPath cpEntry;
    String superTypeName;
    String libraryName;
    IJavaScriptProject javaProject;
    public static final String SUPER_TYPE_CONTAINER = "org.eclipse.wst.jsdt.ui.superType.container";
    public static final String SUPER_TYPE_NAME = "org.eclipse.wst.jsdt.ui.superType.name";

    public LibrarySuperType(IPath classPathEntry, IJavaScriptProject project, String superTypeName) {
        this.cpEntry = classPathEntry;
        this.superTypeName = superTypeName;
        this.javaProject = project;
        this.libraryName = this.initLibraryName();
    }

    public LibrarySuperType(String classPathEntry, IJavaScriptProject project, String superTypeName) {
        this((IPath)new Path(classPathEntry), project, superTypeName);
    }

    public LibrarySuperType(IPath classPathEntry, IJavaScriptProject project) {
        this(classPathEntry, project, null);
    }

    public IPath getRawContainerPath() {
        return this.cpEntry;
    }

    public boolean hasChildren() {
        if (this.superTypeName != null) {
            return false;
        }
        JsGlobalScopeContainerInitializer init = this.getContainerInitializer();
        if (init == null) {
            return false;
        }
        String[] availableSuperTypes = init.containerSuperTypes();
        return availableSuperTypes != null && availableSuperTypes.length > 0;
    }

    public LibrarySuperType[] getChildren() {
        if (this.superTypeName != null) {
            return new LibrarySuperType[0];
        }
        return LibrarySuperType.getFlatLibrarySuperTypes(this.cpEntry, this.javaProject);
    }

    public LibrarySuperType getParent() {
        if (this.superTypeName == null) {
            return null;
        }
        return new LibrarySuperType(this.cpEntry, this.javaProject, null);
    }

    public boolean isParent() {
        return this.getParent() == null;
    }

    public JsGlobalScopeContainerInitializer getContainerInitializer() {
        return LibrarySuperType.getContainerInitializer(this.cpEntry);
    }

    public IIncludePathEntry[] getClasspathEntries() {
        IJsGlobalScopeContainer container = null;
        try {
            container = JavaScriptCore.getJsGlobalScopeContainer(this.cpEntry, this.javaProject);
        }
        catch (JavaScriptModelException ex) {
            ex.printStackTrace();
        }
        if (container != null) {
            return container.getIncludepathEntries();
        }
        return new IIncludePathEntry[0];
    }

    private static LibrarySuperType[] getFlatLibrarySuperTypes(IPath classPathEntry, IJavaScriptProject javaProject) {
        JsGlobalScopeContainerInitializer init = LibrarySuperType.getContainerInitializer(classPathEntry);
        if (init == null) {
            return new LibrarySuperType[0];
        }
        String[] availableSuperTypes = init.containerSuperTypes();
        LibrarySuperType[] libSupers = new LibrarySuperType[availableSuperTypes.length];
        int i = 0;
        while (i < availableSuperTypes.length) {
            libSupers[i] = new LibrarySuperType(classPathEntry, javaProject, availableSuperTypes[i]);
            ++i;
        }
        return libSupers;
    }

    public String getSuperTypeName() {
        return this.superTypeName;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    private String initLibraryName() {
        JsGlobalScopeContainerInitializer init = this.getContainerInitializer();
        if (this.superTypeName == null) {
            if (init == null) {
                return this.cpEntry.toString();
            }
            return init.getDescription(this.cpEntry, this.javaProject);
        }
        LibrarySuperType parent = this.getParent();
        if (!(parent instanceof LibrarySuperType)) {
            return null;
        }
        return parent.getLibraryName();
    }

    public String toString() {
        if (this.isParent()) {
            return this.getLibraryName();
        }
        return Messages.getString("LibrarySuperType.0", new Object[]{this.superTypeName, this.getLibraryName()});
    }

    public boolean equals(Object o) {
        if (!(o instanceof LibrarySuperType)) {
            return false;
        }
        LibrarySuperType other = (LibrarySuperType)o;
        if (other.cpEntry != null && !other.cpEntry.equals((Object)this.cpEntry)) {
            return false;
        }
        if (other.superTypeName == this.superTypeName) {
            return true;
        }
        if (other.superTypeName != null && this.superTypeName != null) {
            return other.superTypeName.equals(this.superTypeName);
        }
        return false;
    }

    public IPackageFragment[] getPackageFragments() {
        IIncludePathEntry[] entries = this.getClasspathEntries();
        ArrayList<IJavaScriptElement> allFrags = new ArrayList<IJavaScriptElement>();
        try {
            int i = 0;
            while (i < entries.length) {
                IPath path = entries[i].getPath();
                IPackageFragmentRoot root = this.javaProject.findPackageFragmentRoot(path.makeAbsolute());
                IJavaScriptElement[] children = root.getChildren();
                int k = 0;
                while (k < children.length) {
                    if (children[k] instanceof IPackageFragment) {
                        allFrags.add(children[k]);
                    }
                    ++k;
                }
                ++i;
            }
        }
        catch (JavaScriptModelException ex) {
            ex.printStackTrace();
        }
        return allFrags.toArray(new IPackageFragment[allFrags.size()]);
    }

    public static JsGlobalScopeContainerInitializer getContainerInitializer(IPath classPathEntry) {
        if (classPathEntry == null) {
            return null;
        }
        JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer(classPathEntry.segment(0));
        return initializer;
    }
}

