/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.wsfinder;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WWWAuthenticationException;

public class LiveWSDLFilter
extends Thread {
    private String wsdlURL_;
    private boolean finish_;
    private boolean live_;

    public LiveWSDLFilter(String wsdlURL) {
        this.wsdlURL_ = wsdlURL;
        this.finish_ = false;
        this.live_ = false;
    }

    public String getWSDLURL() {
        return this.wsdlURL_;
    }

    public boolean isFinish() {
        return this.finish_;
    }

    public boolean isWSDLLive() {
        return this.live_;
    }

    public void run() {
        try {
            try {
                this.live_ = this.validateWSDL();
            }
            catch (Throwable throwable) {
                this.live_ = false;
                this.finish_ = true;
            }
        }
        finally {
            this.finish_ = true;
        }
    }

    private boolean validateWSDL() throws WSDLException, MalformedURLException, IOException, WWWAuthenticationException {
        WebServicesParserExt parser = new WebServicesParserExt();
        Definition definition = parser.getWSDLDefinitionVerbose(this.wsdlURL_);
        Map services = definition.getServices();
        for (Service service : services.values()) {
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                List extensibilityElements = port.getExtensibilityElements();
                for (ExtensibilityElement extensibilityElement : extensibilityElements) {
                    if (!(extensibilityElement instanceof SOAPAddress) && !(extensibilityElement instanceof HTTPAddress)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

