/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.internal.launch.IMavenLauncher;
import org.osgi.service.component.annotations.Component;

@Component(service={IMavenLauncher.class})
public class EclipseMavenLauncher
implements IMavenLauncher {
    public CompletableFuture<?> runMaven(File basedir, String goals, Properties mavenProperties, final boolean interactive) throws CoreException {
        final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.m2e.Maven2LaunchConfigurationType");
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, launchManager.generateLaunchConfigurationName("mavenrun-" + UUID.randomUUID()));
        workingCopy.setAttribute(MavenLaunchConstants.ATTR_POM_DIR, basedir.getAbsolutePath());
        workingCopy.setAttribute("M2_GOALS", goals);
        workingCopy.setAttribute("M2_SAVE_BEFORE_LAUNCH", false);
        workingCopy.setAttribute("M2_BATCH", !interactive);
        ArrayList<String> properties = new ArrayList<String>();
        for (String propertyKey : mavenProperties.stringPropertyNames()) {
            String propertyValue = mavenProperties.getProperty(propertyKey);
            if (propertyKey == null || propertyKey.trim().length() <= 0) continue;
            String prop = String.valueOf(propertyKey.trim()) + (propertyValue == null ? "" : "=" + propertyValue);
            properties.add(prop);
        }
        workingCopy.setAttribute("M2_PROPERTIES", properties);
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        final CompletableFuture run = new CompletableFuture();
        final ILaunchConfiguration configuration = workingCopy.doSave();
        launchManager.addLaunchListener((ILaunchesListener)new ILaunchesListener2(){

            public void launchesRemoved(ILaunch[] launches) {
                this.getMavenLaunch(launches).ifPresent(launch -> {
                    launchManager.removeLaunchListener((ILaunchesListener)this);
                    if (!run.isDone()) {
                        run.cancel(true);
                    }
                });
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesAdded(ILaunch[] launches) {
            }

            public void launchesTerminated(ILaunch[] launches) {
                this.getMavenLaunch(launches).ifPresent(launch -> {
                    launchManager.removeLaunchListener((ILaunchesListener)this);
                    IProcess[] iProcessArray = launch.getProcesses();
                    int n = iProcessArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcess process = iProcessArray[n2];
                        try {
                            int exitValue = process.getExitValue();
                            if (exitValue != 0) {
                                run.completeExceptionally(new RuntimeException("Process exit value was " + exitValue));
                                return;
                            }
                        }
                        catch (DebugException ex) {
                            run.completeExceptionally(ex);
                            return;
                        }
                        ++n2;
                    }
                    if (!interactive) {
                        launchManager.removeLaunch(launch);
                    }
                    run.completeAsync(() -> launch);
                });
            }

            private Optional<ILaunch> getMavenLaunch(ILaunch[] launches) {
                ILaunch[] iLaunchArray = launches;
                int n = launches.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunch launch = iLaunchArray[n2];
                    if (launch.getLaunchConfiguration() == configuration) {
                        return Optional.of(launch);
                    }
                    ++n2;
                }
                return Optional.empty();
            }
        });
        DebugUITools.launch((ILaunchConfiguration)configuration, (String)"run");
        return run;
    }
}

