/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.extensionpoint;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.extensionpoint.IIssueTracker;

public class IssueTrackerInitialization {
    public static final String EXTENSION_ID = "org.eclipse.reddeer.junit.issue.tracker";
    private static final Logger log = Logger.getLogger(IssueTrackerInitialization.class);

    public static List<IIssueTracker> initialize() {
        LinkedList<IIssueTracker> issueTrackers = new LinkedList<IIssueTracker>();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        log.debug("Number of found extensions for extension point org.eclipse.reddeer.junit.issue.tracker=" + configElements.length);
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object object = e.createExecutableExtension("class");
                if (object instanceof IIssueTracker) {
                    issueTrackers.add((IIssueTracker)object);
                } else {
                    log.warn("Invalid class used for extension point org.eclipse.reddeer.junit.issue.tracker:" + object.getClass());
                }
            }
            catch (CoreException ex) {
                ex.printStackTrace();
                log.error("Error when processing extension for org.eclipse.reddeer.junit.issue.tracker", new Object[]{ex.getMessage()});
            }
            ++n2;
        }
        return issueTrackers;
    }
}

