import { MAP, SCALAR, SEQ } from '../nodes/Node.js';
import type { Pair } from '../nodes/Pair.js';
import type { SchemaOptions, ToStringOptions } from '../options.js';
import type { CollectionTag, ScalarTag } from './types.js';
export declare class Schema {
    compat: Array<CollectionTag | ScalarTag> | null;
    knownTags: Record<string, CollectionTag | ScalarTag>;
    merge: boolean;
    name: string;
    sortMapEntries: ((a: Pair, b: Pair) => number) | null;
    tags: Array<CollectionTag | ScalarTag>;
    toStringOptions: Readonly<ToStringOptions> | null;
    [MAP]: CollectionTag;
    [SCALAR]: ScalarTag;
    [SEQ]: CollectionTag;
    constructor({ compat, customTags, merge, resolveKnownTags, schema, sortMapEntries, toStringDefaults }: SchemaOptions);
    clone(): Schema;
}
