/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ModelOperation;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.util.Messages;

public class CopyProjectFragmentOperation
extends ModelOperation {
    IPath destination;
    int updateResourceFlags;
    int updateModelFlags;
    IBuildpathEntry sibling;

    public CopyProjectFragmentOperation(IProjectFragment root, IPath destination, int updateResourceFlags, int updateModelFlags, IBuildpathEntry sibling) {
        super(root);
        this.destination = destination;
        this.updateResourceFlags = updateResourceFlags;
        this.updateModelFlags = updateModelFlags;
        this.sibling = sibling;
    }

    @Override
    protected void executeOperation() throws ModelException {
        IProjectFragment root = (IProjectFragment)this.getElementToProcess();
        IBuildpathEntry rootEntry = root.getRawBuildpathEntry();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!root.isExternal() && (this.updateModelFlags & 1) == 0) {
            this.copyResource(root, rootEntry, workspaceRoot);
        }
        if ((this.updateModelFlags & 8) != 0) {
            this.addEntryToBuildpath(rootEntry, workspaceRoot);
        }
    }

    protected void copyResource(IProjectFragment root, IBuildpathEntry rootEntry, final IWorkspaceRoot workspaceRoot) throws ModelException {
        char[][] exclusionPatterns = ((BuildpathEntry)rootEntry).fullExclusionPatternChars();
        IResource rootResource = root.getResource();
        if (root.getKind() == 3 || exclusionPatterns == null) {
            try {
                if ((this.updateModelFlags & 0x10) != 0) {
                    if (rootEntry.getPath().equals((Object)this.destination)) {
                        return;
                    }
                    IResource destRes = workspaceRoot.findMember(this.destination);
                    if (destRes != null) {
                        destRes.delete(this.updateResourceFlags, this.progressMonitor);
                    }
                }
                rootResource.copy(this.destination, this.updateResourceFlags, this.progressMonitor);
            }
            catch (CoreException e) {
                throw new ModelException(e);
            }
        }
        final int sourceSegmentCount = rootEntry.getPath().segmentCount();
        final IFolder destFolder = workspaceRoot.getFolder(this.destination);
        final IPath[] nestedFolders = this.getNestedFolders(root);
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IResource destRes;
                if (proxy.getType() == 2) {
                    IResource destRes2;
                    IPath path = proxy.requestFullPath();
                    if (CopyProjectFragmentOperation.this.prefixesOneOf(path, nestedFolders)) {
                        if (CopyProjectFragmentOperation.this.equalsOneOf(path, nestedFolders)) {
                            return false;
                        }
                        IFolder folder = destFolder.getFolder(path.removeFirstSegments(sourceSegmentCount));
                        if ((CopyProjectFragmentOperation.this.updateModelFlags & 0x10) != 0 && folder.exists()) {
                            return true;
                        }
                        folder.create(CopyProjectFragmentOperation.this.updateResourceFlags, true, CopyProjectFragmentOperation.this.progressMonitor);
                        return true;
                    }
                    IPath destPath = CopyProjectFragmentOperation.this.destination.append(path.removeFirstSegments(sourceSegmentCount));
                    if ((CopyProjectFragmentOperation.this.updateModelFlags & 0x10) != 0 && (destRes2 = workspaceRoot.findMember(destPath)) != null) {
                        destRes2.delete(CopyProjectFragmentOperation.this.updateResourceFlags, CopyProjectFragmentOperation.this.progressMonitor);
                    }
                    proxy.requestResource().copy(destPath, CopyProjectFragmentOperation.this.updateResourceFlags, CopyProjectFragmentOperation.this.progressMonitor);
                    return false;
                }
                IPath path = proxy.requestFullPath();
                IPath destPath = CopyProjectFragmentOperation.this.destination.append(path.removeFirstSegments(sourceSegmentCount));
                if ((CopyProjectFragmentOperation.this.updateModelFlags & 0x10) != 0 && (destRes = workspaceRoot.findMember(destPath)) != null) {
                    destRes.delete(CopyProjectFragmentOperation.this.updateResourceFlags, CopyProjectFragmentOperation.this.progressMonitor);
                }
                proxy.requestResource().copy(destPath, CopyProjectFragmentOperation.this.updateResourceFlags, CopyProjectFragmentOperation.this.progressMonitor);
                return false;
            }
        };
        try {
            rootResource.accept(visitor, 0);
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
        this.setAttribute("hasModifiedResource", "true");
    }

    protected void addEntryToBuildpath(IBuildpathEntry rootEntry, IWorkspaceRoot workspaceRoot) throws ModelException {
        IBuildpathEntry newEntry;
        int position;
        IProject destProject = workspaceRoot.getProject(this.destination.segment(0));
        IScriptProject jProject = DLTKCore.create(destProject);
        IBuildpathEntry[] buildpath = jProject.getRawBuildpath();
        int length = buildpath.length;
        if ((this.updateModelFlags & 0x10) != 0) {
            int i = 0;
            while (i < length) {
                if (this.destination.equals((Object)buildpath[i].getPath())) {
                    IBuildpathEntry[] newBuildpath = new IBuildpathEntry[length];
                    System.arraycopy(buildpath, 0, newBuildpath, 0, length);
                    newBuildpath[i] = this.copy(rootEntry);
                    jProject.setRawBuildpath(newBuildpath, this.progressMonitor);
                    return;
                }
                ++i;
            }
        }
        if (this.sibling == null) {
            position = length;
        } else {
            position = -1;
            int i = 0;
            while (i < length) {
                if (this.sibling.equals(buildpath[i])) {
                    position = i;
                    break;
                }
                ++i;
            }
        }
        if (position == -1) {
            throw new ModelException(new ModelStatus(993, this.sibling.toString()));
        }
        IBuildpathEntry[] newBuildpath = new IBuildpathEntry[length + 1];
        if (position != 0) {
            System.arraycopy(buildpath, 0, newBuildpath, 0, position);
        }
        if (position != length) {
            System.arraycopy(buildpath, position, newBuildpath, position + 1, length - position);
        }
        newBuildpath[position] = newEntry = this.copy(rootEntry);
        jProject.setRawBuildpath(newBuildpath, this.progressMonitor);
    }

    protected IBuildpathEntry copy(IBuildpathEntry entry) throws ModelException {
        switch (entry.getEntryKind()) {
            case 5: {
                return DLTKCore.newContainerEntry(entry.getPath(), entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported());
            }
            case 1: {
                try {
                    return DLTKCore.newLibraryEntry(this.destination, entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported(), entry.isExternal());
                }
                catch (AssertionFailedException e) {
                    ModelStatus status = new ModelStatus(979, e.getMessage());
                    throw new ModelException(status);
                }
            }
            case 2: {
                return DLTKCore.newProjectEntry(entry.getPath(), entry.getAccessRules(), entry.combineAccessRules(), entry.getExtraAttributes(), entry.isExported());
            }
            case 3: {
                return DLTKCore.newSourceEntry(this.destination, entry.getInclusionPatterns(), entry.getExclusionPatterns(), entry.getExtraAttributes());
            }
        }
        throw new ModelException(new ModelStatus(969, this.getElementToProcess()));
    }

    @Override
    public IModelStatus verify() {
        IModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IProjectFragment root = (IProjectFragment)this.getElementToProcess();
        if (root == null || !root.exists()) {
            return new ModelStatus(969, root);
        }
        IResource resource = root.getResource();
        if (resource instanceof IFolder && resource.isLinked()) {
            return new ModelStatus(995, root);
        }
        if ((this.updateModelFlags & 8) != 0) {
            String destProjectName = this.destination.segment(0);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(destProjectName);
            if (DLTKLanguageManager.hasScriptNature(project)) {
                try {
                    IScriptProject destProject = DLTKCore.create(project);
                    IBuildpathEntry[] destBuildpath = destProject.getRawBuildpath();
                    boolean foundSibling = false;
                    boolean foundExistingEntry = false;
                    int i = 0;
                    int length = destBuildpath.length;
                    while (i < length) {
                        IBuildpathEntry entry = destBuildpath[i];
                        if (entry.equals(this.sibling)) {
                            foundSibling = true;
                            break;
                        }
                        if (entry.getPath().equals((Object)this.destination)) {
                            foundExistingEntry = true;
                        }
                        ++i;
                    }
                    if (this.sibling != null && !foundSibling) {
                        return new ModelStatus(993, this.sibling.toString());
                    }
                    if (foundExistingEntry && (this.updateModelFlags & 0x10) == 0) {
                        return new ModelStatus(977, Messages.bind(Messages.status_nameCollision, this.destination.toString()));
                    }
                }
                catch (ModelException e) {
                    return e.getModelStatus();
                }
            }
        }
        return ModelStatus.VERIFIED_OK;
    }
}

