/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.search.matching.DLTKSearchPattern;

public class MixinPattern
extends DLTKSearchPattern
implements IIndexConstants {
    protected char[] mixinKey;

    public static char[] createIndexKey(char[] fieldName) {
        return fieldName;
    }

    public MixinPattern(char[] key, int matchRule, IDLTKLanguageToolkit toolkit) {
        super(64, matchRule, toolkit);
        this.mixinKey = key;
    }

    @Override
    public void decodeIndexKey(char[] key) {
        this.mixinKey = key;
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new MixinPattern(null, 8, this.getToolkit());
    }

    @Override
    public char[] getIndexKey() {
        return this.mixinKey;
    }

    @Override
    public char[][] getIndexCategories() {
        return new char[][]{MIXIN};
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        return true;
    }

    @Override
    protected StringBuilder print(StringBuilder output) {
        if (this.mixinKey == null) {
            output.append("*");
        } else {
            output.append(this.mixinKey);
        }
        return super.print(output);
    }
}

