/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.core.model;

import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.IScriptValue;
import org.eclipse.dltk.debug.core.model.ScriptModelMessages;

public class ComplexScriptType
extends AtomicScriptType {
    public ComplexScriptType(String name) {
        super(name);
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public String formatDetails(IScriptValue value) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        String address = value.getMemoryAddress();
        if (address == null) {
            address = ScriptModelMessages.unknownMemoryAddress;
        }
        sb.append("@" + address);
        return sb.toString();
    }

    @Override
    public String formatValue(IScriptValue value) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        this.appendInstanceId(value, sb);
        return sb.toString();
    }
}

