/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.binding;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.Messages;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.binding.VisibilityCollector;
import org.eclipse.photran.internal.core.analysis.types.Type;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTOnlyNode;
import org.eclipse.photran.internal.core.parser.ASTRenameNode;
import org.eclipse.photran.internal.core.parser.ASTUseStmtNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IProgramUnit;
import org.eclipse.photran.internal.core.properties.SearchPathProperties;
import org.eclipse.photran.internal.core.vpg.PhotranTokenRef;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;

public class ModuleLoader
extends VisibilityCollector {
    private boolean shouldImportModules;
    private IFile fileContainingUseStmt;
    private IProgressMonitor progressMonitor;
    private ASTUseStmtNode useStmt;
    private Token moduleNameToken;
    private String moduleName;

    @Override
    public void visitASTModuleNode(ASTModuleNode node) {
        this.traverseChildren(node);
        Token moduleName = node.getModuleStmt().getModuleName().getModuleName();
        List<Definition> moduleSymtab = node.getAllPublicDefinitions();
        this.vpgProvider.setModuleSymbolTable(moduleName, moduleSymtab);
    }

    public ModuleLoader(IFile fileContainingUseStmt) {
        this.vpgProvider = PhotranVPG.getProvider();
        this.shouldImportModules = true;
        this.fileContainingUseStmt = fileContainingUseStmt;
        this.progressMonitor = new NullProgressMonitor();
    }

    @Override
    public void visitASTUseStmtNode(ASTUseStmtNode node) {
        super.traverseChildren(node);
        try {
            this.vpgProvider.markFileAsImportingModule(this.fileContainingUseStmt, node.getName().getText());
            if (this.shouldImportModules) {
                this.loadModule(node);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private void loadModule(ASTUseStmtNode node) throws Exception {
        this.useStmt = node;
        this.moduleNameToken = this.useStmt.getName();
        this.moduleName = PhotranVPG.canonicalizeIdentifier(this.moduleNameToken.getText());
        this.progressMonitor.subTask(Messages.bind((String)Messages.ModuleLoader_LoadingModule, (Object)this.moduleName));
        if (this.moduleExistsInFileContainingUseStmt()) {
            this.bindToSymbolsIn(this.fileContainingUseStmt);
        } else {
            this.findModuleInModulePaths();
        }
    }

    private boolean moduleExistsInFileContainingUseStmt() throws Exception {
        return this.findModuleIn(this.fileContainingUseStmt) != null;
    }

    private ASTModuleNode findModuleIn(IFile file) throws Exception {
        ASTExecutableProgramNode fileAST = ((IFortranAST)PhotranVPG.getInstance().acquireTransientAST(file)).getRoot();
        for (IProgramUnit pu : fileAST.getProgramUnitList()) {
            if (!(pu instanceof ASTModuleNode) || !this.isNamed(this.moduleName, (ASTModuleNode)pu)) continue;
            return (ASTModuleNode)pu;
        }
        return null;
    }

    private boolean isNamed(String targetName, ASTModuleNode node) {
        String nameOfThisModule = PhotranVPG.canonicalizeIdentifier(node.getModuleStmt().getModuleName().getModuleName().getText());
        return nameOfThisModule.equals(targetName);
    }

    private void findModuleInModulePaths() throws Exception {
        List<IFile> files = this.vpg.findFilesThatExportModule(this.moduleName);
        if (files.isEmpty()) {
            if (!this.isIntrinsicModule()) {
                this.vpgProvider.logError(Messages.bind((String)Messages.ModuleLoader_NoFilesExportAModuleNamed, (Object)this.moduleName), this.useStmt.getName().getTokenRef());
            }
            return;
        }
        if ((files = this.applyModulePaths(files)).isEmpty()) {
            this.vpgProvider.logError(Messages.bind((String)Messages.ModuleLoader_ModuleNotFoundInModulePathsButFoundElsewhere, (Object)this.moduleName), this.useStmt.getName().getTokenRef());
            return;
        }
        for (IFile file : files) {
            this.bindToSymbolsIn(file);
        }
    }

    private boolean isIntrinsicModule() {
        return this.moduleName.equals("iso_c_binding");
    }

    private List<IFile> applyModulePaths(List<IFile> files) {
        String[] paths = new SearchPathProperties().getListProperty(this.fileContainingUseStmt, "FortranModulePaths");
        if (paths.length == 0) {
            return files;
        }
        LinkedList<IFile> result = new LinkedList<IFile>();
        if (this.findModuleIn(PhotranVPG.getFilenameForIResource((IResource)this.fileContainingUseStmt.getParent()), files, result)) {
            return result;
        }
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (this.findModuleIn(path, files, result)) {
                return result;
            }
            ++n2;
        }
        return result;
    }

    private boolean findModuleIn(String path, List<IFile> files, List<IFile> result) {
        for (IFile file : files) {
            if (!PhotranVPG.getFilenameForIResource((IResource)file.getParent()).startsWith(path)) continue;
            result.add(file);
            if (result.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void bindToSymbolsIn(IFile file) throws Exception {
        PhotranTokenRef moduleToken = this.vpg.getModuleTokenRef(this.moduleName);
        if (moduleToken == null) {
            return;
        }
        this.bind(this.useStmt.getName(), moduleToken);
        ScopingNode newScope = this.useStmt.getUseToken().getEnclosingScope();
        List<Definition> moduleSymtab = this.vpg.getModuleSymbolTable(this.moduleName);
        if (moduleSymtab == null) {
            this.vpgProvider.logError(Messages.bind((String)Messages.ModuleLoader_ModuleNotFoundInFile, (Object)this.moduleName, (Object)file.getFullPath().toOSString()));
        } else {
            for (Definition def : moduleSymtab) {
                if (!this.shouldImportDefinition(def)) continue;
                this.importDefinition(def, newScope);
            }
            this.bindIdentifiersInRenameList(this.useStmt.getRenameList(), moduleSymtab);
            this.bindIdentifiersInOnlyList(this.useStmt.getOnlyList(), moduleSymtab);
        }
    }

    private boolean shouldImportDefinition(Definition def) {
        IASTListNode<ASTRenameNode> renameList = this.useStmt.getRenameList();
        IASTListNode<ASTOnlyNode> onlyList = this.useStmt.getOnlyList();
        if (renameList == null && onlyList == null) {
            return true;
        }
        if (renameList != null) {
            int i = 0;
            while (i < renameList.size()) {
                String entityBeingRenamed = PhotranVPG.canonicalizeIdentifier(((ASTRenameNode)renameList.get(i)).getName().getText());
                if (def.matches(entityBeingRenamed)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i < onlyList.size()) {
            Token useName = ((ASTOnlyNode)onlyList.get(i)).getName();
            String entityToImport = useName == null ? null : PhotranVPG.canonicalizeIdentifier(useName.getText());
            boolean isRenamed = ((ASTOnlyNode)onlyList.get(i)).isRenamed();
            if (def.matches(entityToImport) && !isRenamed) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void bindIdentifiersInRenameList(IASTListNode<ASTRenameNode> renameList, List<Definition> moduleSymtab) throws Exception {
        if (renameList == null) {
            return;
        }
        int i = 0;
        while (i < renameList.size()) {
            if (!((ASTRenameNode)renameList.get(i)).isOperator()) {
                Token newName = ((ASTRenameNode)renameList.get(i)).getNewName();
                Token oldName = ((ASTRenameNode)renameList.get(i)).getName();
                this.bindPossiblyRenamedIdentifier(newName, oldName, moduleSymtab);
            }
            ++i;
        }
    }

    private void bindIdentifiersInOnlyList(IASTListNode<ASTOnlyNode> onlyList, List<Definition> moduleSymtab) throws Exception {
        if (onlyList == null) {
            return;
        }
        int i = 0;
        while (i < onlyList.size()) {
            if (!((ASTOnlyNode)onlyList.get(i)).isOperator()) {
                Token newName = ((ASTOnlyNode)onlyList.get(i)).getNewName();
                Token oldName = ((ASTOnlyNode)onlyList.get(i)).getName();
                if (oldName != null) {
                    this.bindPossiblyRenamedIdentifier(newName, oldName, moduleSymtab);
                }
            }
            ++i;
        }
    }

    private void bindPossiblyRenamedIdentifier(Token newName, Token oldName, List<Definition> moduleSymtab) throws Exception {
        LinkedList<PhotranTokenRef> definitionsInModule = new LinkedList<PhotranTokenRef>();
        String canonicalizedOldName = PhotranVPG.canonicalizeIdentifier(oldName.getText());
        for (Definition definition : moduleSymtab) {
            if (definition == null || !definition.matches(canonicalizedOldName)) continue;
            definitionsInModule.add(definition.getTokenRef());
        }
        for (PhotranTokenRef photranTokenRef : definitionsInModule) {
            this.bindRenamedEntity(newName, photranTokenRef);
            this.bind(oldName, photranTokenRef);
        }
        Type type = definitionsInModule.size() == 1 ? this.vpg.getDefinitionFor((PhotranTokenRef)definitionsInModule.get(0)).getType() : Type.UNKNOWN;
        this.addDefinition(newName, Definition.Classification.RENAMED_MODULE_ENTITY, type);
    }
}

