/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.core.launch.IRemoteLaunchConfigService;

public class RMLaunchUtils {
    public static ILaunchController getLaunchController(ILaunchConfiguration configuration) throws CoreException {
        IRemoteLaunchConfigService launchConfigService;
        IRemoteConnection conn;
        String type = LaunchUtils.getTargetConfigurationName((ILaunchConfiguration)configuration);
        if (type != null && (conn = (launchConfigService = PTPLaunchPlugin.getService(IRemoteLaunchConfigService.class)).getActiveConnection(configuration)) != null) {
            String connName = conn.getName();
            String remId = conn.getConnectionType().getId();
            if (connName != null && remId != null) {
                return LaunchControllerManager.getInstance().getLaunchController(remId, connName, type);
            }
        }
        return null;
    }

    public static IRemoteConnection getRemoteConnection(ILaunchConfiguration configuration) {
        IRemoteLaunchConfigService launchConfigService = PTPLaunchPlugin.getService(IRemoteLaunchConfigService.class);
        return launchConfigService.getActiveConnection(configuration);
    }

    public static void setRemoteConnection(ILaunchConfiguration configuration, IRemoteConnection connection) {
        IRemoteLaunchConfigService launchConfigService = PTPLaunchPlugin.getService(IRemoteLaunchConfigService.class);
        launchConfigService.setActiveConnection(configuration, connection);
    }

    public static IRemoteFileService getLocalFileService(ILaunchConfiguration configuration) {
        IRemoteServicesManager servicesManager = PTPLaunchPlugin.getService(IRemoteServicesManager.class);
        IRemoteConnectionType connType = servicesManager.getLocalConnectionType();
        return (IRemoteFileService)((IRemoteConnection)connType.getConnections().get(0)).getService(IRemoteFileService.class);
    }

    public static IRemoteFileService getRemoteFileService(ILaunchConfiguration configuration) {
        IRemoteConnection conn = RMLaunchUtils.getRemoteConnection(configuration);
        if (conn != null) {
            return (IRemoteFileService)conn.getService(IRemoteFileService.class);
        }
        return null;
    }

    public static IRemoteFileService getRemoteFileService(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        IRemoteConnection conn = RMLaunchUtils.getRemoteConnection(configuration);
        if (conn != null) {
            if (!conn.isOpen()) {
                conn.open((IProgressMonitor)progress.newChild(10));
                if (!progress.isCanceled() && !conn.isOpen()) {
                    throw new CoreException((IStatus)new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), Messages.AbstractParallelLaunchConfigurationDelegate_Connection_is_not_open));
                }
            }
            return (IRemoteFileService)conn.getService(IRemoteFileService.class);
        }
        return null;
    }

    private RMLaunchUtils() {
    }
}

