/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.parser.antlr;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CompositeCondition;
import org.eclipse.xtext.Condition;
import org.eclipse.xtext.Conjunction;
import org.eclipse.xtext.Disjunction;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.LiteralCondition;
import org.eclipse.xtext.NamedArgument;
import org.eclipse.xtext.Negation;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParameterReference;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextSwitch;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.OriginalElement;
import org.eclipse.xtext.xtext.OriginalGrammar;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.RuleWithParameterValues;
import org.eclipse.xtext.xtext.generator.parser.antlr.DebugGrammarToken;
import org.eclipse.xtext.xtext.generator.parser.antlr.FirstSetComputer;

public class AntlrGrammarGenUtil {
    public static String getRuleName(AbstractRule rule) {
        RuleWithParameterValues parameterValues = RuleWithParameterValues.findInEmfObject((Notifier)rule);
        if (parameterValues != null) {
            return rule.getName();
        }
        RuleNames ruleNames = RuleNames.getRuleNames((AbstractRule)rule);
        return ruleNames.getAntlrRuleName(rule);
    }

    public static String getContentAssistRuleName(AbstractRule rule) {
        String ruleName = AntlrGrammarGenUtil.getRuleName(rule);
        if (ruleName.startsWith("rule")) {
            return "rule__" + Strings.toFirstUpper((String)ruleName.substring(4, ruleName.length()));
        }
        return ruleName;
    }

    public static String getEntryRuleName(ParserRule rule) {
        RuleWithParameterValues parameterValues = RuleWithParameterValues.findInEmfObject((Notifier)rule);
        if (parameterValues != null) {
            if (parameterValues.getParamValues().isEmpty()) {
                AbstractRule original = parameterValues.getOriginal();
                RuleNames ruleNames = RuleNames.getRuleNames((AbstractRule)original);
                return "entry" + Strings.toFirstUpper((String)ruleNames.getAntlrRuleName(original));
            }
            return null;
        }
        RuleNames ruleNames = RuleNames.getRuleNames((AbstractRule)rule);
        return "entry" + Strings.toFirstUpper((String)ruleNames.getAntlrRuleName((AbstractRule)rule));
    }

    public static boolean isValidEntryRule(ParserRule rule) {
        if (rule.isFragment()) {
            return false;
        }
        RuleWithParameterValues parameterValues = RuleWithParameterValues.findInEmfObject((Notifier)rule);
        return parameterValues.getParamValues().isEmpty();
    }

    public static <T extends EObject> T getOriginalElement(T obj) {
        if (obj instanceof AbstractRule) {
            AbstractRule result = RuleWithParameterValues.tryGetOriginalRule((AbstractRule)((AbstractRule)obj));
            if (result != null) {
                return (T)result;
            }
            return obj;
        }
        if (obj instanceof Grammar) {
            OriginalGrammar originalGrammar = OriginalGrammar.findInEmfObject(obj);
            return (T)originalGrammar.getOriginal();
        }
        if (obj instanceof AbstractElement) {
            OriginalElement original = OriginalElement.findInEmfObject(obj);
            return (T)original.getOriginal();
        }
        throw new IllegalArgumentException(String.valueOf(obj));
    }

    public static int getParameterConfig(ParserRule rule) {
        return RuleWithParameterValues.getParamConfig((AbstractRule)rule);
    }

    public static String getParameterList(ParserRule rule, Boolean skipCurrent, String currentType) {
        boolean currentAsParam;
        boolean bl = currentAsParam = rule.isFragment() && !GrammarUtil.isDatatypeRule((ParserRule)AntlrGrammarGenUtil.getOriginalElement(rule));
        if ((skipCurrent.booleanValue() || !currentAsParam) && rule.getParameters().isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append("[");
        if (!skipCurrent.booleanValue() && currentAsParam) {
            result.append(currentType).append(" in_current");
            if (!rule.getParameters().isEmpty()) {
                result.append(", ");
            }
        }
        Joiner.on((String)", ").appendTo(result, Iterables.transform((Iterable)rule.getParameters(), (Function)new Function<Parameter, String>(){

            public String apply(Parameter input) {
                return "boolean p_" + input.getName();
            }
        }));
        result.append("] ");
        return result.toString();
    }

    public static String getArgumentList(RuleCall ruleCall, Boolean isPredicate) {
        if (DebugGrammarToken.isGeneratingDebugGrammar()) {
            return "";
        }
        return AntlrGrammarGenUtil.getArgumentList(ruleCall, true, isPredicate);
    }

    public static String getArgumentList(RuleCall ruleCall, boolean passCurrentIntoFragment, boolean isPredicate) {
        boolean needsCurrent;
        EList arguments = ruleCall.getArguments();
        AbstractRule abstractRule = ruleCall.getRule();
        boolean bl = needsCurrent = passCurrentIntoFragment && GrammarUtil.isEObjectFragmentRule((AbstractRule)abstractRule) && !GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)AntlrGrammarGenUtil.getOriginalElement(abstractRule)));
        if (arguments.isEmpty()) {
            if (needsCurrent) {
                return isPredicate ? "[null]" : "[$current]";
            }
            return "";
        }
        ParserRule rule = (ParserRule)abstractRule;
        StringBuilder result = new StringBuilder();
        result.append("[");
        if (needsCurrent) {
            if (isPredicate) {
                result.append("null, ");
            } else {
                result.append("$current, ");
            }
        }
        Joiner.on((String)", ").appendTo(result, Iterables.transform((Iterable)rule.getParameters(), (Function)new Function<Parameter, String>((List)arguments){
            final /* synthetic */ List val$arguments;
            {
                this.val$arguments = list;
            }

            public String apply(Parameter input) {
                for (NamedArgument argument : this.val$arguments) {
                    if (argument.getParameter() != input) continue;
                    return AntlrGrammarGenUtil.conditionToAntlr(argument.getValue(), true);
                }
                throw new IllegalStateException("Cannot find argument for parameter: " + input.getName());
            }
        }));
        result.append("]");
        return result.toString();
    }

    public static String conditionToAntlr(Condition condition, final boolean includeRuleName) {
        final StringBuilder result = new StringBuilder();
        new XtextSwitch<StringBuilder>(){

            public StringBuilder caseDisjunction(Disjunction object) {
                this.doSwitch((EObject)object.getLeft());
                result.append(" || ");
                this.doSwitch((EObject)object.getRight());
                return result;
            }

            public StringBuilder caseConjunction(Conjunction object) {
                this.appendChild(object.getLeft(), Disjunction.class);
                result.append(" && ");
                this.appendChild(object.getRight(), Disjunction.class);
                return result;
            }

            public void appendChild(Condition condition, Class<? extends Condition> parenthesizedIf) {
                if (parenthesizedIf.isInstance(condition)) {
                    result.append('(');
                    this.doSwitch((EObject)condition);
                    result.append(')');
                } else {
                    this.doSwitch((EObject)condition);
                }
            }

            public StringBuilder caseNegation(Negation object) {
                result.append('!');
                this.appendChild(object.getValue(), CompositeCondition.class);
                return result;
            }

            public StringBuilder caseParameterReference(ParameterReference object) {
                Parameter param = object.getParameter();
                if (includeRuleName) {
                    AbstractRule declaringRule = GrammarUtil.containingRule((EObject)param);
                    result.append('$').append(AntlrGrammarGenUtil.getRuleName(declaringRule)).append('.');
                }
                result.append("p_").append(param.getName());
                return result;
            }

            public StringBuilder caseLiteralCondition(LiteralCondition object) {
                return result.append(object.isTrue());
            }
        }.doSwitch((EObject)condition);
        return result.toString();
    }

    public static String getDefaultArgumentList(ParserRule rule) {
        String result = IterableExtensions.join((Iterable)rule.getParameters(), (CharSequence)"[", (CharSequence)", ", (CharSequence)"]", (Functions.Function1)new Functions.Function1<Parameter, String>(){

            public String apply(Parameter p) {
                return Boolean.FALSE.toString();
            }
        });
        return result;
    }

    public static String guardConditionToAntlr(Group group) {
        Condition condition = group.getGuardCondition();
        if (condition == null) {
            return "";
        }
        return "{" + AntlrGrammarGenUtil.conditionToAntlr(condition, false) + "}?=>";
    }

    public static AbstractElement getPredicatedElement(AbstractElement element) {
        if (element.isPredicated()) {
            return AntlrGrammarGenUtil.doGetPredicatedElement(element);
        }
        if (element instanceof Assignment) {
            return AntlrGrammarGenUtil.getPredicatedElement(((Assignment)element).getTerminal());
        }
        if (element instanceof RuleCall) {
            final RuleCall ruleCall = (RuleCall)element;
            final AbstractRule calledRule = ruleCall.getRule();
            Group group = (Group)calledRule.getAlternatives();
            AbstractElement first = (AbstractElement)group.getElements().get(0);
            AbstractElement result = AntlrGrammarGenUtil.getPredicatedElement(first);
            if (ruleCall.getArguments().isEmpty()) {
                return result;
            }
            EcoreUtil.Copier copier = new EcoreUtil.Copier(){
                private static final long serialVersionUID = 1L;

                public EObject copy(EObject eObject) {
                    ParameterReference paramRef;
                    Parameter parameter;
                    if (eObject instanceof ParameterReference && calledRule == GrammarUtil.containingRule((EObject)(parameter = (paramRef = (ParameterReference)eObject).getParameter()))) {
                        for (NamedArgument givenArgument : ruleCall.getArguments()) {
                            if (givenArgument.getParameter() != parameter) continue;
                            EObject result = this.copy((EObject)givenArgument.getValue());
                            return result;
                        }
                        throw new IllegalStateException();
                    }
                    return super.copy(eObject);
                }
            };
            AbstractElement clone = (AbstractElement)copier.copy((EObject)result);
            copier.copyReferences();
            return clone;
        }
        return AntlrGrammarGenUtil.doGetPredicatedElement(element);
    }

    private static AbstractElement doGetPredicatedElement(final AbstractElement element) {
        if (element instanceof Alternatives || element instanceof Group) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true){
                private static final long serialVersionUID = 1L;

                public EObject copy(EObject eObject) {
                    if (eObject instanceof AbstractElement && ((AbstractElement)eObject).isFirstSetPredicated() && this.isLastInGroup(eObject)) {
                        Collection firstSet = EcoreUtil.copyAll(AntlrGrammarGenUtil.getFirstSet((AbstractElement)eObject));
                        if (firstSet.size() == 1) {
                            AbstractElement result = (AbstractElement)firstSet.iterator().next();
                            result.setCardinality(((AbstractElement)eObject).getCardinality());
                            return result;
                        }
                        Alternatives result = XtextFactory.eINSTANCE.createAlternatives();
                        for (AbstractElement firstElement : firstSet) {
                            firstElement.setCardinality(null);
                        }
                        result.getElements().addAll(firstSet);
                        result.setCardinality(((AbstractElement)eObject).getCardinality());
                        return result;
                    }
                    return super.copy(eObject);
                }

                private boolean isLastInGroup(EObject eObject) {
                    EList siblings;
                    if (eObject == element) {
                        return true;
                    }
                    EObject container = eObject.eContainer();
                    if (container instanceof Group && (siblings = ((Group)container).getElements()).get(siblings.size() - 1) == eObject) {
                        return this.isLastInGroup(container);
                    }
                    if (container instanceof Alternatives) {
                        return this.isLastInGroup(container);
                    }
                    return false;
                }
            };
            AbstractElement clone = (AbstractElement)copier.copy((EObject)element);
            copier.copyReferences();
            return clone;
        }
        return element;
    }

    public static String getQualifiedNameAsString(RuleCall ruleCall) {
        AbstractRule rule = AntlrGrammarGenUtil.getOriginalElement(ruleCall).getRule();
        String result = RuleNames.getRuleNames((AbstractRule)rule).getQualifiedName(rule);
        return "\"" + result + "\"";
    }

    public static String toAntlrString(String string) {
        return Strings.convertToJavaString((String)string, (boolean)true).replace("\\\"", "\"");
    }

    public static List<AbstractElement> getFirstSet(AbstractElement element) {
        return FirstSetComputer.getFirstSet(element);
    }

    public static String toStringInAntlrAction(String string) {
        return Strings.convertToJavaString((String)string, (boolean)true).replace("%", "\\%").replace("$", "\\$");
    }

    public static String toAntlrStringIgnoreCase(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char lowerCase;
            char upperCase = Character.toUpperCase(string.charAt(i));
            if (upperCase == (lowerCase = Character.toLowerCase(string.charAt(i)))) {
                sb.append("'");
                sb.append(AntlrGrammarGenUtil.toAntlrString(String.valueOf(upperCase)));
                sb.append("'");
                continue;
            }
            sb.append("('");
            sb.append(AntlrGrammarGenUtil.toAntlrString(String.valueOf(upperCase)));
            sb.append("'|'");
            sb.append(AntlrGrammarGenUtil.toAntlrString(String.valueOf(lowerCase)));
            sb.append("')");
        }
        return sb.toString();
    }

    public static String getClasspathURI(Grammar grammar, EObject object) {
        String fragment = EcoreUtil.getURI((EObject)object).fragment();
        return "classpath:/" + grammar.getName().replace('.', '/') + ".xmi#" + fragment;
    }
}

