/*******************************************************************************
 * Copyright (c) 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.xwt.jface;

import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.xwt.metadata.IObjectInitializer;

public class JFaceInitializer implements IObjectInitializer {

	public void initialize(Object object) {
		if (object instanceof AbstractListViewer) {
			AbstractListViewer viewer = (AbstractListViewer) object;
			viewer.setLabelProvider(new DefaultViewerLabelProvider(viewer));
		}
		else if (object instanceof AbstractTableViewer) {
			AbstractTableViewer viewer = (AbstractTableViewer) object;
			viewer.setLabelProvider(new DefaultViewerLabelProvider(viewer));			
		}
	}
}
